/*
 * Decompiled with CFR 0.152.
 */
package hyperscout3;

import hyperscout3.Plugin;
import java.util.Date;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.Server;
import scone.netobjects.ServerCache;

public class LinkDataProvider {
    public static final String COPYRIGHT = "(C) Harald Weinreich";
    private String linkId = null;
    private String userId = null;
    private Link link = null;
    private NetNode baseNode = null;
    private NetNode toNode = null;
    private HtmlNode baseDoc = null;
    private HtmlNode doc = null;
    private Server server = null;
    private static Plugin plugin;

    public static void init(Plugin p) {
        plugin = p;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
        this.link = LinkCache.getById(linkId);
        this.baseNode = this.link.getFromNode();
        this.baseDoc = HtmlNodeCache.check(this.baseNode);
        this.toNode = this.link.getToNode();
        if (this.toNode.getAccessStatus() != null && this.toNode.getAccessStatus().equals("301") && NetNodeCache.get(this.toNode.toDocString() + "/") != null && NetNodeCache.get(this.toNode.toDocString() + "/").getAccessStatus().equals("200")) {
            this.toNode = NetNodeCache.get(this.toNode.toDocString() + "/");
        }
        this.doc = HtmlNodeCache.check(this.toNode);
        this.server = ServerCache.get(this.toNode.getHost());
    }

    protected String getMarkerType() {
        if (this.isError()) {
            return "R";
        }
        if (this.isRevisit() || this.isRoundtrip()) {
            return "M";
        }
        if (this.isDownload() || this.isEMail() || this.isProtected()) {
            return "Y";
        }
        if (this.isExternal()) {
            return "G";
        }
        if (this.isInDatabase()) {
            return "C";
        }
        return "B";
    }

    protected String getMouseIcons() {
        String icons = "";
        if (this.isRoundtrip()) {
            icons = icons + "r";
        } else {
            if (this.isError()) {
                icons = icons + "e";
            }
            if (this.isProtected()) {
                icons = icons + "s";
            }
            if (this.isDownload()) {
                icons = icons + "t";
            }
            if (this.isRevisit()) {
                icons = icons + "b";
            }
            if (this.isOtherLanguage()) {
                icons = icons + "c";
            }
            if (this.isBig()) {
                icons = icons + "g";
            }
            if (this.isSlow()) {
                icons = icons + "u";
            }
            if (this.isExternal()) {
                icons = icons + "x";
                if (this.isHome()) {
                    icons = icons + "o";
                }
            } else if (this.isHome()) {
                icons = icons + "h";
            }
            if (this.isOld()) {
                icons = icons + "a";
            }
            if (this.isNew()) {
                icons = icons + "n";
            }
            if (this.isNewWindow()) {
                icons = icons + "w";
            }
            if (this.isFragmentUp()) {
                icons = icons + "y";
            }
            if (this.isFragmentDown()) {
                icons = icons + "z";
            }
            if (this.isEMail()) {
                icons = icons + "m";
            }
            if (plugin.getProperties().get("Add topological infos to popup").equals("true") && this.isLinkpage()) {
                icons = icons + "l";
            }
            if (this.isPopupAvailable()) {
                icons = icons + "i";
            }
        }
        icons = (icons + "_____").substring(0, 3);
        return icons;
    }

    private boolean isPopupAvailable() {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        if (this.link.getTitle().length() > 2 && this.link.getAlt().indexOf(this.link.getTitle()) < 0 && (this.doc == null || this.doc.getTitle().length() <= 10)) {
            return true;
        }
        if (!(this.link.getAlt().length() <= 5 || this.link.getTitle().equals(this.link.getAlt()) || this.link.getTitle().indexOf(this.link.getAlt()) >= 0 || this.doc != null && this.doc.getTitle().length() > 10)) {
            return true;
        }
        if (this.doc != null && this.doc.getTitle().length() > 0) {
            return true;
        }
        if (this.doc != null && this.doc.getDescription().length() > 0 && !this.doc.getDescription().equals(this.doc.getTitle()) && !this.doc.getDescription().equals(this.server.getDescription())) {
            return true;
        }
        return this.doc != null && this.doc.getAbstract().length() > 0 && !this.doc.getAbstract().equals(this.doc.getDescription()) && !this.doc.isFrames();
    }

    private boolean isOtherLanguage() {
        String lang;
        return this.doc != null && !this.doc.getLanguage().equals("") && !this.doc.getLanguage().equals(this.baseDoc.getLanguage()) && ((lang = this.doc.getLanguage()).equals("es") || lang.equals("fr"));
    }

    private boolean isOld() {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        long now = new Date().getTime();
        long lastModified = this.toNode.getLastModified();
        return lastModified > 0L && now - lastModified > 31536000000L;
    }

    private boolean isNew() {
        long lastModified;
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        long now = new Date().getTime();
        return now - (lastModified = this.toNode.getLastModified()) < 2592000000L;
    }

    private boolean isRevisit() {
        if (this.isError()) {
            return false;
        }
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        return this.toNode.getLastAccess() > 0L;
    }

    private boolean isRoundtrip() {
        return this.baseNode.toDocString().equals(this.toNode.toDocString()) && this.link.getFragment().length() == 0;
    }

    private boolean isFragmentUp() {
        if (!this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        return this.link.getFragment().length() > 0 && (this.link.getFragment().equalsIgnoreCase("top") || this.link.getFragment().equalsIgnoreCase("head") || this.link.getFragment().equalsIgnoreCase("up") || this.link.getFragment().equalsIgnoreCase("seitenanfang") || this.link.getFragment().equalsIgnoreCase("anfang") || this.link.getFragment().equalsIgnoreCase("0"));
    }

    private boolean isFragmentDown() {
        return this.link.getFragment().length() > 0 && !this.link.getFragment().equalsIgnoreCase("top") && !this.link.getFragment().equalsIgnoreCase("head") && !this.link.getFragment().equalsIgnoreCase("up") && !this.link.getFragment().equalsIgnoreCase("seitenanfang") && !this.link.getFragment().equalsIgnoreCase("anfang");
    }

    private boolean isBig() {
        int size;
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        try {
            size = new Integer(this.toNode.getSize());
        }
        catch (Exception ex) {
            size = 0;
        }
        return size > 100000;
    }

    private boolean isSlow() {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        if (!(!this.toNode.getProtocol().equals("http") && !this.toNode.getProtocol().equals("ftp") || (this.baseNode.getHost().equals(this.toNode.getHost()) || plugin.getProperties().get("Smart external link detection by second level domain").equals("true")) && this.baseNode.getMainHost().equals(this.toNode.getMainHost()))) {
            Server remoteServer = ServerCache.get(this.toNode.getHost());
            if (remoteServer.getAccessStatus().equals("err")) {
                return true;
            }
            if (remoteServer.getAccessStatus().length() > 0 && !remoteServer.getDelay().equals("0") && Integer.parseInt(remoteServer.getDelay()) > 5000) {
                return true;
            }
        }
        return false;
    }

    private boolean isHome() {
        if (this.isError()) {
            return false;
        }
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        return this.toNode.getPath().equals("/") && this.toNode.getFile().equals("");
    }

    private boolean isExternal() {
        return (this.toNode.getProtocol().equals("http") || this.toNode.getProtocol().equals("ftp")) && (!this.baseNode.getHost().equals(this.toNode.getHost()) && !plugin.getProperties().get("Smart external link detection by second level domain").equals("true") || !this.baseNode.getMainHost().equals(this.toNode.getMainHost()));
    }

    private boolean isError() {
        String status = this.toNode.getAccessStatus();
        if (status == null || status.length() < 3) {
            return false;
        }
        return status.equals("400") || status.equals("403") || status.equals("404") || status.equals("408") && !this.baseNode.getHost().equals(this.toNode.getHost()) || status.equals("500") || status.equals("505");
    }

    private boolean isEMail() {
        return this.toNode.getProtocol().equals("mailto");
    }

    private boolean isLinkpage() {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        return this.doc != null && (Integer.parseInt(this.doc.getNumberOfLinks()) - Integer.parseInt(this.doc.getNumberOfExternalLinks()) > 50 && Integer.parseInt(this.doc.getNumberOfLinks()) - Integer.parseInt(this.baseDoc.getNumberOfLinks()) > 10 || Integer.parseInt(this.doc.getNumberOfExternalLinks()) > 20);
    }

    private boolean isProtected() {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        String status = this.toNode.getAccessStatus();
        if (status.equals("401")) {
            return true;
        }
        return this.toNode.getProtocol().equals("https");
    }

    private boolean isDownload() {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return false;
        }
        if (this.toNode.getProtocol().equals("https")) {
            return false;
        }
        if (!(this.isError() || this.toNode.getProtocol().equals("http") || this.toNode.getProtocol().equals("mailto"))) {
            return true;
        }
        String mimeType = this.toNode.getMimeType();
        return mimeType != null && !mimeType.equals("null") && !mimeType.equals("") && mimeType.indexOf("text/html") == -1 && mimeType.indexOf("application/x-httpd-php") == -1 && mimeType.indexOf("application/x-perl") == -1 && mimeType.indexOf("application/x-sh") == -1;
    }

    private boolean isNewWindow() {
        if (this.toNode.toDocString().toLowerCase().startsWith("javascript:") && this.toNode.toDocString().toLowerCase().indexOf("window") > 0) {
            return true;
        }
        return this.link.getTarget().equalsIgnoreCase("_blank");
    }

    protected boolean isInDatabase() {
        if (this.doc != null && this.doc.getTitle().length() > 0) {
            return true;
        }
        if (this.doc != null && this.doc.getDescription().length() > 0 && !this.doc.getDescription().equals(this.doc.getTitle()) && !this.doc.getDescription().equals(this.server.getDescription())) {
            return true;
        }
        if (this.doc != null && this.doc.getAbstract().length() > 0 && !this.doc.getAbstract().equals(this.doc.getDescription()) && !this.doc.isFrames()) {
            return true;
        }
        String mimeType = this.toNode.getMimeType();
        return mimeType != null && !mimeType.equals("null") && !mimeType.equals("") && mimeType.indexOf("text/html") == 1;
    }
}

