/*
 * Decompiled with CFR 0.152.
 */
package hyperscout3;

import hyperscout3.Plugin;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;
import scone.netobjects.LinkVector;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.Server;
import scone.netobjects.ServerCache;
import scone.ras.Connection;
import scone.ras.ConnectionHandler;

public class PopupDataGenerator
implements ConnectionHandler {
    public static final String COPYRIGHT = "(C) Harald Weinreich";
    private String linkId = null;
    private String userId = null;
    private Link link = null;
    private NetNode baseNode = null;
    private NetNode toNode = null;
    private HtmlNode baseDoc = null;
    private HtmlNode doc = null;
    private Server server = null;
    private LinkVector links = null;
    private static Plugin plugin;
    private static Hashtable mimeTypeTable;
    private static Hashtable statusTable;

    public static void init(Plugin p) {
        plugin = p;
    }

    public void handle(Connection c) {
        boolean i = false;
        try {
            this.linkId = c.read();
            if (this.linkId != null && !this.linkId.equals("null")) {
                System.out.print("PDG: linkid " + this.linkId);
                this.link = LinkCache.getById(this.linkId);
                this.userId = c.read();
                System.out.print(" - userId " + this.userId);
                c.write("--begin");
                this.baseNode = this.link.getFromNode();
                this.baseDoc = HtmlNodeCache.check(this.baseNode);
                this.toNode = this.link.getToNode();
                if (this.toNode.getAccessStatus().equals("301") && NetNodeCache.get(this.toNode.toDocString() + "/") != null && NetNodeCache.get(this.toNode.toDocString() + "/").getAccessStatus().equals("200")) {
                    this.toNode = NetNodeCache.get(this.toNode.toDocString() + "/");
                }
                this.doc = HtmlNodeCache.check(this.toNode);
                this.server = ServerCache.get(this.toNode.getHost());
                if (this.toNode.getProtocol().equals("http") && (this.doc == null || this.doc.getTitle().length() == 0)) {
                    c.write("noCache");
                } else {
                    c.write("cache");
                }
                this.addAccessInfo(c);
                if (Integer.parseInt(this.toNode.getAccessStatus()) < 400) {
                    this.addBasicContentInfo(c);
                }
                this.addLinkMetaInfo(c);
                if (plugin.getProperties().get("Add topological infos to popup").equals("true")) {
                    this.addTopologicalInfo(c);
                }
                this.addUsageInfo(c);
                if (plugin.getProperties().get("Add format infos to popup").equals("true")) {
                    this.addFormatInfo(c);
                    this.addLinkTargetTypeInfo(c);
                }
                this.addPerformanceInfo(c);
                if (plugin.getProperties().get("Add extended meta infos to popup").equals("true") && Integer.parseInt(this.toNode.getAccessStatus()) < 400) {
                    this.addMetaContentInfo(c);
                }
                this.addActionInfo(c);
                this.addDistributionInfo(c);
                if (plugin.getProperties().get("Add URI to popup").equals("true")) {
                    this.tableLine(c, "URL", this.toNode.toDocString(), "url.gif", "F0F0F0");
                    if (!this.baseNode.toDocString().equals(this.toNode.toDocString()) && this.link.getFragment().length() > 0) {
                        this.tableLine(c, "Verweis ", "Sprung nach '" + this.link.getFragment() + "'", "down.gif", "D8F8FF");
                    }
                }
                System.out.println(" OK.");
            } else {
                System.out.println("PDG: aborted");
            }
            c.write("--end");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addLinkMetaInfo(Connection c) throws IOException {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return;
        }
        if (this.link.getTitle().length() > 2 && this.link.getAlt().indexOf(this.link.getTitle()) < 0 && (this.doc == null || this.doc.getTitle().length() < 0)) {
            this.tableLine(c, "Link Titel", this.link.getTitle(), "info.gif", "FFFFFF");
        }
        if (!(this.link.getAlt().length() <= 5 || this.link.getTitle().equals(this.link.getAlt()) || this.link.getTitle().indexOf(this.link.getAlt()) >= 0 || this.doc != null && this.doc.getTitle().length() >= 0)) {
            this.tableLine(c, "Bild Titel", this.link.getAlt(), "info.gif", "FFFFFF");
        }
    }

    private void addBasicContentInfo(Connection c) throws IOException {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return;
        }
        if (this.doc != null && this.doc.getTitle().length() > 0) {
            this.tableLine(c, "Titel", this.doc.getTitle(), "info.gif");
        }
        if (this.doc != null && this.doc.getDescription().length() > 0 && !this.doc.getDescription().equals(this.doc.getTitle()) && this.doc.getTitle().indexOf(this.doc.getDescription()) < 0 && !this.doc.getDescription().equals(this.server.getDescription())) {
            this.tableLine(c, "Beschreib.", this.doc.getDescription(), "colors/blank.gif");
        } else if (this.doc != null && this.doc.getAbstract().length() > 0 && !this.doc.getAbstract().equals(this.doc.getDescription()) && !this.doc.isFrames()) {
            this.tableLine(c, "Inhalt", this.doc.getAbstract(), "colors/blank.gif");
        }
    }

    private void addMetaContentInfo(Connection c) throws IOException {
        long lastModified;
        long now;
        String lang;
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return;
        }
        if (!(this.doc == null || this.doc.getLanguage().equals("") || this.doc.getLanguage().equals(this.baseDoc.getLanguage()) || (lang = this.doc.getLanguage()).equals("?"))) {
            String image = "language.gif";
            if (lang.equals("es")) {
                lang = "Spanisch";
                image = "spanish.gif";
                this.tableLine(c, "Sprache", lang, image, "F0F0F0");
            }
            if (lang.equals("fr")) {
                lang = "Franz\u00f6sisch";
                image = "french.gif";
                this.tableLine(c, "Sprache", lang, image, "F0F0F0");
            }
        }
        if ((now = new Date().getTime()) - (lastModified = this.toNode.getLastModified()) < 3600000L) {
            this.tableLine(c, "Neu", "Ge\u00e4ndert vor " + String.valueOf((now - lastModified) / 1000L / 60L) + " Minuten", "new.gif", "F0F0F0");
        } else if (now - lastModified < 172800000L) {
            this.tableLine(c, "Neu", "Ge\u00e4ndert vor " + String.valueOf((now - lastModified) / 1000L / 60L / 60L) + " Stunden " + String.valueOf((now - lastModified) / 1000L / 60L / 60L) + " Minuten", "new.gif", "F0F0F0");
        } else if (now - lastModified < 2592000000L) {
            this.tableLine(c, "Neu", "Ge\u00e4ndert vor " + String.valueOf((now - lastModified) / 1000L / 60L / 60L / 24L) + " Tagen", "new.gif", "F0F0F0");
        } else if (lastModified > 0L) {
            Date lastModifiedDate = new Date(lastModified);
            SimpleDateFormat formatter = new SimpleDateFormat("EEEEEEEEE, dd. MMMMMMMMMMM yyyy", Locale.GERMANY);
            String dateString = formatter.format(lastModifiedDate);
            if (now - lastModified > 31536000000L) {
                this.tableLine(c, "Alt", "Ge\u00e4ndert am " + dateString, "old.gif", "F0F0F0");
            }
        }
    }

    private void addUsageInfo(Connection c) throws IOException {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return;
        }
        if (this.toNode.getLastAccess() > 0L) {
            long now = new Date().getTime();
            int accessCount = AccessCache.getAccessCount("where userid='" + this.userId + "' && nodeid='" + this.toNode.getNodeId() + "' ");
            if (accessCount > 0) {
                Vector accesses = AccessCache.getAccesses("where userid='" + this.userId + "' && nodeid='" + this.toNode.getNodeId() + "' order by time desc limit 0,1");
                Access lastAccessObject = (Access)accesses.get(0);
                long lastAccess = lastAccessObject.getTime();
                if (now - lastAccess < 3600000L) {
                    this.tableLine(c, "Bekannt", "Vor " + String.valueOf((now - lastAccess) / 1000L / 60L) + " Minuten besucht, schon " + String.valueOf(accessCount) + " mal gesehen", "back.gif", "E8D8FF");
                } else if (now - lastAccess < 172800000L) {
                    this.tableLine(c, "Bekannt", "Vor " + String.valueOf((now - lastAccess) / 1000L / 60L / 60L) + "h " + String.valueOf((now - lastAccess) / 1000L / 60L / 60L) + "min besucht, schon " + String.valueOf(accessCount) + " mal gesehen", "back.gif", "E8D8FF");
                } else if (now - lastAccess < 7776000000L) {
                    this.tableLine(c, "Bekannt", "Vor " + String.valueOf((now - lastAccess) / 1000L / 60L / 60L / 24L) + " Tagen besucht, schon " + String.valueOf(accessCount) + " mal gesehen", "back.gif", "E8D8FF");
                } else {
                    Date lastAccessDate = new Date(lastAccess);
                    SimpleDateFormat formatter = new SimpleDateFormat("EEEEEEEE, dd. MMMMMMMM yyyy", Locale.GERMANY);
                    String dateString = formatter.format(lastAccessDate);
                    this.tableLine(c, "Bekannt", "Zuletzt am " + dateString + " besucht, schon " + String.valueOf(this.toNode.getAccessCounter()) + " mal gesehen", "back.gif", "E8D8FF");
                }
            }
        }
    }

    private void addTopologicalInfo(Connection c) throws IOException {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            if (this.link.getFragment().length() == 0) {
                this.tableLine(c, "Identisch", "Zeigt zu diesem Dokument", "reload.gif", "E8D8FF");
                return;
            }
        } else if (Integer.parseInt(this.toNode.getAccessStatus()) < 400) {
            if (this.doc != null && this.doc.getNumberOfLinks().equals("0") && !this.doc.isFrames() && this.doc.getAbstract().length() > 0) {
                this.tableLine(c, "Sackgasse", "Dokument ohne weiterf\u00fchrende Links", "deadend.gif", "F0F0F0");
            }
            if (this.doc != null && (Integer.parseInt(this.doc.getNumberOfLinks()) - Integer.parseInt(this.doc.getNumberOfExternalLinks()) > 50 && Integer.parseInt(this.doc.getNumberOfLinks()) - Integer.parseInt(this.baseDoc.getNumberOfLinks()) > 10 || Integer.parseInt(this.doc.getNumberOfExternalLinks()) > 20)) {
                String popuptext = "";
                if (Integer.parseInt(this.doc.getNumberOfExternalLinks()) > 20) {
                    popuptext = popuptext + this.doc.getNumberOfExternalLinks() + " externe Links  ";
                }
                if (Integer.parseInt(this.doc.getNumberOfLinks()) - Integer.parseInt(this.doc.getNumberOfExternalLinks()) > 50) {
                    popuptext = popuptext + String.valueOf(Integer.parseInt(this.doc.getNumberOfLinks()) - Integer.parseInt(this.doc.getNumberOfExternalLinks())) + " interne Links";
                }
                this.tableLine(c, "Link-Seite", popuptext, "index.gif", "F0F0F0");
            }
        }
    }

    private void addDistributionInfo(Connection c) throws IOException {
        if (!(!this.toNode.getProtocol().equals("http") && !this.toNode.getProtocol().equals("ftp") || (this.baseNode.getHost().equals(this.toNode.getHost()) || plugin.getProperties().get("Smart external link detection by second level domain").equals("true")) && this.baseNode.getMainHost().equals(this.toNode.getMainHost()))) {
            String servertitel = "";
            if (this.server != null && this.server.getTitle().length() > 0) {
                servertitel = this.server.getTitle();
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Home page", "");
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Homepage of ", "");
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Homepage der ", "");
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Homepage des ", "");
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Homepage", "");
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Welcome to ", "");
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Welcome! ", "");
                servertitel = PopupDataGenerator.stringReplaceIgnoreCase(servertitel, "Welcome. ", "");
                servertitel = PopupDataGenerator.stringReplace(servertitel, "Startseite", "");
                servertitel = PopupDataGenerator.stringReplace(servertitel, "- ", "");
            }
            if (!this.toNode.getPath().equals("/") || !this.toNode.getFile().equals("")) {
                String path = this.toNode.getPath();
                if (this.toNode.getPath().length() > 20) {
                    path = this.toNode.getPath().substring(0, 19) + "../";
                }
                if (!servertitel.equals("")) {
                    this.tableLine(c, "Extern", servertitel, "out.gif", "D0FFD0");
                    this.tableLine(c, "", this.toNode.getHost() + path + this.toNode.getFile(), "colors/blank.gif", "D0FFD0");
                } else {
                    this.tableLine(c, "", this.toNode.getHost() + path + this.toNode.getFile(), "out.gif", "D0FFD0");
                }
            } else if (!servertitel.equals("")) {
                this.tableLine(c, "Extern", servertitel, "out.gif", "D0FFD0");
                this.tableLine(c, "Homepage", this.toNode.getHost(), "home.gif", "D0FFD0");
            } else {
                this.tableLine(c, "Homepage", this.toNode.getHost(), "out.gif", "D0FFD0");
            }
        }
        if (this.baseNode.getHost().equals(this.toNode.getHost()) && !this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            if (this.toNode.getPath().equals("/") && this.toNode.getFile().equals("")) {
                this.tableLine(c, "Homepage", this.toNode.getHost() + "/ (Homepage dieses Servers)", "home.gif", "D8F8FF");
            } else if (this.baseNode.getPath().equals(this.toNode.getPath())) {
                String path = this.toNode.getPath();
                if (this.toNode.getPath().length() > 20) {
                    path = this.toNode.getPath().substring(0, 19) + "../";
                }
                if (this.toNode.getFile().equals("")) {
                    this.tableLine(c, "", this.toNode.getHost() + path, "root.gif", "D8F8FF");
                } else if (!this.baseNode.toDocString().equals(this.toNode.toDocString())) {
                    this.tableLine(c, "", this.toNode.getHost() + path + this.toNode.getFile(), "cluster.gif", "D8F8FF");
                }
            } else if (this.baseNode.getPath().startsWith(this.toNode.getPath()) || this.toNode.getPath().startsWith(this.baseNode.getPath()) && this.toNode.getPath().endsWith("/../")) {
                this.tableLine(c, "", this.toNode.getHost() + this.toNode.getPath(), "higher.gif", "D8F8FF");
            } else if (this.toNode.getPath().startsWith(this.baseNode.getPath()) && this.baseNode.getPath().equals("/")) {
                this.tableLine(c, "", this.toNode.getHost() + this.toNode.getPath() + this.toNode.getFile(), "deeper.gif", "D8F8FF");
            } else if (this.toNode.getPath().startsWith(this.baseNode.getPath())) {
                this.tableLine(c, "", this.toNode.getHost() + "/.. ../" + this.toNode.getPath().substring(this.baseNode.getPath().length()) + this.toNode.getFile(), "deeper.gif", "D8F8FF");
            } else {
                this.tableLine(c, "", this.toNode.getHost() + this.toNode.getPath() + this.toNode.getFile(), "same.gif", "D8F8FF");
            }
        }
        if (this.toNode.getQuery().length() > 0) {
            this.tableLine(c, "Query", this.toNode.getQuery(), "questionmark.gif", "D8F8FF");
        }
        if (this.link.getFragment().length() > 0) {
            if (this.link.getFragment().equalsIgnoreCase("top") || this.link.getFragment().equalsIgnoreCase("head") || this.link.getFragment().equalsIgnoreCase("up") || this.link.getFragment().equalsIgnoreCase("seitenanfang") || this.link.getFragment().equalsIgnoreCase("anfang") || this.link.getFragment().equalsIgnoreCase("0")) {
                this.tableLine(c, "Verweis ", "Zum Kopf der Seite", "up.gif", "D8F8FF");
            } else if (this.link.getFragment().equalsIgnoreCase("bottom") || this.link.getFragment().equalsIgnoreCase("foot") || this.link.getFragment().equalsIgnoreCase("down") || this.link.getFragment().equalsIgnoreCase("seitenende") || this.link.getFragment().equalsIgnoreCase("ende")) {
                this.tableLine(c, "Verweis ", "Zum Fu\u00df der Seite", "down.gif", "D8F8FF");
            } else {
                this.tableLine(c, "Verweis ", "Browser scrollt nach '" + this.link.getFragment() + "'", "down.gif", "D8F8FF");
            }
        }
    }

    private void addAccessInfo(Connection c) throws IOException {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return;
        }
        String status = this.toNode.getAccessStatus();
        String statusText = this.statusDescription(status);
        if (!(status == null || status.length() == 0 || status.equals("200") || status.equals("304") || status.equals("408") && this.baseNode.getHost().equals(this.toNode.getHost()) || statusText.length() <= 0)) {
            if (status.equals("401") || status.equals("402")) {
                this.tableLine(c, "Status", statusText, "secure.gif", "FFFFB0");
            } else {
                this.tableLine(c, "Status", statusText, "flash.gif", "FFD0D0");
            }
        }
    }

    private void addPerformanceInfo(Connection c) throws IOException {
        int size;
        try {
            size = new Integer(this.toNode.getSize());
        }
        catch (Exception ex) {
            size = 0;
        }
        if (size > 100000) {
            this.tableLine(c, "Gro\u00dfe Datei", new Integer(size /= 1024).toString() + " kByte", "size.gif", "F0F0F0");
        }
        if (!(!this.toNode.getProtocol().equals("http") && !this.toNode.getProtocol().equals("ftp") || (this.baseNode.getHost().equals(this.toNode.getHost()) || plugin.getProperties().get("Smart external link detection by second level domain").equals("true")) && this.baseNode.getMainHost().equals(this.toNode.getMainHost()))) {
            Server remoteServer = ServerCache.get(this.toNode.getHost());
            if (remoteServer.getAccessStatus().equals("err")) {
                this.tableLine(c, "Status", "Server is propably unreachable!", "flash.gif", "FFD0D0");
            } else if (remoteServer.getAccessStatus().length() > 0 && !remoteServer.getDelay().equals("0") && Integer.parseInt(remoteServer.getDelay()) > 5000) {
                this.tableLine(c, "Langsam", "Antwortzeit ist " + Integer.toString(Integer.parseInt(remoteServer.getDelay()) / 1000) + "s", "slow.gif", "FFFFD0");
            }
        }
    }

    private void addActionInfo(Connection c) throws IOException {
        if (this.toNode.toDocString().toLowerCase().startsWith("javascript:") && this.toNode.toDocString().toLowerCase().indexOf("window") > 0) {
            this.tableLine(c, "Aktion", "JavaScript: \u00f6ffnet neues Fenster", "window.gif", "FFFFD0");
        } else if (this.toNode.toDocString().toLowerCase().startsWith("javascript:")) {
            this.tableLine(c, "Aktion", "JavaScript!", "javascript.gif", "FFFFD0");
        } else if (this.link.getTarget() != null && this.link.getTarget().length() != 0 && this.link.getTarget().equalsIgnoreCase("_blank")) {
            this.tableLine(c, "Aktion", "\u00d6ffnet neues Fenster", "window.gif", "F0FFFF");
        }
    }

    private void addLinkTargetTypeInfo(Connection c) throws IOException {
        if (this.toNode.getProtocol().equals("mailto")) {
            this.tableLine(c, "E-Mail an", this.toNode.getOpaquePart(), "e-mail.gif", "FFFFD0");
        }
        if (this.toNode.getProtocol().equals("ftp")) {
            if (this.toNode.getFile().equals("")) {
                this.tableLine(c, "Aktion", "ftp-Verzeichnis", "ftpdir.gif", "FFFFD0");
            } else {
                this.tableLine(c, "Aktion", "Starte download", "download.gif", "FFFFD0");
            }
        }
        if (this.toNode.getProtocol().equals("https")) {
            this.tableLine(c, "Aktion", "Geschicherte Verbindung", "secure.gif", "FFFFD0");
        }
        if (this.toNode.getProtocol().equals("telnet")) {
            this.tableLine(c, "Aktion", "Telnet-Sitzung", "telnet.gif", "FFFFD0");
        }
    }

    private void addFormatInfo(Connection c) throws IOException {
        String mimeType = this.toNode.getMimeType();
        if (mimeType != null && !mimeType.equals("null") && this.mimeTypeDescription(mimeType).length() != 0 && mimeType.indexOf("text/html") == -1) {
            if (mimeType.indexOf("text") > 0) {
                this.tableLine(c, "Text", this.mimeTypeDescription(mimeType), "plaintext.gif", "FFFFB0");
            } else if (mimeType.indexOf("zip") > 0) {
                this.tableLine(c, "Zipped", this.mimeTypeDescription(mimeType), "compress.gif", "FFFFB0");
            } else if (mimeType.indexOf("image") > 0) {
                this.tableLine(c, "Bild", this.mimeTypeDescription(mimeType), "eye.gif", "FFFFB0");
            } else if (mimeType.indexOf("model") > 0) {
                this.tableLine(c, "Modell", this.mimeTypeDescription(mimeType), "vrmodel.gif", "FFFFB0");
            } else if (mimeType.indexOf("video") > 0) {
                this.tableLine(c, "Video", this.mimeTypeDescription(mimeType), "video.gif", "FFFFB0");
            } else if (mimeType.indexOf("audio") > 0) {
                this.tableLine(c, "Audio", this.mimeTypeDescription(mimeType), "sound.gif", "FFFFB0");
            } else if (mimeType.indexOf("pdf") > 0) {
                this.tableLine(c, "Dokument", this.mimeTypeDescription(mimeType), "pdf.gif", "FFFFB0");
            } else {
                this.tableLine(c, "Typ", this.mimeTypeDescription(mimeType), "download.gif", "FFFFB0");
            }
        }
    }

    private void tableLine(Connection c, String title, String text, String image) throws IOException {
        this.tableLine(c, title, text, image, "FFFFFF");
    }

    private void tableLine(Connection c, String title, String text, String image, String color) throws IOException {
        c.write("--line");
        c.write("picons/" + image);
        c.write(title);
        c.write(text);
        c.write(color);
    }

    public static String stringReplace(String source, String search, String replace) {
        String origSource = new String(source);
        int spot = source.indexOf(search);
        String returnString = spot > -1 ? "" : source;
        while (spot > -1) {
            if (spot == source.length() + 1) {
                returnString = returnString.concat(source.substring(0, source.length() - 1).concat(replace));
                source = "";
            } else if (spot > 0) {
                returnString = returnString.concat(source.substring(0, spot).concat(replace));
                source = source.substring(spot + search.length(), source.length());
            } else {
                returnString = returnString.concat(replace);
                source = source.substring(spot + search.length(), source.length());
            }
            spot = source.indexOf(search);
        }
        if (!source.equals(origSource)) {
            return returnString.concat(source);
        }
        return returnString;
    }

    public static String stringReplaceIgnoreCase(String source, String search, String replace) {
        String origSource = new String(source);
        search = search.toLowerCase();
        int spot = source.toLowerCase().indexOf(search);
        String returnString = spot > -1 ? "" : source;
        while (spot > -1) {
            if (spot == source.length() + 1) {
                returnString = returnString.concat(source.substring(0, source.length() - 1).concat(replace));
                source = "";
            } else if (spot > 0) {
                returnString = returnString.concat(source.substring(0, spot).concat(replace));
                source = source.substring(spot + search.length(), source.length());
            } else {
                returnString = returnString.concat(replace);
                source = source.substring(spot + search.length(), source.length());
            }
            spot = source.toLowerCase().indexOf(search);
        }
        if (!source.equals(origSource)) {
            return returnString.concat(source);
        }
        return returnString;
    }

    private String mimeTypeDescription(String type) {
        String description = "";
        if (type != null) {
            description = (String)mimeTypeTable.get(type);
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    private String statusDescription(String status) {
        String description = "";
        if (status != null) {
            description = (String)statusTable.get(status);
        }
        if (description == null) {
            description = "Unknown status of page!";
        }
        return description;
    }

    static {
        mimeTypeTable = new Hashtable();
        mimeTypeTable.put(new String("application/excel"), new String("Microsoft Excel Tabelle"));
        mimeTypeTable.put(new String("application/mac-binhex40"), new String("Macintosh Compressed File (Binhex)"));
        mimeTypeTable.put(new String("application/pdf"), new String("Adobe Acrobat Dokument (pdf)"));
        mimeTypeTable.put(new String("application/zip"), new String("ZIP-Komprimierte Datei"));
        mimeTypeTable.put(new String("image/gif"), new String("Graphik (gif)"));
        mimeTypeTable.put(new String("image/jpeg"), new String("Graphik (jpeg)"));
        mimeTypeTable.put(new String("image/png"), new String("Graphik (png)"));
        mimeTypeTable.put(new String("application/msword"), new String("Microsoft Word Dokument"));
        mimeTypeTable.put(new String("application/octet-stream"), new String("Daten"));
        mimeTypeTable.put(new String("application/java-vm"), new String("Java Programm"));
        mimeTypeTable.put(new String("application/pgp"), new String("Pretty Good Privacy (PGP) Schl\u00fcssel"));
        mimeTypeTable.put(new String("application/postscript"), new String("Postscript-Datei"));
        mimeTypeTable.put(new String("application/powerpoint"), new String("Microsoft Powerpoint Pr\u00e4sentation"));
        mimeTypeTable.put(new String("application/rtf"), new String("Rich Text Format Datei (rtf)"));
        mimeTypeTable.put(new String("application/x-perl"), new String("Dynamisch erstelltes Web Dokument"));
        mimeTypeTable.put(new String("application/x-sh"), new String("Dynamisch erstelltes Web Dokument"));
        mimeTypeTable.put(new String("application/wordperfect5.1"), new String("Word Perfect Document"));
        mimeTypeTable.put(new String("application/x-cdlink"), new String(""));
        mimeTypeTable.put(new String("application/x-compress"), new String("Komprimierte Datei (Unix)"));
        mimeTypeTable.put(new String("application/x-cpio"), new String(""));
        mimeTypeTable.put(new String("application/x-csh"), new String(""));
        mimeTypeTable.put(new String("application/x-debian-package"), new String(""));
        mimeTypeTable.put(new String("application/x-director"), new String("Shockwave Animation"));
        mimeTypeTable.put(new String("application/x-shockwave-flash"), new String("Flash Animation"));
        mimeTypeTable.put(new String("application/x-dvi"), new String(""));
        mimeTypeTable.put(new String("application/x-gtar"), new String("Komprimiertes Archiv (Unix)"));
        mimeTypeTable.put(new String("application/x-gzip"), new String("Komprimierte Datei (Unix, gzip)"));
        mimeTypeTable.put(new String("application/x-hdf"), new String(""));
        mimeTypeTable.put(new String("application/x-httpd-php"), new String("Dynamisch erstelltes Dokument"));
        mimeTypeTable.put(new String("application/x-JavaScript"), new String("JavaScript Programm"));
        mimeTypeTable.put(new String("application/x-latex"), new String("Latex Dokument"));
        mimeTypeTable.put(new String("application/x-mif"), new String(""));
        mimeTypeTable.put(new String("application/x-msdos-program"), new String("Ausf\u00fchrbares Programm (PCs/Windows)"));
        mimeTypeTable.put(new String("application/x-netcdf"), new String(""));
        mimeTypeTable.put(new String("application/x-netcdf"), new String(""));
        mimeTypeTable.put(new String("application/x-stuffit"), new String(""));
        mimeTypeTable.put(new String("application/x-tar"), new String("Unix Archiv (tar)"));
        mimeTypeTable.put(new String("application/x-tcl"), new String("TCL Programm"));
        mimeTypeTable.put(new String("application/x-tex"), new String("TEX Dokument"));
        mimeTypeTable.put(new String("application/x-texinfo"), new String(""));
        mimeTypeTable.put(new String("application/x-troff-man"), new String("Unix manual pages file"));
        mimeTypeTable.put(new String("application/x-troff-me"), new String(""));
        mimeTypeTable.put(new String("application/x-troff-ms"), new String(""));
        mimeTypeTable.put(new String("application/x-ustar"), new String(""));
        mimeTypeTable.put(new String("application/x-wais-source"), new String("Source File"));
        mimeTypeTable.put(new String("audio/basic"), new String("Audio file"));
        mimeTypeTable.put(new String("audio/midi"), new String("Audio file (midi)"));
        mimeTypeTable.put(new String("audio/mpeg"), new String("Audio file (mp3)"));
        mimeTypeTable.put(new String("audio/x-aiff"), new String("Audio file"));
        mimeTypeTable.put(new String("audio/x-pn-realaudio"), new String("Realaudio Datei"));
        mimeTypeTable.put(new String("audio/x-wav"), new String("Audio Datei (wav)"));
        mimeTypeTable.put(new String("image/ief"), new String("Graphik (ief)"));
        mimeTypeTable.put(new String("image/tiff"), new String("Graphik (tiff)"));
        mimeTypeTable.put(new String("image/x-cmu-raster"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-anymap"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-bitmap"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-graymap"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-pixmap"), new String(""));
        mimeTypeTable.put(new String("image/x-rgb"), new String(""));
        mimeTypeTable.put(new String("image/x-xbitmap"), new String(""));
        mimeTypeTable.put(new String("image/x-xpixmap"), new String(""));
        mimeTypeTable.put(new String("image/x-xwindowdump"), new String(""));
        mimeTypeTable.put(new String("model/iges"), new String(""));
        mimeTypeTable.put(new String("model/iges"), new String(""));
        mimeTypeTable.put(new String("model/mesh"), new String(""));
        mimeTypeTable.put(new String("model/vrml"), new String("3D world (VRML)"));
        mimeTypeTable.put(new String("text/css"), new String("Style Definition (CSS)"));
        mimeTypeTable.put(new String("text/html"), new String("Wold Wide Web Document"));
        mimeTypeTable.put(new String("text/plain"), new String("Einfache Textdatei"));
        mimeTypeTable.put(new String("text/richtext"), new String("Rich Text Format"));
        mimeTypeTable.put(new String("text/tab-separated-values"), new String("Text file"));
        mimeTypeTable.put(new String("text/x-setext"), new String(""));
        mimeTypeTable.put(new String("text/x-sgml"), new String("SGML file"));
        mimeTypeTable.put(new String("text/x-vCalendar"), new String(""));
        mimeTypeTable.put(new String("text/x-vCard"), new String(""));
        mimeTypeTable.put(new String("text/xml"), new String("XML file"));
        mimeTypeTable.put(new String("video/dl"), new String("Video file"));
        mimeTypeTable.put(new String("video/fli"), new String("Video file"));
        mimeTypeTable.put(new String("video/gl"), new String("Video file"));
        mimeTypeTable.put(new String("video/mpeg"), new String("Video file (mpeg)"));
        mimeTypeTable.put(new String("video/quicktime"), new String(""));
        mimeTypeTable.put(new String("video/x-msvideo"), new String("Microsoft video file"));
        mimeTypeTable.put(new String("video/x-sgi-movie"), new String(""));
        mimeTypeTable.put(new String("x-conference/x-cooltalk"), new String(""));
        statusTable = new Hashtable();
        statusTable.put(new String(""), new String(""));
        statusTable.put(new String("-1"), new String(""));
        statusTable.put(new String("100"), new String(""));
        statusTable.put(new String("101"), new String(""));
        statusTable.put(new String("200"), new String(""));
        statusTable.put(new String("201"), new String(""));
        statusTable.put(new String("202"), new String(""));
        statusTable.put(new String("203"), new String(""));
        statusTable.put(new String("204"), new String(""));
        statusTable.put(new String("205"), new String(""));
        statusTable.put(new String("206"), new String(""));
        statusTable.put(new String("300"), new String(""));
        statusTable.put(new String("301"), new String(""));
        statusTable.put(new String("302"), new String(""));
        statusTable.put(new String("303"), new String(""));
        statusTable.put(new String("304"), new String("Dokument wurde seit letztem Besuch nicht ge\u00e4ndert"));
        statusTable.put(new String("305"), new String(""));
        statusTable.put(new String("400"), new String("Server Name unbekannt."));
        statusTable.put(new String("401"), new String("Passwort f\u00fcr Zugriff ben\u00f6tigt"));
        statusTable.put(new String("402"), new String("Zugriff kostenpflichtig"));
        statusTable.put(new String("403"), new String("Zugriff zum Dokument verweigert."));
        statusTable.put(new String("404"), new String("Dokument existiert nicht (mehr)!"));
        statusTable.put(new String("405"), new String("Error"));
        statusTable.put(new String("406"), new String("Error"));
        statusTable.put(new String("407"), new String("Error"));
        statusTable.put(new String("408"), new String("Timeout der Anfrage: Server antwortet nicht."));
        statusTable.put(new String("409"), new String("Error"));
        statusTable.put(new String("410"), new String("Error"));
        statusTable.put(new String("411"), new String("Error"));
        statusTable.put(new String("412"), new String("Error"));
        statusTable.put(new String("413"), new String("Error"));
        statusTable.put(new String("414"), new String("Error"));
        statusTable.put(new String("415"), new String("Error"));
        statusTable.put(new String("500"), new String("Interner Server-Fehler"));
        statusTable.put(new String("501"), new String("Interner Server-Fehler"));
        statusTable.put(new String("502"), new String("Interner Server-Fehler"));
        statusTable.put(new String("503"), new String("Interner Server-Fehler"));
        statusTable.put(new String("504"), new String("Interner Server-Fehler"));
        statusTable.put(new String("505"), new String("Interner Server-Fehler: Browser nicht unterst\u00fctzt."));
    }
}

