/*
 * Decompiled with CFR 0.152.
 */
package hyperscout3.applet;

import hyperscout3.applet.PopupWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.StringTokenizer;

public class PopupLine {
    boolean selected = false;
    boolean mouseOver = false;
    Window parent = null;
    Image image = null;
    String title = null;
    String text = null;
    Rectangle bounds = null;
    FontMetrics fm = null;
    Window popup = null;
    Color color = new Color(Integer.parseInt("FFFFFF", 16));
    int width;

    public PopupLine(Image image, String title, String text, String color, int width, FontMetrics fm) {
        int fontHeight;
        this.image = image;
        this.title = title;
        this.text = text;
        this.color = new Color(Integer.parseInt(color, 16));
        this.width = width;
        this.fm = fm;
        String line = "";
        int length = 0;
        int height = fontHeight = fm.getHeight();
        String token = null;
        StringTokenizer st = new StringTokenizer(text, " \t\n\r\f", true);
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            int w = 0;
            if (token.indexOf(" ") >= 0 || token.indexOf("\t") >= 0 || token.indexOf("\n") >= 0 || token.indexOf("\r") >= 0 || token.indexOf("\f") >= 0) {
                if (token.indexOf("\n") >= 0 && length > 50) {
                    length = width + 1;
                }
                token = "";
            } else {
                token = token + " ";
                w = fm.stringWidth(token);
                length += w;
            }
            if (length > width - 87 && length > w) {
                height += fontHeight;
                line = token;
                length = w;
                continue;
            }
            line = line + token;
        }
        if (line.length() < 1) {
            height -= fontHeight;
        }
        if (height / fontHeight > 5) {
            height = fontHeight * 5;
        }
        this.bounds = new Rectangle(0, 0, width, height + 3);
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public void setLocation(int x, int y) {
        this.bounds.setLocation(x, y);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean contains(int x, int y) {
        return this.bounds.contains(x, y);
    }

    public void paint(Graphics g) {
        int contentXpos;
        g.setColor(this.color);
        g.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        g.drawImage(this.image, this.bounds.x + 2, this.bounds.y + 2, null);
        if (!this.title.equals("")) {
            g.setColor(Color.black);
            g.setFont(new Font(PopupWindow.fontType, 1, PopupWindow.fontSize));
            g.drawString(this.title, this.bounds.x + 2 + 15, this.bounds.y + 13);
            contentXpos = 87;
            g.setFont(new Font(PopupWindow.fontType, 0, PopupWindow.fontSize));
        } else {
            contentXpos = 17;
            g.setFont(new Font(PopupWindow.fontType, 1, PopupWindow.fontSize));
            g.setColor(new Color(0, 0, 96));
        }
        String line = "";
        int length = 0;
        int height = this.fm.getHeight();
        int pos = 13;
        String token = null;
        StringTokenizer st = new StringTokenizer(this.text, " \t\n\r\f", true);
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            int w = 0;
            if (token.indexOf(" ") >= 0 || token.indexOf("\t") >= 0 || token.indexOf("\n") >= 0 || token.indexOf("\r") >= 0 || token.indexOf("\f") >= 0) {
                if (token.indexOf("\n") >= 0 && length > 50) {
                    length = this.width + 1;
                }
                token = "";
            } else {
                token = token + " ";
                w = this.fm.stringWidth(token);
                length += w;
            }
            if (length > this.width - (contentXpos + 10) && length > w) {
                g.drawString(line, this.bounds.x + contentXpos, this.bounds.y + pos);
                pos += height;
                line = token;
                length = w;
                continue;
            }
            line = line + token;
        }
        g.drawString(line, this.bounds.x + contentXpos, this.bounds.y + pos);
    }
}

