/*
 * Decompiled with CFR 0.152.
 */
package hyperscout3.applet;

import hyperscout3.applet.DisplayApplet;
import hyperscout3.applet.PopupLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.net.URL;
import scone.ras.Connection;

public class PopupWindow
extends Window {
    int lineCount = 0;
    int linePos = 1;
    int width = 0;
    int height = 0;
    public PopupLine[] lines = new PopupLine[30];
    public Image[] images = new Image[30];
    public boolean doCache = false;
    PopupLine active = null;
    PopupLine over = null;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    DisplayApplet applet = null;
    static final Color bgColor = new Color(255, 255, 255);
    static final Color borderColor = new Color(128, 128, 128);
    static String server = "localhost";
    static final int port = 8084;
    static final String generator = "hyperscout3.PopupDataGenerator";
    static final String wbiPort = "8088";
    static final String resPath = "/_hyperscout3/resources/";
    static int fontSize = 11;
    static String fontType = "SansSerif";

    public PopupWindow(DisplayApplet applet, String linkId, String userId) {
        super(new Frame());
        this.setBackground(bgColor);
        this.applet = applet;
        server = applet.getParameter("Scone IP");
        this.setFont(new Font(fontType, 0, fontSize));
        this.buildPopup(linkId, userId, applet.getGraphics().getFontMetrics(new Font(fontType, 0, fontSize)));
    }

    void buildPopup(String linkId, String userId, FontMetrics fm) {
        try {
            Connection con = new Connection(server, 8084, generator, false);
            System.out.println("Connetion created: " + con);
            con.wake();
            System.out.println("Link:" + linkId);
            con.write(linkId);
            System.out.println("Link ID written!");
            con.write(userId);
            System.out.println("User ID written!");
            String line = "";
            while (!line.equals("--begin")) {
                line = con.read();
            }
            System.out.println(line);
            line = con.read();
            if (line.equals("cache")) {
                this.doCache = true;
            }
            while (!line.equals("--end")) {
                line = con.read();
                if (!line.equals("--line")) continue;
                String l1 = con.read();
                String l2 = con.read();
                String l3 = con.read();
                String l4 = con.read();
                if (l1.equals("--end") || l2.equals("--end") || l3.equals("--end") || l4.equals("--end")) break;
                Image image = this.applet.getImage(new URL("http://" + server + ":" + wbiPort + resPath + l1));
                this.prepareImage(image, this);
                PopupLine pl = new PopupLine(image, l2, l3, l4, 400, fm);
                this.addLine(pl);
            }
            con.close();
        }
        catch (Exception exc) {
            try {
                Image image = this.applet.getImage(new URL("http://" + server + ":" + wbiPort + resPath + "flash.gif"));
                PopupLine error = new PopupLine(image, "Error", exc.toString(), "FF8080", 400, fm);
                this.addLine(error);
            }
            catch (Exception exec) {
                System.err.println("Error sending error message");
                exec.printStackTrace();
            }
            exc.printStackTrace();
        }
    }

    int findLine(String label) {
        for (int i = 0; i < this.lineCount; ++i) {
            if (!this.lines[i].getTitle().equals(label)) continue;
            return i;
        }
        return -1;
    }

    public void setMinSize() {
        this.width = 0;
        this.height = 0;
        Rectangle b = null;
        for (int i = 0; i < this.lineCount; ++i) {
            b = this.lines[i].getBounds();
            if (b.x + b.width > this.width) {
                this.width = b.x + b.width;
            }
            if (b.y + b.height <= this.height) continue;
            this.height = b.y + b.height;
        }
        if (DisplayApplet.browser.indexOf("Netscape") >= 0) {
            this.resize(this.width + 1, this.height + 1);
        } else if (DisplayApplet.browser.indexOf("Sun Microsystems") >= 0) {
            this.resize(this.width + 1, this.height + 22);
        } else {
            this.resize(this.width + 1, this.height + 18);
        }
    }

    public int getHeight() {
        return this.height + 2;
    }

    public int getWidth() {
        return this.width + 2;
    }

    private void addLine(PopupLine line) {
        line.setParent(this);
        line.setLocation(1, this.linePos);
        Rectangle b = line.getBounds();
        this.linePos += b.height + 0;
        this.lines[this.lineCount] = line;
        ++this.lineCount;
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        this.offgraphics.setColor(borderColor);
        if (DisplayApplet.browser.indexOf("Netscape") >= 0) {
            this.offgraphics.drawRect(0, 0, d.width - 1, d.height - 1);
        } else if (DisplayApplet.browser.indexOf("Sun Microsystems") >= 0) {
            this.offgraphics.drawRect(0, 0, d.width - 1, d.height - 25);
        } else {
            this.offgraphics.drawRect(0, 0, d.width - 1, d.height - 18);
        }
        for (int i = 0; i < this.lineCount; ++i) {
            this.lines[i].paint(this.offgraphics);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public PopupLine findLine(int x, int y) {
        for (int i = 0; i < this.lineCount; ++i) {
            if (!this.lines[i].contains(x, y)) continue;
            return this.lines[i];
        }
        return null;
    }

    public boolean doCache() {
        return this.doCache;
    }

    public void hide() {
        super.hide();
    }
}

