/*
 * Decompiled with CFR 0.152.
 */
package onefcClient;

import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import onefcClient.Plugin;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.LinkCache;
import scone.netobjects.LinkVector;
import scone.robot.LinkClassifier;
import scone.robot.LinkFilter;
import scone.robot.QueueEntry;
import scone.robot.Robot;
import scone.robot.RobotHtmlNode;
import scone.robot.RobotLink;
import scone.robot.RobotTask;
import scone.robot.RobotUser;

public class RobotPlugin
extends Plugin
implements Observer,
RobotUser {
    public static final String COPYRIGHT = "(C) Harald Weinreich, Frank Wollenweber & Toby Baier";
    private Robot robot;
    private RobotTask rt;
    private int depth = 1;

    public int getRequirements() {
        return 17956873;
    }

    public void init() {
        this.robot = Robot.instance();
        AccessCache.putObserver(this);
    }

    public void update(Observable o, Object arg) {
        AccessEvent e;
        if (o instanceof AccessCache && (e = (AccessEvent)arg).getAccess().getAction() == 0 && e.getAccess().getStayTime() == 0L) {
            System.out.println("\nRobotPlugin\n" + e.getUser().getUserName() + " accessed " + e.getNode().toString());
            HtmlNode hNode = HtmlNodeCache.check(e.getNode());
            if (hNode == null) {
                System.out.println("Error: Access from non HTML-Page!");
            } else {
                try {
                    this.rt = new RobotTask(hNode.getSUri(), this.depth, 4, this);
                    this.rt.addLinkClassifier(new LookOfLinkClassifier());
                    this.rt.addLinkFilter(new LookOfLinkFilter());
                    this.robot.scan(this.rt);
                }
                catch (Exception ex) {
                    System.out.println("Invalid URL");
                }
                System.out.println("Title: " + hNode.getTitle());
            }
        }
    }

    public void robotNewPage(RobotHtmlNode robotHtmlNode, RobotTask robotTask) {
    }

    public void robotTaskFinished(RobotTask robotTask) {
        System.out.println("Auftrag: " + robotTask.getStartURI().toString() + " Tiefe: " + robotTask.getDepth() + " abgeschlossen");
        System.out.println("Results: ");
        Enumeration downloadedNodes = robotTask.getResultNodes();
        while (downloadedNodes.hasMoreElements()) {
            RobotHtmlNode robotHtmlNode = (RobotHtmlNode)downloadedNodes.nextElement();
            System.out.println(robotHtmlNode.getSimpleUri().toString());
            LinkVector lv = (LinkVector)LinkCache.getLinks("where fromNodeId='" + robotHtmlNode.getNodeId() + "' and type&1=0 and type&2<>0");
            for (int i = 0; i < lv.size(); ++i) {
                System.out.println(" Link: " + lv.linkAt(i).getLinkText() + " " + lv.linkAt(i).getAlt());
                System.out.println(" ->" + lv.linkAt(i).getToNode().getUri() + "#" + lv.linkAt(i).getFragment());
            }
        }
    }

    private class LookOfLinkFilter
    implements LinkFilter {
        private LookOfLinkFilter() {
        }

        public boolean filter(RobotLink robotLink, RobotHtmlNode robotHtmlNode, QueueEntry qe) {
            return robotLink.getAttribute("SearchEngineURL") != "Yes";
        }
    }

    private class LookOfLinkClassifier
    implements LinkClassifier {
        private LookOfLinkClassifier() {
        }

        public void classify(RobotLink robotLink, RobotHtmlNode robotHtmlNode, QueueEntry qe) {
            String urlText = robotLink.getLink().getToNode().getUri();
            if (urlText.indexOf("google.") != -1 || urlText.indexOf("alltheweb.") != -1 || urlText.indexOf("fastsearch.") != -1 || urlText.indexOf("scirus.") != -1 || urlText.indexOf("megasoccer.") != -1 || urlText.indexOf("lycos.") != -1 || urlText.indexOf("hotbot.") != -1 || urlText.indexOf("yahoo.") != -1 || urlText.indexOf("dmoz.") != -1 || urlText.indexOf("doubleclick.") != -1) {
                robotLink.setAttribute("SearchEngineURL", "Yes");
            }
        }
    }
}

