/*
 * Decompiled with CFR 0.152.
 */
package scone;

import com.ibm.wbi.Run;
import java.util.Enumeration;
import java.util.Vector;
import scone.netobjects.AccessCache;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.InclusionCache;
import scone.netobjects.KeywordCache;
import scone.netobjects.LinkCache;
import scone.netobjects.NetNodeCache;
import scone.netobjects.Node2KeyCache;
import scone.netobjects.PersonCache;
import scone.netobjects.ServerCache;
import scone.netobjects.UserCache;
import scone.robot.Robot;
import scone.robot.RobotTask;
import scone.util.ConfigGui;
import scone.util.PluginRepository;
import scone.util.WbiKillerGUI;

public class Scone {
    public static final String COPYRIGHT = "Harald Weinreich, Volkert Buchmann, Torsten Ha\u00df, Frank Wollenweber";
    public static final String VERSION = "1.2.1";
    public static PluginRepository plugins = null;
    private static WbiKiller wbiKiller = new WbiKiller();

    public static void main(String[] args) {
        System.out.println("\nThis is Scone 1.2.1");
        if (Scone.posInArray("-help", args) >= 0 || Scone.posInArray("-h", args) >= 0) {
            System.out.println("");
            System.out.println("Scone command line options:");
            System.out.println("-config /-setup   GUI to configure database, user tracking and plugins");
            System.out.println("-register plugin  Register a new Scone plugin");
            System.out.println("-noWBI            Start Scone without WBI");
            System.out.println("-killergui        Start Scone with the WBI Killer GUI");
            System.out.println("");
            System.out.println("WBI options:");
            System.out.println("-c config_name    Use other configuration file    ");
            System.out.println("-t trace_levels:                          ");
            System.out.println("   n              No (default)");
            System.out.println("   e              Exceptions only ");
            System.out.println("   m              MEG-Communications");
            System.out.println("   v              Verbose");
            System.out.println("-m msg_levels:");
            System.out.println("   n              No (default)");
            System.out.println("   i              Informative");
            System.out.println("   w              Warnings");
            System.out.println("   e              Errors");
            System.out.println("   v              Verbose");
            System.out.println("-g                Start WBI with GUI (WBI 4.5 only) ");
            System.out.println("-nogui            Disable GUI        (WBI 4.5 only) ");
            System.out.println("                  To enable GUI in 4.6 type 'enable ibm/gui' at console");
            System.exit(0);
        }
        plugins = new PluginRepository();
        if (Scone.posInArray("-register", args) >= 0) {
            if (args.length >= Scone.posInArray("-register", args) + 1) {
                String name = args[Scone.posInArray("-register", args) + 1];
                System.out.println("registering " + name);
                plugins.register(name);
                plugins.store();
                System.exit(0);
            } else {
                System.out.println("You have to specify a plugin!");
                System.exit(0);
            }
        }
        if (Scone.posInArray("-config", args) >= 0 || Scone.posInArray("-setup", args) >= 0) {
            new ConfigGui(plugins);
        } else {
            System.out.println("Call \"runscone -help\" for options");
            Scone.initCaches();
            if (Scone.posInArray("-noWBI", args) == -1) {
                System.out.print("WBI: ");
                Run.main((String[])args);
                if (Scone.posInArray("-killergui", args) >= 0) {
                    new WbiKillerGUI();
                }
            }
        }
    }

    protected static String[] delPosInArray(int pos, String[] array) {
        String[] a = new String[array.length - 1];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i != pos) {
                a[j] = array[i];
            }
            ++j;
        }
        return a;
    }

    protected static int posInArray(String arg, String[] args) {
        arg = arg.toUpperCase();
        for (int i = 0; i < args.length; ++i) {
            if (!arg.toUpperCase().equals(args[i].toUpperCase())) continue;
            return i;
        }
        return -1;
    }

    public static void initCaches() {
        DBTableAdapter.init();
        NetNodeCache.init(60000, 0);
        HtmlNodeCache.init(120000, 0);
        LinkCache.init(120000, 0);
        InclusionCache.init(120000, 0);
        ServerCache.init(180000, 0);
        KeywordCache.init(240000, 0);
        Node2KeyCache.init(240000, 0);
        AccessCache.init(120000, 0);
        UserCache.init(600000, 0);
        PersonCache.init(600000, 0);
    }

    public static void terminate() {
        System.out.println("\n-> Scone: Terminating Plugins...");
        plugins.terminate();
        System.out.println("\n-> Scone: Terminating Robots...");
        Robot robot = Robot.instance();
        Vector robotTasks = robot.getRobotTasks();
        Enumeration tasks = robotTasks.elements();
        while (tasks.hasMoreElements()) {
            RobotTask rt = (RobotTask)tasks.nextElement();
            if (rt == null) continue;
            robot.stopRobotTask(rt);
        }
        while (robot.getNumberOfRobotTasks() > 0) {
        }
        System.out.println("\n-> Scone: Writing Data to Database...");
        LinkCache.clean();
        InclusionCache.clean();
        NetNodeCache.clean();
        HtmlNodeCache.clean();
        ServerCache.clean();
        KeywordCache.clean();
        Node2KeyCache.clean();
        AccessCache.clean();
        UserCache.clean();
        PersonCache.clean();
    }

    public static void abortWBI() {
        wbiKiller.abort();
    }

    public static void shutdownWBI(int timeout) {
        wbiKiller.shutdown(timeout);
    }

    private static class WbiKiller
    extends Run {
        private WbiKiller() {
        }

        public void abort() {
            System.out.println("Aborting WBI...");
            theProxy.abort();
            System.out.println("WBI aborted.");
            System.exit(0);
        }

        public void shutdown(int timeout) {
            System.out.println("Shutting down WBI, timout = " + timeout);
            if (!theProxy.terminate(timeout)) {
                System.out.println("Could not terminate all threads within time limit!");
            }
            System.out.println("WBI shut down");
            System.exit(0);
        }
    }
}

