/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.io.IOException;
import scone.accesstracking.AccessTracking;
import scone.accesstracking.EventDecoder;
import scone.accesstracking.FrameAccess;
import scone.ras.Connection;
import scone.ras.ConnectionHandler;
import scone.util.ErrorLog;

public class AppletConnector
implements ConnectionHandler {
    private EventDecoder eventDecoder;
    private boolean decoded = false;
    private Connection c;
    private long appletStartTime = 0L;
    private String userId;
    private String nodeId;
    private long startTime = 0L;
    private String frameName;
    private String fragment;
    private String query;
    private String parentFrameName;
    private String parentNodeName;
    private String referrer;
    private String isIE;
    private String isNS;
    private String post;
    private int frameCount;
    private String megTime;
    private long loadedTime = 0L;
    private String accessEventExistedString;
    private int browserName;
    private long stoppedTime;
    private long linkTime;
    private String linkId;
    private long formTime = 0L;
    private String formAction = "";

    public void handle(Connection c) {
        boolean showMessages = false;
        boolean useIESpy = false;
        this.c = c;
        FrameAccess frameAccess = FrameAccess.getInstance();
        try {
            if (AccessTracking.props.get("Acesstracking1: Show status messages").equals("true")) {
                showMessages = true;
            }
        }
        catch (Exception exc) {
            ErrorLog.log(this, "AppletConnector: Error while reading Scone properties", "", exc);
        }
        try {
            if (AccessTracking.props.get("Acesstracking1: Disable Applet").equals("true")) {
                useIESpy = true;
            }
        }
        catch (Exception exc) {
            ErrorLog.log(this, "AppletConnector: Error while reading Scone properties", "", exc);
        }
        String inputLine = null;
        if (!useIESpy) {
            this.eventDecoder = new EventDecoder();
        }
        try {
            while ((inputLine = c.read()) != null && !inputLine.equals("null")) {
                this.decoded = false;
                if (inputLine.startsWith("params")) {
                    this.appletStartTime = Long.parseLong(this.getParameter(inputLine, "AppletStartTime"));
                    this.userId = this.getParameter(inputLine, "UserId");
                    this.nodeId = this.getParameter(inputLine, "NodeId");
                    this.startTime = Long.parseLong(this.getParameter(inputLine, "StartTime"));
                    this.frameName = this.getParameter(inputLine, "Frame");
                    this.fragment = this.getParameter(inputLine, "Fragment");
                    this.query = this.getParameter(inputLine, "Query");
                    this.post = this.getParameter(inputLine, "Post");
                    this.parentNodeName = this.getParameter(inputLine, "ParentNodeName");
                    this.parentFrameName = this.getParameter(inputLine, "ParentFrame");
                    frameAccess.add(this.parentFrameName, this.frameName, this);
                    this.referrer = this.getParameter(inputLine, "Referrer");
                    this.isIE = this.getParameter(inputLine, "IsIE");
                    this.isNS = this.getParameter(inputLine, "IsNS");
                    this.frameCount = Integer.parseInt(this.getParameter(inputLine, "FrameCount"));
                    this.megTime = this.getParameter(inputLine, "ATMegTime");
                    if (!useIESpy) {
                        this.eventDecoder.appletStarted(this.appletStartTime, this.userId, this.nodeId, this.startTime, this.frameName, this.fragment, this.query, this.post, this.parentNodeName, this.parentFrameName, this.referrer, this.isIE, this.isNS, this.frameCount, this.megTime, showMessages, this);
                    }
                    this.decoded = true;
                }
                if (inputLine.startsWith("loaded")) {
                    this.loadedTime = Long.parseLong(this.getParameter(inputLine, "LoadedTime"));
                    if (!useIESpy) {
                        this.eventDecoder.pageLoaded(this.appletStartTime, this.userId, this.nodeId, this.startTime, this.frameName, this.loadedTime);
                    }
                    this.decoded = true;
                }
                if (inputLine.startsWith("stopped")) {
                    frameAccess.remove(this.parentFrameName, this.frameName);
                    this.stoppedTime = Long.parseLong(this.getParameter(inputLine, "StoppedTime"));
                    if (!useIESpy) {
                        this.eventDecoder.pageUnloaded(this.appletStartTime, this.userId, this.nodeId, this.startTime, this.frameName, this.stoppedTime);
                    }
                    this.decoded = true;
                }
                if (inputLine.startsWith("link")) {
                    this.linkTime = Long.parseLong(this.getParameter(inputLine, "LinkTime"));
                    this.linkId = this.getParameter(inputLine, "LinkId");
                    if (!useIESpy) {
                        this.eventDecoder.linkClicked(this.appletStartTime, this.userId, this.nodeId, this.startTime, this.frameName, this.frameCount, this.megTime, this.linkTime, this.linkId);
                    }
                    this.decoded = true;
                }
                if (inputLine.startsWith("form")) {
                    this.formTime = Long.parseLong(this.getParameter(inputLine, "FormTime"));
                    this.formAction = this.getParameter(inputLine, "Action");
                    if (!useIESpy) {
                        this.eventDecoder.formSubmited(this.appletStartTime, this.userId, this.nodeId, this.startTime, this.frameName, this.formTime, this.formAction);
                    }
                    this.decoded = true;
                }
                if (inputLine.startsWith("logMessage")) {
                    String className = this.getParameter(inputLine, "className");
                    String method = this.getParameter(inputLine, "method");
                    String param = this.getParameter(inputLine, "parameter");
                    this.eventDecoder.logMessage(className, method, param);
                    this.decoded = true;
                }
                if (this.decoded) continue;
                System.out.println("Could not decode: " + inputLine);
            }
            frameAccess.remove(this.parentFrameName, this.frameName);
            c.close();
        }
        catch (IOException e) {
            frameAccess.remove(this.parentFrameName, this.frameName);
        }
        catch (Exception ex) {
            frameAccess.remove(this.parentFrameName, this.frameName);
        }
        frameAccess.remove(this.parentFrameName, this.frameName);
    }

    public boolean testIsAppletExistent() {
        boolean returnValue = true;
        try {
            this.c.write("");
        }
        catch (Exception e) {
            returnValue = false;
            System.out.println("AppletConnector.writeToApplet: Applet does not exist - sending was not possible. " + e.toString());
        }
        return returnValue;
    }

    boolean writeToApplet(String msgToSend) {
        boolean returnValue = true;
        try {
            this.c.write(msgToSend);
        }
        catch (Exception e) {
            returnValue = false;
            System.out.println("AppletConnector.writeToApplet: Could not send \"" + msgToSend + "\" to Applet. " + e.toString());
        }
        return returnValue;
    }

    public boolean sendToApplet(String command, String parameter1, String parameter2) {
        return this.writeToApplet("command=" + command.toLowerCase().trim() + "\nparameter1=" + parameter1.trim() + "\nparameter2=" + parameter2.trim() + "\n");
    }

    public String getParameter(String inputLine, String paramName) {
        if (inputLine.indexOf("\n" + paramName + "=") > -1) {
            int startPos = inputLine.indexOf("\n" + paramName + "=") + paramName.length() + 2;
            int endPos = inputLine.indexOf("\n", startPos);
            return inputLine.substring(startPos, endPos);
        }
        System.out.println("Gesuchter Parameter " + paramName + " ist nicht im String " + inputLine + " enthalten!");
        return "";
    }
}

