/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scone.accesstracking.FrameHistory;
import scone.accesstracking.FrameSet;
import scone.netobjects.Access;

class BrowserHistory {
    private static BrowserHistory _instance = null;
    private Map map = new HashMap();
    private FrameHistory frameHistory;

    static BrowserHistory getInstance() {
        if (_instance == null) {
            _instance = new BrowserHistory();
        }
        return _instance;
    }

    private BrowserHistory() {
    }

    boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    void add(String key, String megTime, Access a) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.add(megTime, a);
        } else {
            this.frameHistory = new FrameHistory();
            this.map.put(key, this.frameHistory);
            this.frameHistory.add(megTime, a);
        }
    }

    void add(String key, String megTime, FrameSet frameSet) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.add(megTime, frameSet);
        } else {
            this.frameHistory = new FrameHistory();
            this.map.put(key, this.frameHistory);
            this.frameHistory.add(megTime, frameSet);
        }
    }

    void insert(String key, String megTime, FrameSet frameSet) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.insert(megTime, frameSet);
        } else {
            this.frameHistory = new FrameHistory();
            this.map.put(key, this.frameHistory);
            this.frameHistory.insert(megTime, frameSet);
        }
    }

    boolean contains(String key, String megTime) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            if (this.frameHistory.contains(megTime)) {
                // empty if block
            }
            return this.frameHistory.contains(megTime);
        }
        return false;
    }

    boolean containsPageLike(String key, Access a) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            return this.frameHistory.containsPageLike(a);
        }
        return false;
    }

    String createKey(String userId, String parentFrameName, String frameName) {
        String key = "";
        for (int counter = userId.length(); counter < 16; ++counter) {
            key = key + "0";
        }
        key = key + userId;
        key = parentFrameName.equals("") ? key + frameName : key + parentFrameName;
        return key;
    }

    int getLastAction(String key) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            return this.frameHistory.getLastAction();
        }
        return -1;
    }

    void setLastAction(String key, int lastAction) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.setLastAction(lastAction);
        }
    }

    Access getLastEvent(String key, String frameName) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            return this.frameHistory.getLastEvent(frameName);
        }
        return null;
    }

    Object getLastEntry(String key) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            return this.frameHistory.getLastEntry();
        }
        return null;
    }

    Object getPrevEntry(String key) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            return this.frameHistory.getPrevEntry();
        }
        System.out.println("AccessTracking:BrowserHistory: getPrevEntry gibt null zur\u00fcck");
        return null;
    }

    void showFrameContents(String key) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.showFrameContents();
        } else {
            System.out.println("AccessTracking:showFrameContents: No Entry for key " + key + " found");
        }
    }

    void delPrevEntry(String key) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.delPrevEntry();
        }
    }

    void replaceLastEvent(String key, String megTime, Access a) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.replaceLastEvent(megTime, a);
        }
    }

    void replaceLastEvent(String key, String frameName, String megTime, Access a) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.replaceLastEvent(frameName, megTime, a);
        }
    }

    void replaceAllPagesLike(Access a, String megTime) {
        boolean counter = false;
        Iterator contents = this.map.keySet().iterator();
        while (contents.hasNext()) {
            FrameHistory frameHistory = (FrameHistory)this.map.get(contents.next());
            frameHistory.replaceAllPagesLike(a, megTime);
        }
    }

    int getDistance(String key, String megTime) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            return this.frameHistory.getDistance(megTime);
        }
        return Integer.MAX_VALUE;
    }

    int getDistanceOfPageLike(String key, Access a) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            return this.frameHistory.getDistanceOfPageLike(a);
        }
        return Integer.MAX_VALUE;
    }

    void setPositionTo(String key, String megTime) {
        if (this.map.containsKey(key)) {
            this.frameHistory = (FrameHistory)this.map.get(key);
            this.frameHistory.setPositionTo(megTime);
        }
    }

    synchronized FrameHistory getFrameHistory(String key) {
        if (this.map.containsKey(key)) {
            return (FrameHistory)this.map.get(key);
        }
        this.frameHistory = new FrameHistory();
        this.map.put(key, this.frameHistory);
        return this.frameHistory;
    }
}

