/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.lang.reflect.Method;
import java.util.Date;
import scone.accesstracking.AccessTracking;
import scone.accesstracking.AppletConnector;
import scone.accesstracking.BrowserHistory;
import scone.accesstracking.FrameAccess;
import scone.accesstracking.FrameHistory;
import scone.accesstracking.FrameSet;
import scone.accesstracking.UriStripper;
import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.util.ErrorLog;

public class EventDecoder {
    public static final int LINK = 1;
    public static final int FRAGMENT = 2;
    public static final int SELFLINK = 4;
    public static final int FORMSUBMIT = 8;
    public static final int RELOAD = 16;
    public static final int BACK = 32;
    public static final int NEXT = 64;
    public static final int SKIPPED = 128;
    public static final int NEWWINDOW = 256;
    public static final int BOOKMARK = 512;
    public static final int NEWURL = 32768;
    public static final int BROWSER_NS = 0x8000000;
    public static final int BROWSER_IE = 0x10000000;
    public static final int BROWSER_GECKO = 0x20000000;
    public static final int HEURISTIC = Integer.MIN_VALUE;
    private final int OTHER = 0;
    private final int EXPLORER = 1;
    private final int NETSCAPE = 2;
    private BrowserHistory history = BrowserHistory.getInstance();
    private int browserName = 0;
    private boolean accessEventExisted = false;
    private boolean showMessages;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appletStarted(long appletStartTime, String userId, String nodeId, long startTime, String frameName, String fragment, String query, String post, String parentNodeName, String parentFrameName, String referrer, String isIE, String isNS, int frameCount, String megTime, boolean showMessages, AppletConnector appletConnector) {
        FrameAccess frameAccess = FrameAccess.getInstance();
        this.showMessages = showMessages;
        Access a = AccessCache.get(userId, nodeId, startTime, frameName);
        if (a.getAction() > 0) {
            this.accessEventExisted = true;
            a = AccessCache.get(userId, nodeId, appletStartTime, frameName);
        } else {
            a.setAction(32768);
        }
        if (fragment.startsWith("#")) {
            fragment = fragment.substring(1);
        }
        a.setFragment(fragment);
        a.setQuery(query);
        a.setPost(post);
        parentNodeName = new UriStripper(parentNodeName).getUri();
        if (!parentNodeName.equals("") && !parentNodeName.equals(":")) {
            a.setParentFrameNodeId(NetNodeCache.get(parentNodeName).getNodeId());
        }
        a.setParentFrameName(parentFrameName);
        referrer = new UriStripper(referrer).getUri();
        if (!referrer.equals("") && !referrer.equals(":")) {
            a.setReferrerNodeId(NetNodeCache.get(referrer).getNodeId());
        }
        a.store();
        frameAccess.addAccessObject(parentFrameName, frameName, a);
        this.browserName = 0;
        if (isIE.equals("[object]")) {
            this.browserName = 1;
            a.setAction(a.getAction() | 0x10000000);
        }
        if (isNS.startsWith("{length:")) {
            this.browserName = 2;
            a.setAction(a.getAction() | 0x8000000);
        }
        String key = this.history.createKey(userId, parentFrameName, frameName);
        if (this.browserName == 1 && frameCount > 0 && this.history.getLastAction(key) == 5) {
            this.history.replaceLastEvent(key, frameName, megTime, a);
            this.history.setLastAction(key, 32768);
            this.printMsg("AccessTracking: Link to same URL clicked (Explorer)");
        } else if (this.history.contains(key, megTime)) {
            int distance = this.history.getDistance(key, megTime);
            if (distance == 0) {
                this.printMsg("AccessTracking: Seitengr\u00f6\u00dfe ver\u00e4ndert");
            }
            if (distance != 0) {
                if (this.history.getLastEvent(key, frameName) != null) {
                    NetNode referrerNode = NetNodeCache.getById(this.history.getLastEvent(key, frameName).getNodeId());
                    a.setReferrerNodeId(referrerNode.getNodeId());
                } else {
                    referrer = "";
                }
                this.history.setPositionTo(key, megTime);
                if (distance < 0) {
                    a.setAction(0x20 | a.getAction() & 0x18000000);
                }
                if (distance > 0) {
                    a.setAction(0x40 | a.getAction() & 0x18000000);
                }
                if (distance < -1 | distance > 1) {
                    a.setAction(a.getAction() | 0x80);
                }
            }
            if (distance < 0) {
                this.printMsg("AccessTracking: Backtaste, " + -distance + " steps");
                a.setStepsInHistory(-distance);
            }
            if (distance > 0) {
                this.printMsg("AccessTracking: Nexttaste, " + distance + " steps");
                a.setStepsInHistory(distance);
            }
        } else {
            if (this.browserName == 1) {
                this.history.replaceAllPagesLike(a, megTime);
            }
            if (frameCount > 0) {
                FrameHistory fh;
                if (!this.history.containsKey(key)) {
                    a.setAction(0x100 | a.getAction() & 0x18000000);
                    this.printMsg("AccessTracking: new window");
                }
                FrameHistory frameHistory = fh = this.history.getFrameHistory(key);
                synchronized (frameHistory) {
                    block2 : switch (this.history.getLastAction(key)) {
                        case 5: {
                            a.setAction(this.history.getLastAction(key) | a.getAction() & 0x18000000);
                            a.store();
                            this.history.replaceLastEvent(key, frameName, megTime, a);
                            this.history.setLastAction(key, 32768);
                            this.printMsg("AccessTracking: Link to same URL clicked (Netscape)");
                            break;
                        }
                        case 1: 
                        case 8: 
                        case 32768: {
                            a.setAction(this.history.getLastAction(key) | a.getAction() & 0x18000000);
                            a.store();
                            Object fhEntry = this.history.getLastEntry(key);
                            if (fhEntry == null) {
                                FrameSet fs = new FrameSet();
                                fs.addToFrameSet(megTime, a);
                                Access pa = AccessCache.get(userId, a.getParentFrameNodeId(), new Date().getTime(), parentFrameName);
                                pa.setAction(a.getAction() & 0x18000000);
                                pa.store();
                                a.setParentAccessId(pa.getAccessId());
                                fs.setParentAccessIds(pa.getAccessId());
                                if (frameCount == fs.getFrameListSize()) {
                                    this.history.setLastAction(key, 32768);
                                }
                                this.history.add(key, megTime, fs);
                                switch (a.getAction() & 0xE7FFFFFF) {
                                    case 8: {
                                        this.printMsg("AccessTracking: Form submited");
                                        break block2;
                                    }
                                    case 1: {
                                        this.printMsg("AccessTracking: Link clicked");
                                        break block2;
                                    }
                                    case 32768: {
                                        this.printMsg("AccessTracking: New URL or bookmark used");
                                    }
                                }
                                break;
                            }
                            if (fhEntry.getClass().getName().endsWith("FrameSet")) {
                                if (((FrameSet)fhEntry).noStoppedEvents()) {
                                    Object prevEntry;
                                    if ((a.getAction() & 0x8000) == 32768 && (prevEntry = this.history.getPrevEntry(key)) != null && !prevEntry.getClass().getName().endsWith("Access") && ((FrameSet)prevEntry).containsPageLike(a)) {
                                        a.setAction(0x10 | a.getAction() & 0x18000000);
                                    }
                                    a.setParentAccessId(((FrameSet)fhEntry).getFirstEvent().getParentAccessId());
                                    a.store();
                                    ((FrameSet)fhEntry).addToFrameSet(megTime, a);
                                    if (frameCount == ((FrameSet)fhEntry).getFrameListSize()) {
                                        this.history.setLastAction(key, 32768);
                                        if ((a.getAction() & 0x10) == 16) {
                                            this.history.delPrevEntry(key);
                                        }
                                    }
                                    switch (a.getAction() & 0xE7FFFFFF) {
                                        case 8: {
                                            this.printMsg("AccessTracking: Form submited");
                                            break block2;
                                        }
                                        case 1: {
                                            this.printMsg("AccessTracking: Link clicked");
                                            break block2;
                                        }
                                        case 16: {
                                            this.printMsg("AccessTracking: Page was reloaded");
                                            break block2;
                                        }
                                        case 32768: {
                                            this.printMsg("AccessTracking: New URL or bookmark used");
                                        }
                                    }
                                    break;
                                }
                                if ((a.getAction() & 0x8000) == 32768 && ((FrameSet)fhEntry).containsPageLike(a)) {
                                    a.setAction(0x10 | a.getAction() & 0x18000000);
                                    if (this.browserName == 1) {
                                        // empty if block
                                    }
                                }
                                FrameSet fs = new FrameSet();
                                fs.copyUnstoppedEvents((FrameSet)fhEntry);
                                fs.addToFrameSet(megTime, a);
                                if (((FrameSet)fhEntry).getFirstEvent() != null) {
                                    Access prevAccess = ((FrameSet)fhEntry).getFirstEvent();
                                    if (a.getParentFrameNodeId().equals(prevAccess.getParentFrameNodeId())) {
                                        a.setParentAccessId(prevAccess.getParentAccessId());
                                    } else {
                                        Access pa = AccessCache.get(userId, a.getParentFrameNodeId(), new Date().getTime(), parentFrameName);
                                        pa.setAction(a.getAction() & 0x18000000);
                                        pa.store();
                                        a.setParentAccessId(pa.getAccessId());
                                    }
                                }
                                fs.setParentAccessIds(a.getParentAccessId());
                                if (frameCount == fs.getFrameListSize()) {
                                    this.history.setLastAction(key, 32768);
                                }
                                a.setReferrerNodeId(((FrameSet)fhEntry).getLastEvent(frameName).getNodeId());
                                a.store();
                                if ((a.getAction() & 0x10) == 16) {
                                    this.history.insert(key, megTime, fs);
                                } else {
                                    this.history.add(key, megTime, fs);
                                }
                                switch (a.getAction() & 0xE7FFFFFF) {
                                    case 8: {
                                        this.printMsg("AccessTracking: Form submited");
                                        break block2;
                                    }
                                    case 1: {
                                        this.printMsg("AccessTracking: Link clicked");
                                        break block2;
                                    }
                                    case 16: {
                                        this.printMsg("AccessTracking: Page was reloaded");
                                        break block2;
                                    }
                                    case 32768: {
                                        this.printMsg("AccessTracking: New URL or bookmark used");
                                    }
                                }
                                break;
                            }
                            FrameSet fs = new FrameSet();
                            fs.addToFrameSet(megTime, a);
                            Access pa = AccessCache.get(userId, a.getParentFrameNodeId(), new Date().getTime(), parentFrameName);
                            pa.setAction(a.getAction() & 0x18000000);
                            pa.store();
                            a.setParentAccessId(pa.getAccessId());
                            fs.setParentAccessIds(pa.getAccessId());
                            if (frameCount == fs.getFrameListSize()) {
                                this.history.setLastAction(key, 32768);
                            }
                            this.history.add(key, megTime, fs);
                            switch (a.getAction() & 0xE7FFFFFF) {
                                case 8: {
                                    this.printMsg("AccessTracking: Form submited");
                                    break block2;
                                }
                                case 1: {
                                    this.printMsg("AccessTracking: Link clicked");
                                    break block2;
                                }
                                case 32768: {
                                    this.printMsg("AccessTracking: New URL or bookmark used");
                                }
                            }
                        }
                    }
                }
            } else {
                int distance;
                if (!this.history.containsKey(key)) {
                    a.setAction(0x100 | a.getAction() & 0x18000000);
                    this.printMsg("AccessTracking: new window");
                    this.history.add(key, megTime, a);
                }
                switch (this.history.getLastAction(key)) {
                    case 5: {
                        a.setAction(this.history.getLastAction(key) | a.getAction() & 0x18000000);
                        this.history.replaceLastEvent(key, megTime, a);
                        this.printMsg("AccessTracking: Link to same URL clicked");
                        break;
                    }
                    case 1: 
                    case 8: {
                        a.setAction(this.history.getLastAction(key) | a.getAction() & 0x18000000);
                        if (this.history.getLastAction(key) == 8) {
                            this.printMsg("AccessTracking: Form submited");
                        } else {
                            this.printMsg("AccessTracking: Link clicked");
                        }
                        this.history.add(key, megTime, a);
                    }
                }
                if (referrer.equals("[unknown origin]")) {
                    a.setAction(0x200 | a.getAction() & 0x18000000);
                    this.printMsg("AccessTracking: Bookmark used to call page");
                    this.history.add(key, megTime, a);
                }
                if ((a.getAction() & 0x8000) == 32768 && this.history.containsPageLike(key, a) && (distance = this.history.getDistanceOfPageLike(key, a)) == 0) {
                    this.printMsg("AccessTracking: Page was reloaded");
                    a.setAction(0x10 | a.getAction() & 0x18000000);
                    this.history.replaceLastEvent(key, megTime, a);
                }
                if ((a.getAction() & 0x8000) == 32768) {
                    this.printMsg("AccessTracking: URL typed in or bookmark or home used");
                    this.history.add(key, megTime, a);
                }
                this.history.setLastAction(key, 32768);
                a.store();
            }
        }
        AccessCache.broadcastEvent(new AccessEvent(a));
    }

    void pageLoaded(long appletStartTime, String userId, String nodeId, long startTime, String frameName, long loadedTime) {
        Access a;
        long loadTime = 0L;
        if (this.accessEventExisted) {
            loadTime = loadedTime - appletStartTime;
            a = AccessCache.get(userId, nodeId, appletStartTime, frameName);
        } else {
            loadTime = loadedTime - startTime;
            a = AccessCache.get(userId, nodeId, startTime, frameName);
        }
        a.setLoadTime(loadTime);
        a.store();
        this.printMsg("AccessTracking: Load time: " + loadTime);
        if (AccessTracking.props.get("Create extra event after page is loaded").equals("true")) {
            AccessCache.broadcastEvent(new AccessEvent(a));
        }
    }

    public void pageUnloaded(long appletStartTime, String userId, String nodeId, long startTime, String frameName, long stoppedTime) {
        Access a;
        long stayTime = 0L;
        if (this.accessEventExisted) {
            stayTime = stoppedTime - appletStartTime;
            a = AccessCache.get(userId, nodeId, appletStartTime, frameName);
        } else {
            stayTime = stoppedTime - startTime;
            a = AccessCache.get(userId, nodeId, startTime, frameName);
        }
        a.setStayTime(stayTime);
        a.store();
        this.printMsg("AccessTracking: Stay time: " + stayTime);
        if (AccessTracking.props.get("Create extra events after user leaves a page").equals("true")) {
            AccessCache.broadcastEvent(new AccessEvent(a));
        }
    }

    public void linkClicked(long appletStartTime, String userId, String nodeId, long startTime, String frameName, int frameCount, String megTime, long linkTime, String linkId) {
        Link link = LinkCache.getById(linkId);
        Access a = this.accessEventExisted ? AccessCache.get(userId, nodeId, appletStartTime, frameName) : AccessCache.get(userId, nodeId, startTime, frameName);
        String key = this.history.createKey(userId, a.getParentFrameName(), a.getFrameName());
        if (frameCount > 0) {
            if (link.getTarget().toLowerCase().equals("_top") || link.getTarget().toLowerCase().equals("_parent")) {
                this.history.setLastAction(key, 1);
                a.setLinkId(link.getLinkId());
                a.store();
            } else {
                Access ta = link.getTarget().toLowerCase().equals("_self") ? a : this.history.getLastEvent(key, link.getTarget());
                if (NetNodeCache.getById(ta.getNodeId()).equals(link.getToNode())) {
                    if (link.getFragment().equals(ta.getFragment())) {
                        this.history.setLastAction(key, 5);
                    } else {
                        ta.setStayTime(linkTime - ta.getTime());
                        this.printMsg("AccessTracking: StayTime: " + ta.getStayTime());
                        ta.setLinkId(link.getLinkId());
                        ta.store();
                        Access a1 = AccessCache.get(ta.getUserId(), ta.getNodeId(), linkTime, ta.getFrameName());
                        a1.setAction(3 | a.getAction() & 0x18000000);
                        a1.setFragment(link.getFragment());
                        a1.setQuery(ta.getQuery());
                        a1.setParentFrameNodeId(ta.getParentFrameNodeId());
                        a1.setParentFrameName(ta.getParentFrameName());
                        a1.setReferrerNodeId(ta.getNodeId());
                        a1.setParentAccessId(ta.getParentAccessId());
                        a1.store();
                        FrameSet fs = new FrameSet();
                        FrameSet thisFrameSet = (FrameSet)this.history.getLastEntry(key);
                        fs.copyUnstoppedEvents(thisFrameSet);
                        fs.addToFrameSet(megTime, ta);
                        this.history.add(key, megTime, fs);
                        this.printMsg("AccessTracking: same URL, other fragment");
                        if (this.accessEventExisted) {
                            appletStartTime = linkTime;
                        } else {
                            startTime = linkTime;
                        }
                    }
                } else {
                    this.history.setLastAction(key, 1);
                    a.setLinkId(link.getLinkId());
                    a.store();
                }
            }
        } else if (link.getFromNode() == link.getToNode()) {
            if (link.getFragment().equals(a.getFragment())) {
                this.history.setLastAction(key, 5);
            } else {
                if (this.accessEventExisted) {
                    a.setStayTime(linkTime - appletStartTime);
                } else {
                    a.setStayTime(linkTime - startTime);
                }
                a.setLinkId(link.getLinkId());
                a.store();
                Access a1 = AccessCache.get(a.getUserId(), a.getNodeId(), linkTime, a.getFrameName());
                a1.setAction(3 | a.getAction() & 0x18000000);
                a1.setFragment(link.getFragment());
                a1.setQuery(a.getQuery());
                a1.setParentFrameNodeId(a.getParentFrameNodeId());
                a1.setParentFrameName(a.getParentFrameName());
                a1.setReferrerNodeId(a.getNodeId());
                a1.store();
                a = a1;
                a1 = null;
                this.history.add(key, megTime, a);
                this.printMsg("AccessTracking: same URL, other fragment");
                if (this.accessEventExisted) {
                    appletStartTime = linkTime;
                } else {
                    startTime = linkTime;
                }
            }
        } else {
            this.history.setLastAction(key, 1);
            a.setLinkId(link.getLinkId());
            a.store();
        }
    }

    public void formSubmited(long appletStartTime, String userId, String nodeId, long startTime, String frameName, long formTime, String formAction) {
        Access a = this.accessEventExisted ? AccessCache.get(userId, nodeId, appletStartTime, frameName) : AccessCache.get(userId, nodeId, startTime, frameName);
        String key = this.history.createKey(userId, a.getParentFrameName(), a.getFrameName());
        if (formAction.toLowerCase().startsWith("mailto:")) {
            a.setStayTime(formTime - startTime);
            NetNode formNode = NetNodeCache.get(formAction);
            Link formLink = LinkCache.get(NetNodeCache.getById(a.getNodeId()), formNode, "");
            a.setLinkId(formLink.getLinkId());
            a.store();
            Access a1 = AccessCache.get(a.getUserId(), a.getNodeId(), formTime, a.getFrameName());
            a1.setAction(8 | a.getAction() & 0x18000000);
            a1.setFragment(a.getFragment());
            a1.setQuery(a.getQuery());
            a1.setParentFrameNodeId(a.getParentFrameNodeId());
            a1.setParentFrameName(a.getParentFrameName());
            a1.setReferrerNodeId(a.getNodeId());
            a1.setParentAccessId(a.getParentAccessId());
            a1.store();
            a = a1;
            a1 = null;
            if (this.accessEventExisted) {
                appletStartTime = formTime;
            } else {
                startTime = formTime;
            }
            this.printMsg("AccessTracking: Mail form submited: New Access event created");
        } else {
            this.history.setLastAction(key, 8);
            a.setLinkId(new Link(NetNodeCache.getById(a.getNodeId()), NetNodeCache.get(formAction), "").getLinkId());
            a.store();
            this.printMsg("AccessTracking: CGI Form was submited");
        }
    }

    public void logMessage(String className, String method, String param) {
        try {
            Class<?> c = Class.forName(className);
            this.printMsg("AccessTracking.logMessage: Loaded class: " + c);
            Method m = c.getDeclaredMethod(method, class$java$lang$String == null ? (class$java$lang$String = EventDecoder.class$("java.lang.String")) : class$java$lang$String);
            this.printMsg("AccessTracking.logMessage: Got method: " + m);
            Object o = m.invoke(null, param);
            this.printMsg("AccessTracking.logMessage: Output: " + o);
        }
        catch (Exception e) {
            ErrorLog.log(this, "logMessage", "Error calling static function:\n" + className + "." + method + "(\"" + param + "\")", e);
        }
    }

    public void printMsg(String textMsg) {
        if (this.showMessages) {
            System.out.println(textMsg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

