/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import scone.accesstracking.AppletConnector;
import scone.accesstracking.MyFrameAccess;
import scone.util.AlertBox;

public class FrameAccessTest
extends Thread {
    private MyFrameAccess mfa;
    private Iterator iterator;
    private String[] frameNameList = new String[]{"No open frames"};
    private String[] targetList = new String[]{"_self", "_parent", "_top", "_blank"};
    private JList list;
    private DefaultListModel listModel;
    private JFrame containerFrame;
    final JTextField url = new JTextField("http://www.scone.de/", 20);
    final JComboBox target = new JComboBox<String>(this.targetList);
    private JButton openUrl;
    private JButton toFront;
    private JButton close;
    private JButton blur;
    private JButton test;
    private JScrollPane listScrollPane;
    private JPanel pane;

    public void run() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.containerFrame = new JFrame("FrameAccess Test GUI");
        ImageIcon img = new ImageIcon("resources/scone/scone64.gif");
        this.containerFrame.setIconImage(img.getImage());
        FrameAccessTest app = new FrameAccessTest();
        this.listModel = new DefaultListModel();
        this.listModel.addElement("List is empty");
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.listScrollPane = new JScrollPane(this.list);
        this.target.setEditable(true);
        this.openUrl = new JButton("Open Above URL");
        this.openUrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppletConnector ac = FrameAccessTest.this.mfa.get(((String)FrameAccessTest.this.list.getSelectedValue()).substring(0, ((String)FrameAccessTest.this.list.getSelectedValue()).lastIndexOf(" ")));
                if (ac != null) {
                    ac.sendToApplet("OpenURL", FrameAccessTest.this.url.getText(), (String)FrameAccessTest.this.target.getSelectedItem());
                } else {
                    AlertBox alertBox = new AlertBox(FrameAccessTest.this.containerFrame, new String[]{"Open URL failed: " + FrameAccessTest.this.url.getText(), "", "Please select a browser window or frame name from the list.", "If no names are listed, please start a browser, set scone as proxy and load a page."});
                }
            }
        });
        this.toFront = new JButton("Bring To Front");
        this.toFront.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppletConnector ac = FrameAccessTest.this.mfa.get(((String)FrameAccessTest.this.list.getSelectedValue()).substring(0, ((String)FrameAccessTest.this.list.getSelectedValue()).lastIndexOf(" ")));
                if (ac != null) {
                    ac.sendToApplet("BringToFront", "", "");
                } else {
                    AlertBox alertBox = new AlertBox(FrameAccessTest.this.containerFrame, new String[]{"Bring to Front failed.", "", "Please select a browser window or frame name from the list."});
                }
            }
        });
        this.blur = new JButton("Blur Window");
        this.blur.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppletConnector ac = FrameAccessTest.this.mfa.get(((String)FrameAccessTest.this.list.getSelectedValue()).substring(0, ((String)FrameAccessTest.this.list.getSelectedValue()).lastIndexOf(" ")));
                if (ac != null) {
                    ac.sendToApplet("BlurBrowser", "", "");
                } else {
                    AlertBox alertBox = new AlertBox(FrameAccessTest.this.containerFrame, new String[]{"Blur Browser failed.", "", "Please select a browser window or frame name from the list."});
                }
            }
        });
        this.close = new JButton("Close Window");
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppletConnector ac = FrameAccessTest.this.mfa.get(((String)FrameAccessTest.this.list.getSelectedValue()).substring(0, ((String)FrameAccessTest.this.list.getSelectedValue()).lastIndexOf(" ")));
                if (ac != null) {
                    ac.sendToApplet("closeBrowser", "", "");
                } else {
                    AlertBox alertBox = new AlertBox(FrameAccessTest.this.containerFrame, new String[]{"Close Browser failed.", "", "Please select a browser window or frame name from the list."});
                }
            }
        });
        this.test = new JButton("Any Function: e.g. move Browser");
        this.test.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppletConnector ac = FrameAccessTest.this.mfa.get(((String)FrameAccessTest.this.list.getSelectedValue()).substring(0, ((String)FrameAccessTest.this.list.getSelectedValue()).lastIndexOf(" ")));
                String command = "window.moveTo(240,0); window.resizeTo(screen.width-240,screen.height-50);";
                if (ac != null) {
                    ac.sendToApplet("anyFunction", command, "");
                } else {
                    AlertBox a = new AlertBox(FrameAccessTest.this.containerFrame, new String[]{"anyFunction failed: " + command, "", "Please select a browser window or frame name from the list."});
                }
            }
        });
        this.pane = new JPanel();
        this.pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pane.setLayout(new GridLayout(7, 1, 3, 3));
        this.pane.add(this.url);
        this.pane.add(this.target);
        this.pane.add(this.openUrl);
        this.pane.add(this.toFront);
        this.pane.add(this.blur);
        this.pane.add(this.close);
        this.pane.add(this.test);
        this.containerFrame.getContentPane().add((Component)this.listScrollPane, "South");
        this.containerFrame.getContentPane().add((Component)this.pane, "Center");
        this.containerFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FrameAccessTest.this.mfa.stopNotifyMe();
            }
        });
        this.containerFrame.pack();
        this.containerFrame.setVisible(true);
        this.mfa = new MyFrameAccess(this);
        this.mfa.notifyMe();
    }

    public void framesChanged(Set contents) {
        Iterator myIterator = contents.iterator();
        String frameString = "";
        this.listModel.clear();
        while (myIterator.hasNext()) {
            frameString = (String)myIterator.next();
            this.listModel.addElement(frameString + " " + this.mfa.getAccessObject(frameString).getNode().toString());
        }
        if (this.listModel.size() == 0) {
            this.listModel.addElement("No open frames");
        }
    }
}

