/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.util.ArrayList;
import scone.accesstracking.FrameSet;
import scone.netobjects.Access;

public class FrameHistory {
    private static final int NEWURL = 32768;
    private ArrayList accessList = new ArrayList();
    private ArrayList timeList = new ArrayList();
    private int position = 0;
    private int lastAction = 32768;

    public void add(String megTime, Access a) {
        this.removeLastEntries(this.timeList.size() - 1 - this.position);
        this.timeList.add(megTime);
        this.accessList.add(a);
        this.position = this.timeList.size() - 1;
    }

    public void add(String megTime, FrameSet frameSet) {
        this.removeLastEntries(this.timeList.size() - 1 - this.position);
        this.timeList.add(megTime);
        this.accessList.add(frameSet);
        this.position = this.timeList.size() - 1;
    }

    public void insert(String megTime, FrameSet frameSet) {
        ++this.position;
        this.timeList.add(this.position, megTime);
        this.accessList.add(this.position, frameSet);
    }

    public boolean contains(String megTime) {
        boolean result = false;
        for (int counter = 0; counter < this.accessList.size(); ++counter) {
            if (this.accessList.get(counter).getClass().getName().endsWith("FrameSet")) {
                if (!((FrameSet)this.accessList.get(counter)).contains(megTime)) continue;
                result = true;
                continue;
            }
            if (!this.timeList.get(counter).equals(megTime)) continue;
            result = true;
        }
        return result;
    }

    public boolean containsPageLike(Access a) {
        boolean result = false;
        for (int counter = 0; counter < this.accessList.size(); ++counter) {
            if (this.accessList.get(counter).getClass().getName().endsWith("FrameSet")) {
                if (!((FrameSet)this.accessList.get(counter)).containsPageLike(a)) continue;
                result = true;
                continue;
            }
            Access a1 = (Access)this.accessList.get(counter);
            if (!a1.getUserId().equals(a.getUserId()) || !a1.getNodeId().equals(a.getNodeId()) || !a1.getFrameName().equals(a.getFrameName()) || !a1.getFragment().equals(a.getFragment()) || !a1.getQuery().equals(a.getQuery()) || !a1.getParentFrameNodeId().equals(a.getParentFrameNodeId()) || !a1.getParentFrameName().equals(a.getParentFrameName())) continue;
            result = true;
        }
        return result;
    }

    private void removeLastEntries(int number) {
        for (int counter = 1; counter <= number; ++counter) {
            if (!this.timeList.isEmpty()) {
                this.timeList.remove(this.timeList.size() - 1);
            }
            if (this.accessList.isEmpty()) continue;
            this.accessList.remove(this.accessList.size() - 1);
        }
    }

    public int getLastAction() {
        return this.lastAction;
    }

    public void setLastAction(int lastAction) {
        this.lastAction = lastAction;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Access getLastEvent(String frameName) {
        if (this.position < this.accessList.size() && this.accessList.size() > 0) {
            if (this.accessList.get(this.position).getClass().getName().endsWith("Access")) {
                return (Access)this.accessList.get(this.position);
            }
            return ((FrameSet)this.accessList.get(this.position)).getLastEvent(frameName);
        }
        System.out.println("FrameHistory.getLastEvent(" + frameName + "): value of variable position outside of list. position = " + (this.position + 1) + ". Item, " + this.accessList.size() + " Items in FrameHistory.");
        return null;
    }

    public Object getLastEntry() {
        if (this.position < this.accessList.size() && this.accessList.size() > 0) {
            return this.accessList.get(this.position);
        }
        return null;
    }

    public Object getPrevEntry() {
        if (0 <= this.position - 1 && this.position - 1 < this.accessList.size() && this.accessList.size() > 0) {
            return this.accessList.get(this.position - 1);
        }
        return null;
    }

    public void replaceLastEvent(String megTime, Access a) {
        if (!this.timeList.isEmpty() && this.position >= 0 && this.position < this.timeList.size()) {
            this.timeList.set(this.position, megTime);
        }
        if (!this.accessList.isEmpty() && this.position >= 0 && this.position < this.accessList.size()) {
            this.accessList.set(this.position, a);
        }
    }

    public void delPrevEntry() {
        if (0 <= this.position - 1 && this.position - 1 < this.accessList.size() && this.accessList.size() > 0) {
            this.accessList.remove(this.position - 1);
            this.timeList.remove(this.position - 1);
            --this.position;
        }
    }

    public void replaceLastEvent(String frameName, String megTime, Access a) {
        if (!this.timeList.isEmpty() && this.position >= 0 && this.position < this.timeList.size()) {
            if (this.accessList.get(this.position).getClass().getName().endsWith("Access")) {
                this.timeList.set(this.position, megTime);
                this.accessList.set(this.position, a);
            } else {
                ((FrameSet)this.accessList.get(this.position)).replaceEvent(frameName, megTime, a);
                this.timeList.set(this.position, megTime);
            }
        }
    }

    public int getDistance(String megTime) {
        int result = Integer.MAX_VALUE;
        for (int counter = 0; counter < this.accessList.size(); ++counter) {
            if (this.accessList.get(counter).getClass().getName().endsWith("Access")) {
                if (!((String)this.timeList.get(counter)).equals(megTime)) continue;
                result = counter - this.position;
                continue;
            }
            if (!((FrameSet)this.accessList.get(counter)).contains(megTime)) continue;
            result = counter - this.position;
        }
        return result;
    }

    public int getDistanceOfPageLike(Access a) {
        int distance = 0;
        boolean diff = false;
        for (int counter = 0; counter < this.accessList.size(); ++counter) {
            if (this.accessList.get(counter).getClass().getName().endsWith("FrameSet")) {
                if (!((FrameSet)this.accessList.get(counter)).containsPageLike(a)) continue;
                distance = counter - this.position;
                continue;
            }
            Access a1 = (Access)this.accessList.get(counter);
            if (!a1.getUserId().equals(a.getUserId()) || !a1.getNodeId().equals(a.getNodeId()) || !a1.getFrameName().equals(a.getFrameName()) || !a1.getFragment().equals(a.getFragment()) || !a1.getQuery().equals(a.getQuery()) || !a1.getParentFrameNodeId().equals(a.getParentFrameNodeId()) || !a1.getParentFrameName().equals(a.getParentFrameName())) continue;
            distance = counter - this.position;
        }
        return distance;
    }

    public void showFrameContents() {
        for (int counter = 0; counter < this.accessList.size(); ++counter) {
            if (this.accessList.get(counter).getClass().getName().endsWith("FrameSet")) {
                System.out.println(counter + " FrameSet");
                ((FrameSet)this.accessList.get(counter)).showFrameSetContents();
                continue;
            }
            System.out.println(counter + " Access obj. with FrameName = " + ((Access)this.accessList.get(counter)).getFrameName());
        }
    }

    public void setPositionTo(String megTime) {
        for (int counter = 0; counter < this.accessList.size(); ++counter) {
            if (this.accessList.get(counter).getClass().getName().endsWith("Access")) {
                if (!this.timeList.get(counter).equals(megTime)) continue;
                this.position = counter;
                continue;
            }
            if (!((FrameSet)this.accessList.get(counter)).contains(megTime)) continue;
            this.position = counter;
        }
    }

    void replaceAllPagesLike(Access a, String megTime) {
        for (int counter = 0; counter < this.accessList.size(); ++counter) {
            if (this.accessList.get(counter).getClass().getName().endsWith("FrameSet")) {
                ((FrameSet)this.accessList.get(counter)).replaceAllPagesLike(a, megTime);
                continue;
            }
            Access a1 = (Access)this.accessList.get(counter);
            if (!a1.getUserId().equals(a.getUserId()) || !a1.getNodeId().equals(a.getNodeId()) || !a1.getFragment().equals(a.getFragment()) || !a1.getQuery().equals(a.getQuery()) || !a1.getParentFrameNodeId().equals(a.getParentFrameNodeId())) continue;
            this.timeList.set(counter, megTime);
        }
    }
}

