/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.util.ArrayList;
import scone.netobjects.Access;

public class FrameSet {
    private static final int NEWURL = 32768;
    private ArrayList frameList = new ArrayList();
    private ArrayList timeList = new ArrayList();
    private int lastChanged = 0;

    public void addToFrameSet(String megTime, Access a) {
        this.timeList.add(megTime);
        this.frameList.add(a);
        this.lastChanged = this.frameList.size() - 1;
    }

    public void addToFrameSet(String megTime, FrameSet fs) {
        this.timeList.add(megTime);
        this.frameList.add(fs);
        this.lastChanged = this.frameList.size() - 1;
    }

    public boolean contains(String megTime) {
        boolean result = false;
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (this.frameList.get(counter).getClass().getName().endsWith("FrameSet")) {
                if (!((FrameSet)this.frameList.get(counter)).contains(megTime)) continue;
                result = true;
                continue;
            }
            if (!this.timeList.get(counter).equals(megTime)) continue;
            result = true;
        }
        return result;
    }

    public boolean containsPageLike(Access a) {
        boolean result = false;
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (this.frameList.get(counter).getClass().getName().endsWith("FrameSet")) {
                if (!((FrameSet)this.frameList.get(counter)).containsPageLike(a)) continue;
                result = true;
                continue;
            }
            Access a1 = (Access)this.frameList.get(counter);
            if (!a1.getUserId().equals(a.getUserId()) || !a1.getNodeId().equals(a.getNodeId()) || !a1.getFrameName().equals(a.getFrameName()) || !a1.getFragment().equals(a.getFragment()) || !a1.getQuery().equals(a.getQuery()) || !a1.getParentFrameNodeId().equals(a.getParentFrameNodeId()) || !a1.getParentFrameName().equals(a.getParentFrameName())) continue;
            result = true;
        }
        return result;
    }

    public Access getLastEvent(String frameName) {
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (this.frameList.get(counter).getClass().getName().endsWith("Access")) {
                if (!((Access)this.frameList.get(counter)).getFrameName().equals(frameName)) continue;
                return (Access)this.frameList.get(counter);
            }
            return ((FrameSet)this.frameList.get(counter)).getLastEvent(frameName);
        }
        if (this.lastChanged < this.frameList.size() && this.frameList.size() > 0) {
            if (this.frameList.get(this.lastChanged).getClass().getName().endsWith("Access")) {
                return (Access)this.frameList.get(this.lastChanged);
            }
            return ((FrameSet)this.frameList.get(this.lastChanged)).getLastEvent(frameName);
        }
        return null;
    }

    public Access getFirstEvent() {
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (!this.frameList.get(counter).getClass().getName().endsWith("Access")) continue;
            return (Access)this.frameList.get(counter);
        }
        return null;
    }

    public void setParentAccessIds(String parentAccessId) {
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (!this.frameList.get(counter).getClass().getName().endsWith("Access")) continue;
            ((Access)this.frameList.get(counter)).setParentAccessId(parentAccessId);
        }
    }

    public void showFrameSetContents() {
        System.out.println("Contents of Frame:");
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (this.frameList.get(counter).getClass().getName().endsWith("Access")) {
                System.out.println("   " + this.timeList.get(counter) + "  " + ((Access)this.frameList.get(counter)).getFrameName());
                continue;
            }
            System.out.println("FrameStart");
            ((FrameSet)this.frameList.get(counter)).showFrameSetContents();
            System.out.println("FrameEnde");
        }
    }

    public boolean noStoppedEvents() {
        boolean result = true;
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (this.frameList.get(counter).getClass().getName().endsWith("Access")) {
                if (((Access)this.frameList.get(counter)).getStayTime() == 0L) continue;
                result = false;
                continue;
            }
            if (((FrameSet)this.frameList.get(counter)).noStoppedEvents()) continue;
            result = false;
        }
        return result;
    }

    public void copyUnstoppedEvents(FrameSet source) {
        boolean result = true;
        for (int counter = 0; counter < source.getFrameListSize(); ++counter) {
            if (source.getFrame(counter).getClass().getName().endsWith("Access")) {
                if (((Access)source.getFrame(counter)).getStayTime() != 0L) continue;
                this.addToFrameSet(source.getMegTime(counter), (Access)source.getFrame(counter));
                continue;
            }
            FrameSet fs = new FrameSet();
            fs.copyUnstoppedEvents((FrameSet)source.getFrame(counter));
            if (fs.getFrameListSize() <= 0) continue;
            this.addToFrameSet(source.getMegTime(counter), fs);
        }
    }

    public int getFrameListSize() {
        return this.frameList.size();
    }

    public Object getFrame(int index) {
        return this.frameList.get(index);
    }

    public String getMegTime(int index) {
        return (String)this.timeList.get(index);
    }

    public void replaceEvent(String frameName, String megTime, Access a) {
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (this.frameList.get(counter).getClass().getName().endsWith("Access")) {
                if (!((Access)this.frameList.get(counter)).getFrameName().equals(frameName)) continue;
                this.frameList.set(counter, a);
                this.timeList.set(counter, megTime);
                continue;
            }
            ((FrameSet)this.frameList.get(counter)).replaceEvent(frameName, megTime, a);
        }
    }

    void replaceAllPagesLike(Access a, String megTime) {
        for (int counter = 0; counter < this.frameList.size(); ++counter) {
            if (this.frameList.get(counter).getClass().getName().endsWith("FrameSet")) {
                ((FrameSet)this.frameList.get(counter)).replaceAllPagesLike(a, megTime);
                continue;
            }
            Access a1 = (Access)this.frameList.get(counter);
            if (!a1.getUserId().equals(a.getUserId()) || !a1.getNodeId().equals(a.getNodeId()) || !a1.getFragment().equals(a.getFragment()) || !a1.getQuery().equals(a.getQuery()) || !a1.getParentFrameNodeId().equals(a.getParentFrameNodeId())) continue;
            this.timeList.set(counter, megTime);
        }
    }
}

