/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scone.accesstracking.AccessTracking;
import scone.accesstracking.IESpyData;
import scone.accesstracking.IESpyEventDecoder;
import scone.accesstracking.IESpyLastAction;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;
import scone.ras.Connection;
import scone.ras.ConnectionHandler;
import scone.util.ErrorLog;

public class IESpyConnector
implements ConnectionHandler {
    private Connection c;
    private Map[] dataMap = new Map[21];
    private Map[] eventDecoderMap = new Map[21];
    private IESpyLastAction[] lastAction = new IESpyLastAction[21];
    private IESpyEventDecoder constants;
    private boolean showMessages;

    public void handle(Connection c) {
        String inputLine = null;
        String frameName = null;
        String timeString = null;
        IESpyEventDecoder theEventDecoder = null;
        IESpyData theIeData = null;
        int ieNumber = 0;
        int lastGlobalAction = 0;
        System.out.println("\n-> Scone: Connection established to IESpy");
        try {
            this.showMessages = AccessTracking.props.get("Acesstracking1: Show status messages").equals("true");
        }
        catch (Exception exc) {
            ErrorLog.log(this, "AppletConnector: Error while reading Scone properties", "", exc);
        }
        try {
            while ((inputLine = c.read()) != null) {
                int endPos;
                int startPos;
                try {
                    ieNumber = Integer.parseInt(inputLine.substring(20, inputLine.indexOf(59, 20)));
                    if (ieNumber >= 0 && ieNumber <= 20 && this.dataMap[ieNumber] == null) {
                        this.dataMap[ieNumber] = new HashMap();
                        this.eventDecoderMap[ieNumber] = new HashMap();
                        this.lastAction[ieNumber] = new IESpyLastAction(256);
                    }
                }
                catch (NumberFormatException e) {
                    ieNumber = -1;
                }
                catch (StringIndexOutOfBoundsException se) {
                    ieNumber = -1;
                }
                try {
                    timeString = inputLine.substring(0, 12);
                }
                catch (Exception e) {
                    timeString = "";
                }
                if (inputLine.indexOf("BNAV; \"") <= -1) {
                    if (inputLine.indexOf("IEOF; ") > -1) {
                        this.lastAction[ieNumber].set(256);
                    } else {
                        startPos = inputLine.indexOf("STXT; \"");
                        if (startPos > -1 && inputLine.indexOf(":Scone") > -1) {
                            endPos = inputLine.indexOf(":Scone");
                            frameName = inputLine.substring(startPos + 7, endPos);
                            if (ieNumber >= 0 && ieNumber <= 20) {
                                if (this.dataMap[ieNumber].containsKey(frameName)) {
                                    theIeData = (IESpyData)this.dataMap[ieNumber].get(frameName);
                                    theEventDecoder = (IESpyEventDecoder)this.eventDecoderMap[ieNumber].get(frameName);
                                } else {
                                    this.dataMap[ieNumber].put(frameName, new IESpyData());
                                    this.eventDecoderMap[ieNumber].put(frameName, new IESpyEventDecoder());
                                    theIeData = (IESpyData)this.dataMap[ieNumber].get(frameName);
                                    theEventDecoder = (IESpyEventDecoder)this.eventDecoderMap[ieNumber].get(frameName);
                                }
                            }
                            startPos = endPos + 1;
                            endPos = inputLine.lastIndexOf("\";");
                            try {
                                inputLine = inputLine.substring(startPos, endPos);
                            }
                            catch (StringIndexOutOfBoundsException siob) {
                                siob.printStackTrace();
                                System.out.println("Exception: startPos=" + startPos);
                                System.out.println("Exception: endPos=" + endPos);
                                System.out.println("Exception: inputLine=" + inputLine);
                            }
                            if (inputLine.startsWith("SconeStartTime=")) {
                                Calendar calendar = Calendar.getInstance();
                                calendar.setTime(new Date());
                                calendar.set(11, Integer.parseInt(timeString.substring(0, 2)));
                                calendar.set(12, Integer.parseInt(timeString.substring(3, 5)));
                                calendar.set(13, Integer.parseInt(timeString.substring(6, 8)));
                                calendar.set(14, Integer.parseInt(timeString.substring(9, 12)));
                                Date date = calendar.getTime();
                                theIeData.setStartTime(date.getTime());
                                if (lastGlobalAction != 0) {
                                    if (this.lastAction[ieNumber].get() == 256) {
                                        this.lastAction[ieNumber].set(lastGlobalAction);
                                        lastGlobalAction = 0;
                                    }
                                }
                                this.printMsg("IESpyConnector: StartTime: " + theIeData.getStartTime());
                            } else if (inputLine.startsWith("SconeUserId=")) {
                                theIeData.setUserId(inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: UserId: " + theIeData.getUserId());
                                theIeData.setFrameName(frameName);
                                this.printMsg("IESpyConnector: FrameName: " + theIeData.getFrameName());
                            } else if (inputLine.startsWith("SconeNodeId=")) {
                                theIeData.setNodeId(inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: NodeId: " + theIeData.getNodeId());
                            } else if (inputLine.startsWith("SconeFragment=")) {
                                theIeData.setFragment(inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: Fragment:" + theIeData.getFragment());
                            } else if (inputLine.startsWith("SconeQuery=")) {
                                theIeData.setQuery(inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: Query: " + theIeData.getQuery());
                            } else if (inputLine.startsWith("SconeParentNodeName=")) {
                                theIeData.setParentNodeName(inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: ParentNodeName: " + theIeData.getParentNodeName());
                            } else if (inputLine.startsWith("SconeParentFrameName=")) {
                                theIeData.setParentFrameName(inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: ParentFrameName: " + theIeData.getParentFrameName());
                            } else if (inputLine.startsWith("SconeReferrer=")) {
                                theIeData.setReferrer(inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: Referrer: " + theIeData.getReferrer());
                            } else if (inputLine.startsWith("SconeFrameCount=")) {
                                int frameCountNumber;
                                try {
                                    frameCountNumber = Integer.parseInt(inputLine.substring(inputLine.indexOf("=") + 1));
                                }
                                catch (Exception excep) {
                                    excep.printStackTrace();
                                    frameCountNumber = -1;
                                }
                                theIeData.setFrameCount(frameCountNumber);
                                this.printMsg("IESpyConnector: FrameCount" + theIeData.getFrameCount());
                            } else if (inputLine.startsWith("SconeLoadTime=")) {
                                theEventDecoder.pageLoaded(Long.parseLong(inputLine.substring(inputLine.indexOf("=") + 1)));
                                this.printMsg("IESpyConnector: Page loaded");
                            } else if (inputLine.startsWith("SconeLinkId=")) {
                                Calendar calendar = Calendar.getInstance();
                                calendar.setTime(new Date());
                                calendar.set(11, Integer.parseInt(timeString.substring(0, 2)));
                                calendar.set(12, Integer.parseInt(timeString.substring(3, 5)));
                                calendar.set(13, Integer.parseInt(timeString.substring(6, 8)));
                                calendar.set(14, Integer.parseInt(timeString.substring(9, 12)));
                                Date date = calendar.getTime();
                                long linkTime = date.getTime();
                                String linkId = inputLine.substring(inputLine.indexOf("=") + 1);
                                if (theIeData.getFrameCount() == 0) {
                                    this.lastAction[ieNumber].set(1);
                                    theEventDecoder.linkClicked(linkId, linkTime);
                                    this.printMsg("IESpyConnector: Link Clicked, LinkId: " + linkId);
                                } else {
                                    Link link = LinkCache.getById(linkId);
                                    String targetFrameName = link.getTarget().toLowerCase();
                                    if (!targetFrameName.equals("_parent") && !targetFrameName.equals("_top")) {
                                        if (targetFrameName.equals("") || targetFrameName.equals("_self")) {
                                            this.lastAction[ieNumber].set(1);
                                            theEventDecoder.linkClicked(linkId, linkTime);
                                            this.printMsg("IESpyConnector: Link in Frame Clicked, LinkId: " + linkId);
                                        } else {
                                            Iterator iterator = this.eventDecoderMap[ieNumber].keySet().iterator();
                                            String frame = null;
                                            while (iterator.hasNext()) {
                                                frame = (String)iterator.next();
                                                if (!frame.toLowerCase().equals(targetFrameName)) continue;
                                                IESpyEventDecoder evDec = (IESpyEventDecoder)this.eventDecoderMap[ieNumber].get(frame);
                                                this.lastAction[ieNumber].set(1);
                                                evDec.linkClicked(linkId, linkTime);
                                                this.printMsg("IESpyConnector: Link in Frame: " + frame + " clicked, LinkId: " + linkId);
                                            }
                                        }
                                    }
                                }
                            } else if (inputLine.startsWith("SconeFormAction=")) {
                                theEventDecoder.formSubmited(8L, inputLine.substring(inputLine.indexOf("=") + 1));
                                this.printMsg("IESpyConnector: Form Submited");
                            } else if (inputLine.startsWith("SconeStopTime=")) {
                                theEventDecoder.pageUnloaded(new Date().getTime());
                                this.printMsg("IESpyConnector: Applet Stopped");
                            }
                        }
                    }
                }
                if (ieNumber < 0 || ieNumber > 20 || this.dataMap[ieNumber] == null) continue;
                if (this.dataMap[ieNumber].containsKey(frameName)) {
                    theIeData = (IESpyData)this.dataMap[ieNumber].get(frameName);
                    theEventDecoder = (IESpyEventDecoder)this.eventDecoderMap[ieNumber].get(frameName);
                    if (theIeData.startedComplete()) {
                        theEventDecoder.javaScriptStarted(theIeData.getStartTime(), theIeData.getUserId(), theIeData.getNodeId(), theIeData.getFragment(), theIeData.getQuery(), theIeData.getFrameName(), theIeData.getParentNodeName(), theIeData.getParentFrameName(), theIeData.getReferrer(), theIeData.getFrameCount(), this.showMessages, this.lastAction[ieNumber]);
                        theIeData.clearAppletStarted();
                    }
                }
                if (inputLine.indexOf("ABED; ") > -1) {
                    if ((this.lastAction[ieNumber].get() & 0x400) == 0) {
                        if ((this.lastAction[ieNumber].get() & 0x200) == 0) {
                            if ((this.lastAction[ieNumber].get() & 0x1000) == 0) {
                                this.lastAction[ieNumber].set(2048);
                                this.printMsg("IESpyConnector: AdressBar");
                            }
                        }
                    }
                }
                if (inputLine.indexOf("FAVS; ") > -1) {
                    this.lastAction[ieNumber].set(0x200 | 0x1000000);
                    this.printMsg("IESpyConnector: Bookmark");
                }
                if (inputLine.indexOf("LBIS; ") > -1) {
                    this.lastAction[ieNumber].set(1024);
                    this.printMsg("IESpyConnector: LinkButton");
                }
                if (inputLine.indexOf("EBIS; ") > -1) {
                    if ((this.lastAction[ieNumber].get() & 0x100) != 0) continue;
                    if ((this.lastAction[ieNumber].get() & 0x400) != 0) continue;
                    if ((this.lastAction[ieNumber].get() & 0x200) != 0) continue;
                    if ((this.lastAction[ieNumber].get() & 0x800) != 0) continue;
                    if ((this.lastAction[ieNumber].get() & 0x1000) != 0) continue;
                    this.lastAction[ieNumber].set(8192);
                    this.printMsg("IESpyConnector: ExplorerBar");
                    continue;
                }
                if (inputLine.indexOf("TBBC; ") > -1) {
                    if (inputLine.indexOf("Zur ck") > -1) {
                        this.lastAction[ieNumber].set(0x20 | 0x2000000);
                        this.printMsg("IESpyConnector: Toolbar button: back");
                        continue;
                    }
                    if (inputLine.indexOf("Vor") > -1) {
                        this.lastAction[ieNumber].set(0x40 | 0x2000000);
                        this.printMsg("IESpyConnector: Toolbar button: next");
                        continue;
                    }
                    if (inputLine.indexOf("Aktualisieren") > -1) {
                        this.lastAction[ieNumber].set(0x10 | 0x2000000);
                        this.printMsg("IESpyConnector: Toolbar button: reload");
                        continue;
                    }
                    if (inputLine.indexOf("Startseite") <= -1) continue;
                    this.lastAction[ieNumber].set(0x1000 | 0x2000000);
                    this.printMsg("IESpyConnector: Toolbar button: home");
                    continue;
                }
                if (inputLine.indexOf("MSTB; ") > -1) {
                    int steps;
                    if (inputLine.indexOf("Zur ck") > -1) {
                        int steps2;
                        startPos = inputLine.indexOf(59, inputLine.indexOf("Zur ck")) + 1;
                        endPos = inputLine.indexOf(59, startPos);
                        try {
                            steps2 = Integer.parseInt(inputLine.substring(startPos + 1, endPos));
                        }
                        catch (NumberFormatException nfe) {
                            steps2 = 1;
                        }
                        if (steps2 > 1) {
                            this.lastAction[ieNumber].set(0x20 | 0x4000000 | 0x80);
                            this.lastAction[ieNumber].setStepsInHistory(steps2);
                            this.printMsg("IESpyConnector: Toolbar menu: back multi (" + steps2 + " step(s))");
                        } else {
                            this.lastAction[ieNumber].set(0x20 | 0x4000000);
                            this.lastAction[ieNumber].setStepsInHistory(steps2);
                            this.printMsg("IESpyConnector: Toolbar menu: back");
                        }
                    }
                    if (inputLine.indexOf("Vor") <= -1) continue;
                    startPos = inputLine.indexOf(59, inputLine.indexOf("Vor")) + 1;
                    endPos = inputLine.indexOf(59, startPos);
                    try {
                        steps = Integer.parseInt(inputLine.substring(startPos + 1, endPos));
                    }
                    catch (NumberFormatException nfe) {
                        steps = 1;
                    }
                    if (steps > 1) {
                        this.lastAction[ieNumber].set(0x40 | 0x4000000 | 0x80);
                        this.lastAction[ieNumber].setStepsInHistory(steps);
                        this.printMsg("IESpyConnector: Toolbar menu: next multi (" + steps + " step(s))");
                        continue;
                    }
                    this.lastAction[ieNumber].set(0x40 | 0x4000000);
                    this.lastAction[ieNumber].setStepsInHistory(steps);
                    this.printMsg("IESpyConnector: Toolbar menu: next");
                    continue;
                }
                if (inputLine.indexOf("MSMM; ") > -1) {
                    if (inputLine.indexOf("/Zur ck") > -1) {
                        this.lastAction[ieNumber].set(0x20 | 0x1000000);
                        this.lastAction[ieNumber].setStepsInHistory(1);
                        this.printMsg("IESpyConnector: Main menu: back");
                        continue;
                    }
                    if (inputLine.indexOf("/Vor") > -1) {
                        this.lastAction[ieNumber].set(0x40 | 0x1000000);
                        this.lastAction[ieNumber].setStepsInHistory(1);
                        this.printMsg("IESpyConnector: Main menu: next");
                        continue;
                    }
                    if (inputLine.indexOf("/Aktualisieren") > -1) {
                        this.lastAction[ieNumber].set(0x10 | 0x1000000);
                        this.printMsg("IESpyConnector: Main menu: reload");
                        continue;
                    }
                    if (inputLine.indexOf("/StartSeite") > -1) {
                        this.lastAction[ieNumber].set(0x1000 | 0x1000000);
                        this.printMsg("IESpyConnector: Main menu: home");
                        continue;
                    }
                    if (inputLine.indexOf("Seiten zur ck") > -1) {
                        int steps;
                        startPos = inputLine.indexOf("zu/<") + 4;
                        try {
                            steps = Integer.parseInt(inputLine.substring(startPos, startPos + 2).trim());
                        }
                        catch (NumberFormatException nfe) {
                            steps = 1;
                        }
                        this.lastAction[ieNumber].set(0x20 | 0x80 | 0x1000000);
                        this.lastAction[ieNumber].setStepsInHistory(steps);
                        this.printMsg("IESpyConnector: Main menu: back, " + steps + " steps");
                        continue;
                    }
                    if (inputLine.indexOf("Seiten vor") > -1) {
                        int steps;
                        startPos = inputLine.indexOf("zu/<") + 4;
                        try {
                            steps = Integer.parseInt(inputLine.substring(startPos, startPos + 2).trim());
                        }
                        catch (NumberFormatException nfe) {
                            steps = 1;
                        }
                        this.lastAction[ieNumber].set(0x40 | 0x80 | 0x1000000);
                        this.lastAction[ieNumber].setStepsInHistory(steps);
                        this.printMsg("IESpyConnector: Main menu: next, " + steps + " steps");
                        continue;
                    }
                    if (inputLine.indexOf("Seite zur ck") > -1) {
                        this.lastAction[ieNumber].set(0x20 | 0x1000000);
                        this.lastAction[ieNumber].setStepsInHistory(1);
                        this.printMsg("IESpyConnector: Main menu: back");
                        continue;
                    }
                    if (inputLine.indexOf("Seite vor") <= -1) continue;
                    this.lastAction[ieNumber].set(0x40 | 0x1000000);
                    this.lastAction[ieNumber].setStepsInHistory(1);
                    this.printMsg("IESpyConnector: Main menu: next");
                    continue;
                }
                if (inputLine.indexOf("MSHA; ") > -1) {
                    if (inputLine.indexOf("Zurueck") > -1) {
                        this.lastAction[ieNumber].set(0x20 | 0x800000);
                        this.printMsg("IESpyConnector: html menu: back");
                    } else if (inputLine.indexOf("Vor") > -1) {
                        this.lastAction[ieNumber].set(0x40 | 0x800000);
                        this.printMsg("IESpyConnector: html menu: next");
                    } else if (inputLine.indexOf("Aktualisieren") > -1) {
                        this.lastAction[ieNumber].set(0x10 | 0x800000);
                        this.printMsg("IESpyConnector: Main menu: reload");
                    }
                    if (inputLine.indexOf("In neuem Fenster oeffnen") <= -1) continue;
                    lastGlobalAction = 0x100 | 0x800000;
                    this.printMsg("IESpyConnector: html menu: open link in new window");
                    continue;
                }
                if (inputLine.indexOf("HOTK; ") <= -1) continue;
                if (inputLine.indexOf("Zurueck") > -1) {
                    this.lastAction[ieNumber].set(0x20 | 0x400000);
                    this.printMsg("IESpyConnector: hotkey: back");
                    continue;
                }
                if (inputLine.indexOf("Vor") > -1) {
                    this.lastAction[ieNumber].set(0x40 | 0x400000);
                    this.printMsg("IESpyConnector: hotkey: next");
                    continue;
                }
                if (inputLine.indexOf("Aktualisieren") <= -1) continue;
                this.lastAction[ieNumber].set(0x10 | 0x400000);
                this.printMsg("IESpyConnector: hotkey: reload");
            }
            c.close();
        }
        catch (IOException e) {
            System.out.println("\n-> Scone: Connection to IESpy closed");
        }
        catch (Exception ex) {
            System.out.println("Exception");
            ex.printStackTrace();
        }
    }

    void writeToApplet(String msgToSend) {
        try {
            this.c.write(msgToSend);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendToApplet(String command, String parameter1, String parameter2) {
        this.writeToApplet("command=" + command.toLowerCase().trim() + "\nparameter1=" + parameter1.trim() + "\nparameter2=" + parameter2.trim() + "\n");
    }

    public String getParameter(String inputLine, String paramName) {
        if (inputLine.indexOf("\n" + paramName + "=") > -1) {
            int startPos = inputLine.indexOf("\n" + paramName + "=") + paramName.length() + 2;
            int endPos = inputLine.indexOf("\n", startPos);
            return inputLine.substring(startPos, endPos);
        }
        System.out.println("Gesuchter Parameter " + paramName + " ist nicht im String " + inputLine + " enthalten!");
        return "";
    }

    public void printMsg(String textMsg) {
        if (this.showMessages) {
            System.out.println(textMsg);
        }
    }
}

