/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import java.lang.reflect.Method;
import java.util.Date;
import scone.accesstracking.AccessTracking;
import scone.accesstracking.BrowserHistory;
import scone.accesstracking.FrameAccess;
import scone.accesstracking.FrameHistory;
import scone.accesstracking.FrameSet;
import scone.accesstracking.IESpyLastAction;
import scone.accesstracking.UriStripper;
import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.util.ErrorLog;

public class IESpyEventDecoder {
    public static final int LINK = 1;
    public static final int FRAGMENT = 2;
    public static final int SELFLINK = 4;
    public static final int FORMSUBMIT = 8;
    public static final int RELOAD = 16;
    public static final int BACK = 32;
    public static final int NEXT = 64;
    public static final int SKIPPED = 128;
    public static final int NEWWINDOW = 256;
    public static final int BOOKMARK = 512;
    public static final int LINKBUTTON = 1024;
    public static final int ADDRESSBAR = 2048;
    public static final int HOME = 4096;
    public static final int EXPLORERBAR = 8192;
    public static final int HOTKEY = 0x400000;
    public static final int HTMLMENU = 0x800000;
    public static final int MAINMENU = 0x1000000;
    public static final int TBBUTTON = 0x2000000;
    public static final int TBMENU = 0x4000000;
    public static final int BROWSER_NS = 0x8000000;
    public static final int BROWSER_IE = 0x10000000;
    public static final int HEURISTIC = 0x40000000;
    private BrowserHistory history;
    private boolean showMessages;
    private Access a;
    private long startTime = 0L;
    private int frameCount;
    private String key;
    private IESpyLastAction lastAction = null;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void javaScriptStarted(long startTime, String userId, String nodeId, String fragment, String query, String frameName, String parentNodeName, String parentFrameName, String referrer, int frameCount, boolean showMessages, IESpyLastAction lastAction) {
        FrameAccess frameAccess = FrameAccess.getInstance();
        this.lastAction = lastAction;
        this.history = BrowserHistory.getInstance();
        this.showMessages = showMessages;
        this.a = AccessCache.get(userId, nodeId, startTime, frameName);
        frameAccess.addAccessObject(parentFrameName, frameName, this.a);
        if (fragment.startsWith("#")) {
            fragment = fragment.substring(1);
        }
        this.a.setFragment(fragment);
        this.a.setQuery(query);
        parentNodeName = new UriStripper(parentNodeName).getUri();
        if (!parentNodeName.equals("") && !parentNodeName.equals(":")) {
            this.a.setParentFrameNodeId(NetNodeCache.get(parentNodeName).getNodeId());
        }
        this.a.setParentFrameName(parentFrameName);
        referrer = new UriStripper(referrer).getUri();
        if (!referrer.equals("") && !referrer.equals(":")) {
            this.a.setReferrerNodeId(NetNodeCache.get(referrer).getNodeId());
        }
        this.a.setAction(0x10000000);
        this.startTime = startTime;
        this.a.store();
        this.frameCount = frameCount;
        this.key = this.history.createKey(userId, parentFrameName, frameName);
        if (frameCount > 0) {
            FrameHistory fh;
            FrameHistory frameHistory = fh = this.history.getFrameHistory(this.key);
            synchronized (frameHistory) {
                switch (lastAction.get() & 0x3FFF) {
                    case 256: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: new browser window");
                        break;
                    }
                    case 1: 
                    case 5: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: Link clicked");
                        break;
                    }
                    case 32: 
                    case 160: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.a.setStepsInHistory(lastAction.getStepsInHistory());
                        this.printMsg("AccessTracking: Back clicked (" + lastAction.getStepsInHistory() + " step(s))");
                        break;
                    }
                    case 64: 
                    case 192: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.a.setStepsInHistory(lastAction.getStepsInHistory());
                        this.printMsg("AccessTracking: Next clicked (" + lastAction.getStepsInHistory() + " step(s))");
                        break;
                    }
                    case 4096: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: HOME clicked");
                        break;
                    }
                    case 16: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: Reload clicked");
                        break;
                    }
                    case 2048: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: new URL typed in or chosen from pulldown");
                        break;
                    }
                    case 8192: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: Explorerbar (Favorites or history)");
                        break;
                    }
                    case 512: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: Bookmark clicked");
                        break;
                    }
                    case 1024: {
                        this.a.setAction(this.a.getAction() | lastAction.get());
                        this.printMsg("AccessTracking: Button of Link bar clicked");
                    }
                }
                Object fhEntry = this.history.getLastEntry(this.key);
                if (fhEntry == null) {
                    FrameSet fs = new FrameSet();
                    fs.addToFrameSet(Long.toString(startTime), this.a);
                    Access pa = new Access(userId, this.a.getParentFrameNodeId(), new Date().getTime(), parentFrameName);
                    pa.setAction(this.a.getAction() & 0x18000000);
                    pa.store();
                    AccessCache.broadcastEvent(new AccessEvent(pa));
                    this.a.setParentAccessId(pa.getAccessId());
                    fs.setParentAccessIds(pa.getAccessId());
                    if (frameCount == fs.getFrameListSize()) {
                        lastAction.set(0);
                    }
                    this.history.add(this.key, Long.toString(startTime), fs);
                } else if (fhEntry.getClass().getName().endsWith("FrameSet")) {
                    if (((FrameSet)fhEntry).noStoppedEvents()) {
                        Object prevEntry;
                        if ((this.a.getAction() & 0x3FFF) == 0 && (prevEntry = this.history.getPrevEntry(this.key)) != null && !prevEntry.getClass().getName().endsWith("Access") && ((FrameSet)prevEntry).containsPageLike(this.a)) {
                            this.a.setAction(0x10 | this.a.getAction() & 0x18000000);
                        }
                        this.a.setParentAccessId(((FrameSet)fhEntry).getFirstEvent().getParentAccessId());
                        this.a.store();
                        ((FrameSet)fhEntry).addToFrameSet(Long.toString(startTime), this.a);
                        if (frameCount == ((FrameSet)fhEntry).getFrameListSize()) {
                            lastAction.set(0);
                            if ((this.a.getAction() & 0x10) == 16) {
                                this.history.delPrevEntry(this.key);
                            }
                        }
                    } else {
                        if ((this.a.getAction() & 0x3FFF) == 0 && ((FrameSet)fhEntry).containsPageLike(this.a)) {
                            this.a.setAction(0x10 | this.a.getAction() & 0x18000000);
                        }
                        FrameSet fs = new FrameSet();
                        fs.copyUnstoppedEvents((FrameSet)fhEntry);
                        fs.addToFrameSet(Long.toString(startTime), this.a);
                        if (((FrameSet)fhEntry).getFirstEvent() != null) {
                            Access prevAccess = ((FrameSet)fhEntry).getFirstEvent();
                            if (this.a.getParentFrameNodeId().equals(prevAccess.getParentFrameNodeId())) {
                                this.a.setParentAccessId(prevAccess.getParentAccessId());
                            } else {
                                Access pa = new Access(userId, this.a.getParentFrameNodeId(), new Date().getTime(), parentFrameName);
                                pa.setAction(this.a.getAction() & 0x18000000);
                                pa.store();
                                AccessCache.broadcastEvent(new AccessEvent(pa));
                                this.a.setParentAccessId(pa.getAccessId());
                            }
                        }
                        fs.setParentAccessIds(this.a.getParentAccessId());
                        if (frameCount == fs.getFrameListSize()) {
                            lastAction.set(0);
                        }
                        this.a.setReferrerNodeId(((FrameSet)fhEntry).getLastEvent(frameName).getNodeId());
                        this.a.store();
                        if ((this.a.getAction() & 0x10) == 16) {
                            this.history.insert(this.key, Long.toString(startTime), fs);
                        } else {
                            this.history.add(this.key, Long.toString(startTime), fs);
                        }
                    }
                } else {
                    FrameSet fs = new FrameSet();
                    fs.addToFrameSet(Long.toString(startTime), this.a);
                    Access pa = new Access(userId, this.a.getParentFrameNodeId(), new Date().getTime(), parentFrameName);
                    pa.setAction(this.a.getAction() & 0x18000000);
                    pa.store();
                    AccessCache.broadcastEvent(new AccessEvent(pa));
                    this.a.setParentAccessId(pa.getAccessId());
                    fs.setParentAccessIds(pa.getAccessId());
                    if (frameCount == fs.getFrameListSize()) {
                        lastAction.set(0);
                    }
                    this.history.add(this.key, Long.toString(startTime), fs);
                }
            }
        } else {
            switch (lastAction.get() & 0x3FFF) {
                case 256: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: new window");
                    break;
                }
                case 5: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: Link to same URL clicked");
                    break;
                }
                case 8: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: Form submited");
                    break;
                }
                case 1: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: Link clicked");
                    break;
                }
                case 32: 
                case 160: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.a.setStepsInHistory(lastAction.getStepsInHistory());
                    this.printMsg("AccessTracking: Back clicked (" + lastAction.getStepsInHistory() + " step(s))");
                    break;
                }
                case 64: 
                case 192: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.a.setStepsInHistory(lastAction.getStepsInHistory());
                    this.printMsg("AccessTracking: Next clicked (" + lastAction.getStepsInHistory() + " step(s))");
                    break;
                }
                case 4096: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: HOME clicked");
                    break;
                }
                case 16: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: Reload clicked");
                    break;
                }
                case 2048: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: new URL typed in or chosen from pulldown");
                    break;
                }
                case 8192: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: Explorerbar (favorites or history)");
                    break;
                }
                case 512: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: Bookmark clicked");
                    break;
                }
                case 1024: {
                    this.a.setAction(this.a.getAction() | lastAction.get());
                    this.printMsg("AccessTracking: Button of Link bar clicked");
                }
            }
            lastAction.set(0);
            this.history.add(this.key, Long.toString(startTime), this.a);
            this.a.store();
        }
        AccessCache.broadcastEvent(new AccessEvent(this.a));
    }

    void pageLoaded(long loadedTime) {
        long loadTime = 0L;
        loadTime = loadedTime - this.startTime;
        if (this.a != null) {
            this.a.setLoadTime(loadTime);
            this.a.store();
        }
        this.printMsg("AccessTracking: Load time: " + loadTime);
        if (AccessTracking.props.get("Create extra event after page is loaded").equals("true")) {
            AccessCache.broadcastEvent(new AccessEvent(this.a));
        }
    }

    public void pageUnloaded(long stoppedTime) {
        long stayTime = 0L;
        stayTime = stoppedTime - this.startTime;
        this.printMsg("AccessTracking: Stay time: " + stayTime);
        if (this.a != null) {
            this.a.setStayTime(stayTime);
            this.a.store();
            if (AccessTracking.props.get("Create extra events after user leaves a page").equals("true")) {
                AccessCache.broadcastEvent(new AccessEvent(this.a));
            }
        }
    }

    public void linkClicked(String linkId, long linkTime) {
        if (this.a != null) {
            Link link = LinkCache.getById(linkId);
            if (this.frameCount > 0) {
                if (link.getToNode().getNodeId().equals(this.a.getNodeId())) {
                    if (link.getFragment().equals(this.a.getFragment())) {
                        this.lastAction.set(5);
                    } else {
                        this.a.setStayTime(linkTime - this.a.getTime());
                        this.printMsg("AccessTracking: StayTime: " + this.a.getStayTime());
                        this.a.setLinkId(link.getLinkId());
                        this.a.store();
                        Access a1 = AccessCache.get(this.a.getUserId(), this.a.getNodeId(), linkTime, this.a.getFrameName());
                        a1.setAction(3 | this.a.getAction() & 0x18000000);
                        a1.setFragment(link.getFragment());
                        a1.setQuery(this.a.getQuery());
                        a1.setParentFrameNodeId(this.a.getParentFrameNodeId());
                        a1.setParentFrameName(this.a.getParentFrameName());
                        a1.setReferrerNodeId(this.a.getNodeId());
                        a1.setParentAccessId(this.a.getParentAccessId());
                        a1.store();
                        FrameSet fs = new FrameSet();
                        FrameSet thisFrameSet = (FrameSet)this.history.getLastEntry(this.key);
                        fs.copyUnstoppedEvents(thisFrameSet);
                        fs.addToFrameSet(Long.toString(this.startTime), this.a);
                        this.history.add(this.key, Long.toString(this.startTime), fs);
                        this.printMsg("AccessTracking: same URL, other fragment");
                        this.startTime = linkTime;
                    }
                } else {
                    this.lastAction.set(1);
                    this.a.setLinkId(link.getLinkId());
                    this.a.store();
                }
            } else if (link.getFromNode() == link.getToNode()) {
                if (link.getFragment().equals(this.a.getFragment())) {
                    this.lastAction.set(5);
                } else {
                    this.a.setStayTime(linkTime - this.startTime);
                    this.a.setLinkId(link.getLinkId());
                    this.a.store();
                    Access a1 = AccessCache.get(this.a.getUserId(), this.a.getNodeId(), linkTime, this.a.getFrameName());
                    a1.setAction(3 | this.a.getAction() & 0x18000000);
                    a1.setFragment(link.getFragment());
                    a1.setQuery(this.a.getQuery());
                    a1.setParentFrameNodeId(this.a.getParentFrameNodeId());
                    a1.setParentFrameName(this.a.getParentFrameName());
                    a1.setReferrerNodeId(this.a.getNodeId());
                    a1.store();
                    this.a = a1;
                    a1 = null;
                    this.history.add(this.key, Long.toString(this.startTime), this.a);
                    this.printMsg("AccessTracking: same URL, other fragment");
                    this.startTime = linkTime;
                }
            } else {
                this.lastAction.set(1);
                this.a.setLinkId(link.getLinkId());
                this.a.store();
            }
            this.a.setLinkId(linkId);
        }
        if (this.lastAction != null) {
            this.printMsg("AccessTracking: Action: " + this.lastAction.get());
        }
    }

    public void formSubmited(long formTime, String formAction) {
        if (formAction.toLowerCase().startsWith("mailto:")) {
            if (this.a != null) {
                this.a.setStayTime(formTime - this.startTime);
                NetNode formNode = NetNodeCache.get(formAction);
                Link formLink = LinkCache.get(NetNodeCache.getById(this.a.getNodeId()), formNode, "");
                this.a.setLinkId(formLink.getLinkId());
                this.a.store();
            }
            this.printMsg("AccessTracking: Mail form submited");
        } else {
            this.lastAction.set(8);
            if (this.a != null) {
                this.a.setLinkId(new Link(NetNodeCache.getById(this.a.getNodeId()), NetNodeCache.get(formAction), "").getLinkId());
                this.a.store();
            }
            this.printMsg("AccessTracking: Form was submited");
        }
    }

    public void logMessage(String className, String method, String param) {
        try {
            Class<?> c = Class.forName(className);
            this.printMsg("AccessTracking.logMessage: Loaded class: " + c);
            Method m = c.getDeclaredMethod(method, class$java$lang$String == null ? (class$java$lang$String = IESpyEventDecoder.class$("java.lang.String")) : class$java$lang$String);
            this.printMsg("AccessTracking.logMessage: Got method: " + m);
            Object o = m.invoke(null, param);
            this.printMsg("AccessTracking.logMessage: Output: " + o);
        }
        catch (Exception e) {
            ErrorLog.log(this, "logMessage", "Error calling static function:\n" + className + "." + method + "(\"" + param + "\")", e);
        }
    }

    public void printMsg(String textMsg) {
        if (this.showMessages) {
            System.out.println(textMsg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

