/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking;

import com.ibm.wbi.Meg;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.ResponseToRequest;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpGenerator;
import com.ibm.wbi.protocol.http.HttpRequest;
import com.ibm.wbi.protocol.http.HttpResponse;
import com.ibm.wbi.protocol.http.beans.FileGenerator;
import com.ibm.wbi.protocol.http.beans.FormHelper;
import com.ibm.wbi.protocol.http.beans.StaticHtmlGenerator;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import scone.netobjects.Person;
import scone.netobjects.PersonCache;
import scone.netobjects.SimpleUri;
import scone.netobjects.User;
import scone.netobjects.UserCache;

public class UserHandlingMeg
extends HttpGenerator {
    private DocumentInfo documentInfo;
    private String file;
    private Properties formParameter;
    private HttpRequest request;
    private HttpResponse response;
    private String id;
    private long userId = 0L;

    public void handleRequest(RequestEvent e) throws RequestRejectedException {
        String user;
        StaticHtmlGenerator sg;
        this.documentInfo = (DocumentInfo)e.getRequestInfo();
        this.file = this.documentInfo.getPath();
        this.formParameter = FormHelper.interpretFormData((ResponseToRequest)e);
        this.request = new HttpRequest((ResponseToRequest)e, true);
        this.id = this.request.getCookie("ID");
        try {
            if (this.id != null) {
                this.userId = Long.parseLong(this.id);
            }
        }
        catch (NumberFormatException ex) {
            System.err.println("Error: Cookie ID is no number");
            this.userId = 0L;
            this.id = null;
        }
        StaticHtmlGenerator g = null;
        if (this.file.equals("/_register")) {
            sg = new StaticHtmlGenerator();
            if (this.request.getMethod().equals("POST")) {
                String email;
                String organization;
                String lastName;
                String secondName;
                String firstName;
                String password;
                String content = this.request.getContent();
                user = this.formParameter.getProperty("user");
                if (user == null) {
                    user = "";
                }
                if ((password = this.formParameter.getProperty("password")) == null) {
                    password = "";
                }
                if ((firstName = this.formParameter.getProperty("firstName")) == null) {
                    firstName = "";
                }
                if ((secondName = this.formParameter.getProperty("secondName")) == null) {
                    secondName = "";
                }
                if ((lastName = this.formParameter.getProperty("lastName")) == null) {
                    lastName = "";
                }
                if ((organization = this.formParameter.getProperty("organization")) == null) {
                    organization = "";
                }
                if ((email = this.formParameter.getProperty("email")) == null) {
                    email = "";
                }
                String referrer = this.formParameter.getProperty("referrer");
                if (user.length() > 0 && password.length() > 0) {
                    User u = UserCache.get(user);
                    this.id = u.getUserId();
                    System.out.println(this.id);
                    System.out.println(u.getUserName());
                    u.setUserPass(password);
                    String personId = SimpleUri.getHexHashCode(this.id + firstName + secondName + lastName + organization + email);
                    u.setPersonId(personId);
                    u.store();
                    Person p = PersonCache.getById(personId);
                    p.setFirstName(firstName);
                    p.setSecondName(secondName);
                    p.setLastName(lastName);
                    p.setOrganization(organization);
                    p.setEmail(email);
                    p.store();
                    String reply = "<body bgcolor='#ffffff'><H1>Welcome " + firstName + " " + lastName + "</H1>\n" + "You are registered as user <B>" + user + "</B> with userId: <B>" + this.id + "</B>" + "<P><I>Scone</I> is ready to support you now.<p>Please restart the Internet Explorer!<p>\n";
                    if (referrer != null) {
                        reply = reply + "continue: <a href='" + referrer + "'>" + referrer + "</a><p>";
                    }
                    sg.setStaticHtml(reply);
                } else {
                    sg.setStaticHtml("<body bgcolor='#ffffff'><H1>Please enter a user name and a password!</H1><A HREF=\"http://users.scone.de/registration.html\">Return to registration screen.</A>");
                }
            } else {
                sg.setStaticHtml("<body bgcolor='#ffffff'><H1>Error! Wrong FORM method! POST needed.</H1>");
            }
            g = sg;
        } else if (this.file.equals("/_login")) {
            sg = new StaticHtmlGenerator();
            if (this.request.getMethod().equals("POST")) {
                String password;
                String content = this.request.getContent();
                user = this.formParameter.getProperty("user");
                if (user == null) {
                    user = "";
                }
                if ((password = this.formParameter.getProperty("password")) == null) {
                    password = "";
                }
                if (user.length() > 0 && password.length() > 0) {
                    User u = UserCache.check(user, password);
                    if (u != null) {
                        this.id = u.getUserId();
                        Person p = PersonCache.getById(this.id);
                        sg.setStaticHtml("<body bgcolor='#ffffff'><H1>Welcome " + p.getFirstName() + " " + p.getLastName() + "</H1>\n" + "You are logged in as user <B>" + user + "</B> with userId: <B>" + this.id + "</B>" + ".");
                    } else {
                        sg.setStaticHtml("<body bgcolor='#ffffff'><H1>Login Failed</H1>\nUsername or password wrong. Please try again.<P><A HREF=\"http://users.scone.de/login.html\">Return to login screen.</A><BR>\n<A HREF=\"http://users.scone.de/registration.html\">Register new user.</A><BR>");
                    }
                } else {
                    sg.setStaticHtml("<body bgcolor='#ffffff'><H1>Login Failed</H1>Please enter user name <B>and</B> password to login!<P><A HREF=\"http://users.scone.de/login.html\">Return to login screen.</A><BR>\n<A HREF=\"http://users.scone.de/registration.html\">Register new user.</A><BR>");
                }
            } else {
                sg.setStaticHtml("<body bgcolor='#ffffff'><H1>Error! Wrong FORM method! POST needed.</H1>");
            }
            g = sg;
        } else if (this.file.equals("/_list")) {
            sg = new StaticHtmlGenerator();
            String htmlCode = "<HTML>\n<HEAD>\n<TITLE>Alle Scone users</TITLE>\n</HEAD>\n<BODY bgcolor='#ffffff'>\n";
            htmlCode = htmlCode + "<H1>All users registered by <I>Scone</I></H1>";
            htmlCode = htmlCode + "<TABLE bgcolor=\"#90D0D0\" CELLSPACING=2 CELLPADDING=5><TR><TH bgcolor=\"#F0FFFF\">User ID</TH><TH bgcolor=\"#F0FFFF\">User Name</TH><TH bgcolor=\"#F0FFFF\">Full Name</TH><TH bgcolor=\"#F0FFFF\">Organization</TH></TR>";
            System.out.println("1");
            Vector users = UserCache.getUsers("order by userName");
            System.out.println("2");
            for (int i = 0; i < users.size(); ++i) {
                User u = (User)users.get(i);
                Person p = PersonCache.getById(u.getPersonId());
                htmlCode = htmlCode + "<TR><TD bgcolor=\"#E0FFFF\">" + u.getUserId() + "</TD><TD bgcolor=\"#E0FFFF\">" + u.getUserName() + "</TD><TD bgcolor=\"#E0FFFF\"><A HREF=\"mailto:" + p.getEmail() + "\">" + p.getFirstName() + " " + p.getSecondName() + " " + p.getLastName() + "</A></TD><TD bgcolor=\"#E0FFFF\">" + p.getOrganization() + "</TD></TR>";
            }
            htmlCode = htmlCode + "</TABLE></BODY></HTML>";
            sg.setStaticHtml(htmlCode);
            g = sg;
        } else if (this.file.length() > 1) {
            String ext = this.file.substring(this.file.lastIndexOf(".") + 1);
            FileGenerator rg = new FileGenerator("resources/scone/proxy" + this.file, this.getContentType(ext));
            g = rg;
        } else {
            sg = new StaticHtmlGenerator();
            String htmlCode = "<HTML>\n<HEAD>\n<TITLE>Scone user handling</TITLE>\n</HEAD>\n<BODY bgcolor='#ffffff'>\n";
            htmlCode = htmlCode + "<img src=\"http://users.scone.de/scone.jpg\"><BR>\n";
            htmlCode = htmlCode + "<H2><I>Scone</I> user handling options:</H2>\n";
            htmlCode = htmlCode + "<UL>\n";
            htmlCode = htmlCode + "<LI><A HREF=\"http://users.scone.de/login.html\">Login user</A><BR>\n";
            htmlCode = htmlCode + "<LI><A HREF=\"http://users.scone.de/registration.html\">Register new user</A><BR>\n";
            htmlCode = htmlCode + "<LI><A HREF=\"http://users.scone.de/_list\">List all users</A><BR>\n";
            htmlCode = htmlCode + "</UL>\n</BODY></HTML>";
            sg.setStaticHtml(htmlCode);
            g = sg;
        }
        this.response = g.getHttpResponse();
        this.response.setCache(false);
        if (this.id != null) {
            long expiry = new Date().getTime() + 315360000000L;
            Date expiryDate = new Date(expiry);
            this.addCookie("ID", this.id, expiryDate, ".scone.de", "/", false);
            this.addCookie("ID", this.id, expiryDate, "scone.de", "/", false);
            this.addCookie("ID", this.id, expiryDate, "", "/", false);
        }
        try {
            this.forwardRequest((Meg)g, e);
        }
        catch (IOException ex) {
            System.out.println("Error sending response in UserHandlingMeg!");
        }
    }

    private String getContentType(String ext) {
        if ((ext = ext.toLowerCase()).equals("txt")) {
            return "text/txt";
        }
        if (ext.equals("css")) {
            return "text/css";
        }
        if (ext.equals("js")) {
            return "application/x-javascript";
        }
        if (ext.equals("gif")) {
            return "image/gif";
        }
        if (ext.equals("jpg")) {
            return "image/jpeg";
        }
        return "text/html";
    }

    public void addCookie(String s, String s1, Date date, String s2, String s3, boolean flag) {
        StringBuffer stringbuffer = new StringBuffer(URLEncoder.encode(s) + "=" + URLEncoder.encode(s1));
        if (s2 != null && s2.length() != 0) {
            stringbuffer.append("; domain=" + s2);
        }
        if (s3 != null && s3.length() != 0) {
            stringbuffer.append("; path=" + s3);
        }
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss", Locale.US);
            String dateString = formatter.format(date);
            stringbuffer.append("; expires=" + dateString + " GMT");
        }
        if (flag) {
            stringbuffer.append("; secure");
        }
        this.response.add("Set-Cookie", stringbuffer.toString());
    }
}

