/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking.applet;

import scone.accesstracking.applet.LogApplet;
import scone.ras.Connection;

public class ReceiverThread
extends Thread {
    private Connection con;
    private String inputLine;
    private LogApplet logApplet;

    ReceiverThread(Connection con, LogApplet logApplet) {
        this.con = con;
        this.logApplet = logApplet;
    }

    public void run() {
        try {
            while ((this.inputLine = this.con.read()) != null) {
                if (this.inputLine.startsWith("AccessEventExisted=")) {
                    this.logApplet.statusSaverReceived(this.inputLine);
                    continue;
                }
                if (this.inputLine.startsWith("command=openurldelayed")) {
                    this.logApplet.openURLDelayed(this.getParameter(this.inputLine, "parameter1"));
                    continue;
                }
                if (this.inputLine.startsWith("command=openurl")) {
                    this.logApplet.openURL(this.getParameter(this.inputLine, "parameter1"), this.getParameter(this.inputLine, "parameter2"));
                    continue;
                }
                if (this.inputLine.startsWith("command=bringtofront")) {
                    this.logApplet.bringToFront();
                    continue;
                }
                if (this.inputLine.startsWith("command=closebrowser")) {
                    this.logApplet.closeBrowser();
                    continue;
                }
                if (this.inputLine.startsWith("command=blurbrowser")) {
                    this.logApplet.blurBrowser();
                    continue;
                }
                if (!this.inputLine.startsWith("command=anyfunction")) continue;
                this.logApplet.anyFunction(this.getParameter(this.inputLine, "parameter1"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getParameter(String inputLine, String paramName) {
        if (inputLine.indexOf("\n" + paramName + "=") > -1) {
            int startPos = inputLine.indexOf("\n" + paramName + "=") + paramName.length() + 2;
            int endPos = inputLine.indexOf("\n", startPos);
            return inputLine.substring(startPos, endPos);
        }
        System.out.println("Required Parameter " + paramName + " not found in String " + inputLine);
        return "";
    }
}

