/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking2;

import scone.accesstracking2.AccessTracking;
import scone.accesstracking2.BrowserHistory;
import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;

public class EventDecoder {
    public static final int LINK = 1;
    public static final int FRAGMENT = 2;
    public static final int SELFLINK = 4;
    public static final int FORMSUBMIT = 8;
    public static final int RELOAD = 16;
    public static final int BACK = 32;
    public static final int NEXT = 64;
    public static final int SKIPPED = 128;
    public static final int NEWWINDOW = 256;
    public static final int BOOKMARK = 512;
    public static final int NEWFRAME = 16384;
    public static final int NEWURL = 32768;
    public static final int BROWSER_FIREFOX = 0x8000000;
    public static final int BROWSER_IE = 0x10000000;
    public static final int BROWSER_GECKO = 0x20000000;
    public static final int HEURISTIC = 0x40000000;
    public final int OTHER = 0;
    public final int EXPLORER = 1;
    public final int NETSCAPE = 2;
    public final int GECKO = 3;
    public final int FIREFOX = 4;
    protected final int MAXHISTORY = 50;
    protected BrowserHistory bh = BrowserHistory.getInstance();
    protected int browserName = 0;
    protected boolean accessEventExisted = false;
    protected boolean showMessages;

    void startEvent(String userId, String nodeId, long start, String frame, String fragment, String query, String post, String referrerNodeId, String parentFrame, String parentNodeId, String windowSize, String clickPos, int history) {
        Access a;
        String key;
        block46: {
            block45: {
                block48: {
                    block47: {
                        if (frame.equals("") || nodeId.equals("")) {
                            return;
                        }
                        key = this.bh.createKey(userId, parentFrame, frame);
                        a = AccessCache.get(userId, nodeId, start, frame);
                        a.setReferrerNodeId(referrerNodeId);
                        a.setParentFrameName(parentFrame);
                        a.setParentFrameNodeId(parentNodeId);
                        if (post != null && !post.equals("")) {
                            a.setAction(8 | a.getAction());
                            a.setPost(post);
                            this.bh.setLastAction(key, 0);
                        }
                        a.setQuery(query);
                        if (!this.bh.contains(key)) break block45;
                        int historyLength = this.bh.getHistoryLength(key);
                        int eventPosition = this.bh.getPosition(key, a);
                        int position = this.bh.getPosition(key);
                        if (history > historyLength + 1) {
                            System.out.println("Some Browser events were skipped!?!---------------");
                            for (int i = historyLength; i < history; ++i) {
                                this.bh.add(key, new Access(userId, "", 0L, ""));
                            }
                            a.setAction(0x40000080 | a.getAction());
                            a.setStepsInHistory(history - historyLength);
                        }
                        if (history >= 50 && history == historyLength) {
                            if (this.bh.getLastAction(key) == 8) {
                                this.bh.removeFirstEntries(key, historyLength - 50 + 1);
                            } else if (this.bh.getLastAction(key) == 1) {
                                this.bh.removeFirstEntries(key, historyLength - 50 + 1);
                            } else if (eventPosition == 0 || eventPosition <= position - 16) {
                                this.bh.removeFirstEntries(key, historyLength - 50 + 1);
                            }
                        }
                        historyLength = this.bh.getHistoryLength(key);
                        eventPosition = this.bh.getPosition(key, a);
                        position = this.bh.getPosition(key);
                        if (history == historyLength + 1) {
                            this.bh.add(key, a);
                            if (this.bh.getLastAction(key) == 8) {
                                a.setAction(8 | a.getAction());
                            } else if (this.bh.getLastAction(key) == 1) {
                                a.setAction(1 | a.getAction());
                                a.setLinkType(this.bh.getLastLinkType(key));
                            } else {
                                if (this.bh.getLastEvent(key).getNodeId() == referrerNodeId || !fragment.equals("")) {
                                    a.setAction(0x40000001 | a.getAction());
                                }
                                if (this.bh.getLastReferrer(key) == referrerNodeId && fragment.equals("")) {
                                    a.setAction(0x40008000 | a.getAction());
                                }
                            }
                        }
                        if (historyLength == history) {
                            if (eventPosition == 0) {
                                this.bh.removeLastEntries(key, 1);
                                this.bh.add(key, a);
                                if (this.bh.getLastAction(key) == 8) {
                                    a.setAction(8 | a.getAction());
                                } else if (this.bh.getLastAction(key) == 1) {
                                    a.setAction(1 | a.getAction());
                                    a.setLinkType(this.bh.getLastLinkType(key));
                                } else if (this.bh.getLastEvent(key).getNodeId() == referrerNodeId) {
                                    a.setAction(0x40000001 | a.getAction());
                                }
                            } else if (eventPosition == position) {
                                a.setAction(0x40000010 | a.getAction());
                                if (this.bh.getLastAction(key) == 8) {
                                    a.setAction(8 | a.getAction());
                                } else if (this.bh.getLastAction(key) == 1) {
                                    a.setAction(1 | a.getAction());
                                    a.setLinkType(this.bh.getLastLinkType(key));
                                }
                            } else if (eventPosition <= position && (eventPosition > position - 2 || eventPosition > position - 16 && history < 50)) {
                                a.setAction(0x20 | a.getAction());
                                if (this.bh.getLastReferrer(key) != referrerNodeId && this.bh.getEventAt(key, eventPosition).getReferrerNodeId() != referrerNodeId || !fragment.equals("")) {
                                    a.setAction(0x40000000 | a.getAction());
                                }
                                if (eventPosition != position - 1) {
                                    a.setAction(0x40000080 | a.getAction());
                                    a.setStepsInHistory(position - eventPosition);
                                }
                                this.bh.setPosition(key, eventPosition);
                            } else if (eventPosition > position) {
                                if (this.bh.getLastAction(key) == 8) {
                                    a.setAction(8 | a.getAction());
                                } else if (this.bh.getLastAction(key) == 1) {
                                    a.setAction(1 | a.getAction());
                                    a.setLinkType(this.bh.getLastLinkType(key));
                                } else {
                                    a.setAction(0x40000040 | a.getAction());
                                    this.bh.setPosition(key, eventPosition);
                                }
                            }
                        }
                        if (history >= historyLength) break block46;
                        this.bh.removeLastEntries(key, historyLength - history + 1);
                        this.bh.add(key, a);
                        if (this.bh.getLastAction(key) != 8) break block47;
                        a.setAction(8 | a.getAction());
                        break block46;
                    }
                    if (this.bh.getLastAction(key) != 1) break block48;
                    a.setAction(1 | a.getAction());
                    break block46;
                }
                if (this.bh.getLastEvent(key).getNodeId() != referrerNodeId) break block46;
                a.setAction(0x40000001 | a.getAction());
                break block46;
            }
            this.bh.add(key, a);
            if (parentFrame.equals("") && parentNodeId.equals("") && frame.startsWith("SCONE")) {
                a.setAction(0x100 | a.getAction());
                if (history > 1) {
                    System.out.println("---------------------------------------------------------------");
                    System.out.println("---- Browser history not empty! Please restart browser!!! -----");
                    System.out.println("---------------------------------------------------------------");
                }
            } else {
                a.setAction(0x4000 | a.getAction());
            }
            if (history > 1) {
                for (int i = 1; i < history; ++i) {
                    this.bh.add(key, new Access(userId, "", 0L, ""));
                }
            }
        }
        if (!fragment.equals("")) {
            a.setFragment(fragment);
            a.setAction(2 | a.getAction());
        }
        AccessCache.broadcastEvent(new AccessEvent(a));
        this.bh.setLastReferrer(key, referrerNodeId);
        this.bh.setLastAction(key, 0);
        this.bh.setLastLinkType(key, 0);
        this.bh.setLastLinkTitle(key, "");
        this.bh.setLastLinkAnchor(key, "");
        this.bh.setLastLinkPos(key, "");
        this.bh.setLastWindowSize(key, "");
    }

    void loadEvent(String userId, String nodeId, long start, String frame, String referrerNodeId, String parentFrame, String parentNodeId, long loadTime) {
        if (frame.equals("") || nodeId.equals("")) {
            return;
        }
        String key = this.bh.createKey(userId, parentFrame, frame);
        this.bh.setLastAction(key, 0);
        Access a = AccessCache.get(userId, nodeId, start, frame);
        if (a.getReferrerNodeId().equals("0")) {
            a.setReferrerNodeId(referrerNodeId);
        }
        if (a.getParentFrameName().equals("")) {
            a.setParentFrameName(parentFrame);
        }
        if (a.getParentFrameNodeId().equals("0")) {
            a.setParentFrameNodeId(parentNodeId);
        }
        a.setLoadTime(loadTime);
        a.store();
        this.printMsg("AccessTracking: Load time: " + loadTime);
        if (AccessTracking.props.get("Create extra event after page is loaded").equals("true")) {
            AccessCache.broadcastEvent(new AccessEvent(a));
        }
    }

    void stopEvent(String userId, String nodeId, long start, String frame, String referrerNodeId, String parentFrame, String parentNodeId, long stayTime, long loadTime, String linkId, int linkType, String windowSize, String clickPos, String formAction) {
        if (frame.equals("") || nodeId.equals("")) {
            return;
        }
        String key = this.bh.createKey(userId, parentFrame, frame);
        Access a = AccessCache.get(userId, nodeId, start, frame);
        a.setStayTime(stayTime);
        if (loadTime > 0L && a.getLoadTime() <= 0L) {
            a.setLoadTime(loadTime);
        }
        a.setLinkId(linkId);
        String linkAnchor = "";
        String linkTitle = "";
        Link link = LinkCache.getById(linkId);
        if (link != null) {
            linkAnchor = link.getLinkText();
            linkTitle = link.getTitle();
        }
        if (!linkId.equals("") && !linkId.equals("0")) {
            this.bh.setLastAction(key, 1);
            this.bh.setLastLinkType(key, linkType);
            this.bh.setLastWindowSize(key, windowSize);
            this.bh.setLastLinkPos(key, clickPos);
            this.bh.setLastLinkAnchor(key, linkAnchor);
            this.bh.setLastLinkTitle(key, linkTitle);
        }
        if (!formAction.equals("")) {
            this.bh.setLastAction(key, 8);
        }
        a.store();
        this.printMsg("AccessTracking: Stay time: " + stayTime);
        if (AccessTracking.props.get("Create extra events after user leaves a page").equals("true")) {
            AccessCache.broadcastEvent(new AccessEvent(a));
        }
    }

    void event(String userId, String nodeId, long start, String frame, String event, String uriString, int history) {
    }

    public void printMsg(String textMsg) {
        if (this.showMessages) {
            System.out.println(textMsg);
        }
    }
}

