/*
 * Decompiled with CFR 0.152.
 */
package scone.accesstracking2;

import com.ibm.wbi.Editor;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpRequestHeader;
import com.ibm.wbi.protocol.http.HttpResponseHeader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import scone.Plugin;
import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;

public class NoHTMLAccessMeg
extends Editor {
    private Plugin plugin = null;
    private DocumentInfo documentInfo;
    private HttpRequestHeader request;
    private HttpResponseHeader response;
    private String uriString;
    private String nodeId = "";
    private String frame = "";
    private String referrerUriString = "";
    private String referrerNodeId = "";
    private String id = "0";
    private String accessStatus = "";
    private String mimeType = "";
    private String size = "";
    private long start;
    private long lastModified;

    public NoHTMLAccessMeg(Plugin plugin) {
        this.plugin = plugin;
    }

    public void handleRequest(RequestEvent e) throws RequestRejectedException {
        this.documentInfo = (DocumentInfo)e.getRequestInfo();
        this.request = this.documentInfo.getHttpRequestHeader();
        this.response = this.documentInfo.getHttpResponseHeader();
        String string = this.mimeType = this.response.get("Content-Type") == null ? "" : this.response.get("Content-Type");
        if (!(!this.mimeType.equals("") && (this.mimeType.equals("application/excel") || this.mimeType.equals("application/msword") || this.mimeType.equals("application/rtf") || this.mimeType.equals("text/rtf") || this.mimeType.equals("application/pdf") || this.mimeType.equals("application/postscript") || this.mimeType.equals("application/powerpoint") || this.mimeType.equals("application/zip")))) {
            throw new RequestRejectedException();
        }
        this.referrerUriString = this.request.get("Referer");
        this.uriString = this.request.getUrl();
        this.accessStatus = this.response.getCode() == null ? "-1" : this.response.getCode();
        this.size = this.response.get("Content-Length") == null ? "-1" : this.response.get("Content-Length");
        try {
            this.lastModified = this.response.get("Last-Modified") == null ? -1L : this.parseDate(this.response.get("Last-Modified")).getTime();
        }
        catch (NumberFormatException ex) {
            this.lastModified = -1L;
        }
        this.start = new Date().getTime();
        NetNode node = NetNodeCache.get(this.uriString);
        this.nodeId = node.getNodeId();
        if (this.nodeId == null || this.nodeId.length() == 0) {
            this.nodeId = "0";
        }
        node.setMimeType(this.mimeType);
        node.setAccessStatus(this.accessStatus);
        node.setLastModified(this.lastModified);
        if (this.referrerUriString != null) {
            node = NetNodeCache.get(this.referrerUriString);
            this.referrerNodeId = node.getNodeId();
            if (this.referrerNodeId == null || this.referrerNodeId.length() == 0) {
                this.referrerNodeId = "0";
            }
        } else {
            this.referrerNodeId = "0";
        }
        Access a = AccessCache.get(this.id, this.nodeId, this.start, "No Frame");
        a.setReferrerNodeId(this.referrerNodeId);
        AccessCache.broadcastEvent(new AccessEvent(a));
        a.store();
        throw new RequestRejectedException();
    }

    private Date parseDate(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        ParsePosition pos = new ParsePosition(0);
        formatter.setTimeZone(TimeZone.getDefault());
        return formatter.parse(dateString, pos);
    }
}

