/*
 * Decompiled with CFR 0.152.
 */
package scone.examples.magnifier;

import scone.examples.magnifier.MagnifierPlugin;
import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;

public class Magnifier
extends HtmlTokenEditor {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Arne Z\u00fchlsdorf";
    private static final String styleH1 = "font-size: 380%;";
    private static final String styleH2 = "font-size: xx-large;";
    private static final String styleH3 = "font-size: x-large;";
    MagnifierPlugin plugin = null;

    public Magnifier(MagnifierPlugin plugin) {
        this.plugin = plugin;
    }

    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
            Token t = null;
            HtmlTagToken tag = null;
            boolean h1Magnified = false;
            boolean h2Magnified = false;
            boolean h3Magnified = false;
            int fontMagnified = 3;
            while ((t = in.read()) != null) {
                if (t instanceof HtmlTagToken) {
                    String style;
                    tag = (HtmlTagToken)t;
                    if (!h1Magnified) {
                        if (tag.getTagType() == 40) {
                            System.out.println("H1-Tag found.");
                            style = styleH1;
                            if (tag.hasParam("style")) {
                                style = style + tag.getParam("style");
                                tag.removeParam("style");
                            }
                            tag.setParam("style", style, "style");
                            h1Magnified = true;
                        }
                    }
                    if (!h2Magnified) {
                        if (tag.getTagType() == 41) {
                            System.out.println("H2-Tag found.");
                            style = styleH2;
                            if (tag.hasParam("style")) {
                                style = style + tag.getParam("style");
                                tag.removeParam("style");
                            }
                            tag.setParam("style", style, "style");
                            h2Magnified = true;
                        }
                    }
                    if (fontMagnified > 0) {
                        if (tag.getTagType() == 36) {
                            String size = "";
                            if (tag.hasParam("size")) {
                                size = tag.getParam("size");
                                tag.removeParam("size");
                                System.out.println("font-Tag found. size:" + size);
                                if (size.equals("+4")) {
                                    size = "+6";
                                    --fontMagnified;
                                }
                                if (size.equals("+3")) {
                                    size = "+5";
                                    --fontMagnified;
                                }
                                if (size.equals("+2")) {
                                    size = "+4";
                                    --fontMagnified;
                                }
                                if (size.equals("+1")) {
                                    size = "+3";
                                    --fontMagnified;
                                }
                                if (size.equals("6")) {
                                    size = "8";
                                    --fontMagnified;
                                }
                                if (size.equals("5")) {
                                    size = "7";
                                    --fontMagnified;
                                }
                                if (size.equals("4")) {
                                    size = "6";
                                    --fontMagnified;
                                }
                                tag.setParam("size", size, "size");
                            }
                        }
                    }
                }
                out.write(t);
            }
        }
        catch (Exception exc) {
            ErrorLog.log((Object)this, "handleRequest()", "", exc);
        }
    }
}

