/*
 * Decompiled with CFR 0.152.
 */
package scone.examples.observertest;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import scone.Plugin;
import scone.accesstracking2.AccessTracking;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.Inclusion;
import scone.netobjects.InclusionCache;
import scone.netobjects.LinkCache;
import scone.netobjects.LinkVector;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;

public class ObserverTestPlugin
extends Plugin
implements Observer {
    private static Hashtable statusTable = new Hashtable();

    public int getRequirements() {
        if (this.getProperties().get("Parse Links and Inclusions").equals("true")) {
            return 17956953;
        }
        if (this.getProperties().get("Use Accesstracking 2 without Applet").equals("true")) {
            return 0x2100201;
        }
        return 0x1120201;
    }

    public void init() {
        if (this.getProperties().get("Observe NetNodes").equals("true")) {
            NetNodeCache.putObserver(this);
        }
        if (this.getProperties().get("Observe HtmlNodes").equals("true")) {
            HtmlNodeCache.putObserver(this);
        }
        if (this.getProperties().get("Observe Page Accesses").equals("true")) {
            AccessCache.putObserver(this);
        }
        if (this.getProperties().get("Show Known Backlinks").equals("true")) {
            AccessCache.putObserver(this);
        }
        HtmlNodeCache.setObservePeriod(30000);
    }

    public void update(Observable o, Object arg) {
        if (o instanceof NetNodeCache) {
            Enumeration e = (Enumeration)arg;
            while (e.hasMoreElements()) {
                NetNode netNodeBuffer = (NetNode)e.nextElement();
                System.out.println("OT: New NetNode(" + netNodeBuffer.getNodeId() + "): " + netNodeBuffer.getUri());
            }
        } else if (o instanceof HtmlNodeCache) {
            Enumeration e = (Enumeration)arg;
            while (e.hasMoreElements()) {
                HtmlNode htmlNodeBuffer = (HtmlNode)e.nextElement();
                System.out.println("OT: New HtmlNode(" + htmlNodeBuffer.getNodeId() + "): " + htmlNodeBuffer.getUri());
            }
        } else if (o instanceof AccessCache) {
            AccessEvent e = (AccessEvent)arg;
            if (this.getProperties().get("Use Accesstracking 2 without Applet").equals("true") && (e.getAccess().getAction() & 0x8000000) > 0) {
                System.out.print("\nOT: User <");
                System.out.print(e.getAccess().getUserId());
                System.out.print(">");
                System.out.println(" [firefox event]");
                System.out.println("   Event: " + e.getAccess().getEvent());
                System.out.println("  nodeID: " + e.getAccess().getNodeId());
                if (e.getNode() != null) {
                    System.out.println("     URL: " + e.getNode().toString());
                    HtmlNode hNode = HtmlNodeCache.check(e.getNode());
                    if (hNode != null) {
                        System.out.println("          " + hNode.getTitle());
                    }
                }
                System.out.println("   Frame: " + e.getAccess().getFrameName());
                System.out.println("    Time: " + e.getAccess().getTime() + "ms");
            } else if (e.getNode() == null) {
                if (this.getProperties().get("Show verbose information").equals("true")) {
                    if (DBTableAdapter.useDb()) {
                        System.out.println("OT: Unknown NetNode! Please restart Scone and clear cache of browser!");
                    } else {
                        System.out.println("OT: Unknown NetNode! Database is deactivated, NetNode was already removed by GC.");
                    }
                    System.out.print("    " + e.getAccess().getNodeId() + ":  ");
                    System.out.println(NetNodeCache.getById(e.getAccess().getNodeId()));
                }
            } else {
                int i;
                HtmlNode hNode = HtmlNodeCache.check(e.getNode());
                if (!e.getAccess().getShown()) {
                    e.getAccess().setShown(true);
                    if (e.getUser() != null && !e.getUser().getUserId().equals("0") && !e.getUser().getUserName().equals("")) {
                        System.out.print("\nOT: " + e.getUser().getUserName());
                    } else {
                        System.out.print("\nOT: User <");
                        System.out.print(e.getAccess().getUserId());
                        System.out.print(">");
                    }
                    System.out.println(" accessed");
                    System.out.println(" " + e.getNode().toString());
                    if ((e.getAccess().getAction() & 2) > 0) {
                        System.out.println(" Fragment: " + e.getAccess().getFragment());
                    }
                    if (hNode != null) {
                        System.out.println(" " + hNode.getTitle());
                        if (!e.getAccess().getParentFrameName().equals("") || !e.getAccess().getParentFrameNodeId().equals("")) {
                            System.out.println(" Frame  : " + e.getAccess().getFrameName());
                            System.out.println(" Parent : " + e.getAccess().getParentFrameName());
                            NetNode parent = NetNodeCache.getById(e.getAccess().getParentFrameNodeId());
                            if (parent == null) {
                                System.out.println("      ID: " + e.getAccess().getParentFrameNodeId());
                            } else {
                                System.out.println("     URI: " + parent.toString());
                            }
                        } else {
                            System.out.println(" Window : " + e.getAccess().getFrameName());
                        }
                    } else {
                        System.out.println(" Type   : " + e.getNode().getMimeType());
                    }
                    if (!e.getNode().getAccessStatus().equals("200") && !e.getNode().getAccessStatus().equals("")) {
                        System.out.print("  Status: " + e.getNode().getAccessStatus() + " - ");
                        System.out.println(statusTable.get(e.getNode().getAccessStatus()));
                    }
                    if (this.getProperties().get("Show verbose information").equals("true") && !e.getAccess().getReferrerNodeId().equals("")) {
                        NetNode referrer = NetNodeCache.getById(e.getAccess().getReferrerNodeId());
                        if (referrer == null) {
                            System.out.println(" Referer: " + e.getAccess().getReferrerNodeId());
                        } else {
                            System.out.println(" Referer: " + referrer.toString());
                        }
                    }
                    System.out.print(" Action :");
                    if ((e.getAccess().getAction() & 1) > 0) {
                        System.out.print(" link");
                    }
                    if ((e.getAccess().getAction() & 2) > 0) {
                        System.out.print(" #fragment");
                    }
                    if ((e.getAccess().getAction() & 4) > 0) {
                        System.out.print(" samePage");
                    }
                    if ((e.getAccess().getAction() & 8) > 0) {
                        System.out.print(" submit");
                    }
                    if ((e.getAccess().getAction() & 0x10) > 0) {
                        System.out.print(" reloaded");
                    }
                    if ((e.getAccess().getAction() & 0x20) > 0) {
                        System.out.print(" back");
                    }
                    if ((e.getAccess().getAction() & 0x40) > 0) {
                        System.out.print(" next");
                    }
                    if ((e.getAccess().getAction() & 0x80) > 0) {
                        System.out.print(": " + e.getAccess().getStepsInHistory() + " steps");
                    }
                    if ((e.getAccess().getAction() & 0x100) > 0) {
                        System.out.print(" new window");
                    }
                    if ((e.getAccess().getAction() & 0x200) > 0) {
                        System.out.print(" bookmark");
                    }
                    if ((e.getAccess().getAction() & 0x400) > 0) {
                        System.out.print(" linkbutton");
                    }
                    if ((e.getAccess().getAction() & 0x800) > 0) {
                        System.out.print(" adressbar");
                    }
                    if ((e.getAccess().getAction() & 0x1000) > 0) {
                        System.out.print(" home");
                    }
                    if ((e.getAccess().getAction() & 0x2000) > 0) {
                        System.out.print(" history or favorites");
                    }
                    if ((e.getAccess().getAction() & 0x4000) > 0) {
                        System.out.print(" new frame");
                    }
                    if ((e.getAccess().getAction() & 0x8000) > 0) {
                        if (e.getAccess().getParentFrameName().equals("")) {
                            System.out.print(" typed URL or Bookmark");
                        } else {
                            System.out.print(" frame load");
                        }
                    }
                    if ((e.getAccess().getAction() & 0x400000) > 0) {
                        System.out.print(" by hotkey");
                    }
                    if ((e.getAccess().getAction() & 0x800000) > 0) {
                        System.out.print(" by html menu");
                    }
                    if ((e.getAccess().getAction() & 0x1000000) > 0) {
                        System.out.print(" by main menu");
                    }
                    if ((e.getAccess().getAction() & 0x2000000) > 0) {
                        System.out.print(" by toolbar button");
                    }
                    if ((e.getAccess().getAction() & 0x4000000) > 0) {
                        System.out.print(" by toolbar menu");
                    }
                    if ((e.getAccess().getAction() & 0x40000000) > 0) {
                        System.out.print(" (by heuristic)");
                    }
                    if ((e.getAccess().getAction() & 0x8000000) > 0) {
                        System.out.print(" [netscape 4]");
                    }
                    if ((e.getAccess().getAction() & 0x10000000) > 0) {
                        System.out.print(" [ms explorer]");
                    }
                    if ((e.getAccess().getAction() & 0x20000000) > 0) {
                        System.out.print(" [gecko]");
                    }
                    System.out.println("");
                    if (this.getProperties().get("Show verbose information").equals("true")) {
                        if (e.getAccess().getLinkType() != 0) {
                            System.out.print(" L-Type : ");
                            if ((e.getAccess().getLinkType() & 1) > 0) {
                                System.out.print("sameDocument ");
                            }
                            if ((e.getAccess().getLinkType() & 2) > 0) {
                                System.out.print("fragment ");
                            }
                            if ((e.getAccess().getLinkType() & 4) > 0) {
                                System.out.print("query ");
                            }
                            if ((e.getAccess().getLinkType() & 0x40) > 0) {
                                System.out.print("external ");
                            }
                            if ((e.getAccess().getLinkType() & 0x80) > 0) {
                                System.out.print("internal ");
                            }
                            if ((e.getAccess().getLinkType() & 0x400) > 0) {
                                System.out.print("fromHome ");
                            }
                            if ((e.getAccess().getLinkType() & 0x800) > 0) {
                                System.out.print("toHome ");
                            }
                            if ((e.getAccess().getLinkType() & 0x4000) > 0) {
                                System.out.print("down ");
                            }
                            if ((e.getAccess().getLinkType() & 0x8000) > 0) {
                                System.out.print("up ");
                            }
                            if ((e.getAccess().getLinkType() & 0x100000) > 0) {
                                System.out.print("sameCluster ");
                            }
                            if ((e.getAccess().getLinkType() & 0x200000) > 0) {
                                System.out.print("fromIndex ");
                            }
                            if ((e.getAccess().getLinkType() & 0x400000) > 0) {
                                System.out.print("toIndex ");
                            }
                            if ((e.getAccess().getLinkType() & 0x1000000) > 0) {
                                System.out.print("noHTTP ");
                            }
                            if ((e.getAccess().getLinkType() & 0x2000000) > 0) {
                                System.out.print("noHTML ");
                            }
                            System.out.println();
                        }
                        if (!e.getAccess().getLinkAnchor().equals("")) {
                            System.out.println(" L-Text : " + e.getAccess().getLinkAnchor());
                        }
                        if (!e.getAccess().getLinkTitle().equals("")) {
                            System.out.println(" L-Title: " + e.getAccess().getLinkTitle());
                        }
                        if (!e.getAccess().getLinkPos().equals("")) {
                            System.out.println(" L-Pos  : " + e.getAccess().getLinkPos() + " (" + e.getAccess().getLastWindowSize() + ")");
                        }
                        if ((e.getAccess().getAction() & 8) > 0) {
                            if (e.getAccess().getPost() != null && !e.getAccess().getPost().equals("")) {
                                System.out.println("    POST: " + e.getAccess().getPost());
                            }
                            if (e.getAccess().getQuery() != null && !e.getAccess().getQuery().equals("")) {
                                System.out.println("     GET: " + e.getAccess().getQuery());
                            }
                        }
                    }
                }
                if (this.getProperties().get("Show verbose information").equals("true")) {
                    if (e.getAccess().getLoadTime() != 0L && (e.getAccess().getStayTime() == 0L || AccessTracking.props.get("Create extra event after page is loaded").equals("false"))) {
                        System.out.println(" Load   : " + e.getAccess().getLoadTime() + "ms");
                        if (hNode != null) {
                            System.out.println(" F-Print: " + hNode.getFingerprint());
                        }
                    }
                    if (e.getAccess().getStayTime() != 0L) {
                        System.out.println(" Stay   : " + e.getAccess().getStayTime() + "ms");
                    }
                }
                if (this.getProperties().get("Show Known Backlinks").equals("true") && e.getAccess().getAction() != 0 && e.getAccess().getStayTime() != 0L) {
                    LinkVector lv = LinkCache.getLinksTo(e.getNode());
                    for (i = 0; i < lv.size(); ++i) {
                        HtmlNode fromNode = HtmlNodeCache.check(lv.linkAt(i).getFromNode());
                        if (fromNode == null) {
                            System.out.println(lv.linkAt(i).getFromNode().getUri());
                            continue;
                        }
                        System.out.println(fromNode.getTitle());
                    }
                }
                if (this.getProperties().get("Show Inclusions").equals("true") && e.getAccess().getAction() != 0 && e.getAccess().getStayTime() != 0L) {
                    InclusionCache.clean();
                    Vector v = InclusionCache.getIncludedObjects(e.getNode());
                    for (i = 0; i < v.size(); ++i) {
                        System.out.println(((Inclusion)v.elementAt(i)).getTag() + " - " + ((Inclusion)v.elementAt(i)).getChildNode().getUri());
                    }
                    System.out.println(v.size() + " inclusions found");
                }
            }
        }
    }

    static {
        statusTable.put(new String(""), new String(""));
        statusTable.put(new String("-1"), new String(""));
        statusTable.put(new String("100"), new String("Continue"));
        statusTable.put(new String("101"), new String("Switching Protocols"));
        statusTable.put(new String("200"), new String("OK"));
        statusTable.put(new String("201"), new String("Created"));
        statusTable.put(new String("202"), new String("Accepted"));
        statusTable.put(new String("203"), new String("Non-Authoritative Information"));
        statusTable.put(new String("204"), new String("No Content"));
        statusTable.put(new String("205"), new String("Reset Content"));
        statusTable.put(new String("206"), new String("Partial Content"));
        statusTable.put(new String("300"), new String("Multiple Choices"));
        statusTable.put(new String("301"), new String("Moved Permanently"));
        statusTable.put(new String("302"), new String("Moved Temporarily"));
        statusTable.put(new String("303"), new String("See Other"));
        statusTable.put(new String("304"), new String("Not Modified (Document unchanged since last request)"));
        statusTable.put(new String("305"), new String("Use Proxy"));
        statusTable.put(new String("400"), new String("Bad Request (Server name unknown)"));
        statusTable.put(new String("401"), new String("Unauthorized (Password required)"));
        statusTable.put(new String("402"), new String("Payment Required"));
        statusTable.put(new String("403"), new String("Forbidden (Access to document denied)"));
        statusTable.put(new String("404"), new String("Not Found (Document was deleted)"));
        statusTable.put(new String("405"), new String("Method Not Allowed"));
        statusTable.put(new String("406"), new String("None Acceptable"));
        statusTable.put(new String("407"), new String("Proxy Authentication Required"));
        statusTable.put(new String("408"), new String("Request Timeout (Server doesn't repond / server down)"));
        statusTable.put(new String("409"), new String("Conflict"));
        statusTable.put(new String("410"), new String("Gone"));
        statusTable.put(new String("411"), new String("Length Required"));
        statusTable.put(new String("412"), new String("Precondition Failed"));
        statusTable.put(new String("413"), new String("Request Entity Too Large"));
        statusTable.put(new String("414"), new String("Request URI Too Large"));
        statusTable.put(new String("415"), new String("Unsupported Media Type"));
        statusTable.put(new String("500"), new String("Internal Server Error"));
        statusTable.put(new String("501"), new String("Not Implemented"));
        statusTable.put(new String("502"), new String("Bad Gateway"));
        statusTable.put(new String("503"), new String("Service Unavailable"));
        statusTable.put(new String("504"), new String("Gateway Timeout"));
        statusTable.put(new String("505"), new String("HTTP Version Not Supported (Maybe try other browser)"));
    }
}

