/*
 * Decompiled with CFR 0.152.
 */
package scone.examples.rueckspiegel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import scone.examples.rueckspiegel.BrowserControl;
import scone.examples.rueckspiegel.TreeNode;
import scone.netobjects.HtmlNode;
import scone.thumbnailgenerator.ThumbnailGenerator;

class DrawingArea
extends JPanel
implements MouseListener {
    private Vector nodes;
    private int height;
    private int width;
    private static final int nodeWidth = 150;
    private static final int nodeHeight = 113;

    DrawingArea() {
        this.addMouseListener(this);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.nodes = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newNode(HtmlNode hn) {
        URL u = null;
        try {
            u = new URL(hn.getUri());
        }
        catch (Exception e) {
            // empty catch block
        }
        TreeNode node = new TreeNode();
        node.setHtmlNode(hn);
        Vector e = this.nodes;
        synchronized (e) {
            this.nodes.add(node);
        }
        ThumbnailGenerator tg = new ThumbnailGenerator();
        tg.generateThumbnail(u);
        node.setThumbnail(tg.getThumbnail());
        tg.flush();
        this.setCoordinates();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCoordinates() {
        Vector vector = this.nodes;
        synchronized (vector) {
            Enumeration en = this.nodes.elements();
            double x = 10.0;
            double y = 10.0;
            while (en.hasMoreElements()) {
                TreeNode n = (TreeNode)en.nextElement();
                n.setRect(new Rectangle2D.Double(x, y, 150.0, 113.0));
                y = y + 113.0 + 25.0;
            }
            int ydim = (double)this.getParent().getHeight() > y ? this.getParent().getHeight() : (int)y;
            this.setPreferredSize(new Dimension(this.getParent().getWidth(), ydim));
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.clearRect(0, 0, (int)this.getSize().getWidth(), (int)this.getSize().getHeight());
        g2.setStroke(new BasicStroke(1.0f));
        Font f = new Font("Arial", 0, 10);
        g2.setFont(f);
        Enumeration en = this.nodes.elements();
        Vector vector = this.nodes;
        synchronized (vector) {
            while (en.hasMoreElements()) {
                TreeNode n = (TreeNode)en.nextElement();
                if (n.getThumbnail() != null && n.getRect() != null) {
                    g2.drawImage(n.getThumbnail(), (int)n.getRect().getX() + 2, (int)n.getRect().getY() + 2, Color.white, this);
                }
                g2.setPaint(Color.lightGray);
                if (n.getRect() == null) continue;
                g2.draw(n.getRect());
                g2.setPaint(Color.black);
                g2.drawString(n.getHtmlNode().getTitle(), (float)n.getRect().getX(), (float)(n.getRect().getY() + n.getRect().getHeight() + 12.0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clean() {
        Vector vector = this.nodes;
        synchronized (vector) {
            this.nodes.removeAllElements();
        }
        this.setPreferredSize(new Dimension(this.getParent().getWidth(), this.getParent().getWidth()));
        this.revalidate();
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        Vector vector = this.nodes;
        synchronized (vector) {
            if (this.nodes != null) {
                Enumeration en = this.nodes.elements();
                while (en.hasMoreElements()) {
                    TreeNode n = (TreeNode)en.nextElement();
                    if (n.getRect() == null || !n.getRect().contains(e.getPoint())) continue;
                    BrowserControl.displayURL(n.getHtmlNode().getUri());
                    break;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

