/*
 * Decompiled with CFR 0.152.
 */
package scone.examples.rueckspiegel;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import scone.Plugin;
import scone.Scone;
import scone.examples.rueckspiegel.DrawingArea;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.SimpleUri;
import scone.robot.LinkClassifier;
import scone.robot.LinkFilter;
import scone.robot.NoHtmlNodeException;
import scone.robot.PageClassifier;
import scone.robot.QueueEntry;
import scone.robot.Robot;
import scone.robot.RobotHtmlNode;
import scone.robot.RobotLink;
import scone.robot.RobotTask;
import scone.robot.RobotUser;

public class RueckspiegelPlugin
extends Plugin
implements Observer,
RobotUser {
    private Robot robot;
    private JFrame f;
    private JScrollPane scroller;
    private DrawingArea drawingArea;
    private RobotTask rt = null;
    private String currentUri = null;
    private String host = null;
    private int thumbnails = 0;
    private static final int MAX_THUMBNAILS = 5;

    public int getRequirements() {
        return 17956889;
    }

    public void init() {
        this.robot = Robot.instance();
        AccessCache.putObserver(this);
        this.f = new JFrame();
        this.f.setSize(230, Toolkit.getDefaultToolkit().getScreenSize().height - 40);
        this.f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RueckspiegelPlugin.this.f.setVisible(false);
                Scone.shutdownWBI(10000);
            }
        });
        this.f.setBackground(Color.white);
        this.drawingArea = new DrawingArea();
        JScrollPane scroller = new JScrollPane(this.drawingArea);
        scroller.setBackground(Color.white);
        scroller.setOpaque(true);
        this.f.getContentPane().add(scroller);
        this.f.setTitle("Rueckspiegel 1.2");
        this.f.show();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof AccessCache) {
            AccessEvent e = (AccessEvent)arg;
            HtmlNode hNode = HtmlNodeCache.check(e.getNode());
            if (hNode == null) {
                System.out.println("Rueckspiegel -> hm, that wasn't a html page");
            } else if (!e.getAccess().getShown()) {
                e.getAccess().setShown(true);
                System.out.println("\nRueckspiegel ---> " + e.getUser().getUserName() + ": " + e.getNode().toString());
                this.currentUri = e.getNode().toString();
                try {
                    this.drawingArea.clean();
                    if (this.rt != null) {
                        this.robot.stopRobotTask(this.rt);
                    }
                    this.host = hNode.getSUri().getHost();
                    String googleSuche = "http://www.google.de/search?q=link:" + hNode.getSUri().toString() + "&hl=de&ie=ISO-8859-1&safe=off&btnG=Google-Suche&num=20";
                    SimpleUri uri = new SimpleUri(googleSuche);
                    this.thumbnails = 0;
                    this.rt = new RobotTask(uri, 1, 4, this);
                    this.rt.addPageClassifier(new RueckspiegelPageClassifier());
                    this.rt.addLinkClassifier(new RueckspiegelLinkClassifier());
                    this.rt.addLinkFilter(new RueckspiegelLinkFilter(this.host));
                    this.robot.scan(this.rt);
                }
                catch (Exception ex) {
                    System.out.println("Rueckspiegel -> Invalid URL");
                }
            }
        }
    }

    public void robotNewPage(RobotHtmlNode robotHtmlNode, RobotTask robotTask) {
        if (robotTask == this.rt && robotHtmlNode.getAttribute("GoogleResult") == "No") {
            if (this.thumbnails <= 5) {
                ++this.thumbnails;
            } else {
                this.robot.stopRobotTask(this.rt);
                System.out.println("Rueckspiegel -> Enough thumbnails...");
            }
            try {
                this.drawingArea.newNode(robotHtmlNode.getHtmlNode());
            }
            catch (NoHtmlNodeException noHtmlNodeException) {
                // empty catch block
            }
        }
    }

    public void robotTaskFinished(RobotTask robotTask) {
        System.out.println("\nRueckspiegel -> Incoming Links for " + this.currentUri);
        Enumeration downloadedNodes = robotTask.getResultNodes();
        while (downloadedNodes.hasMoreElements()) {
            RobotHtmlNode robotHtmlNode = (RobotHtmlNode)downloadedNodes.nextElement();
            if (robotHtmlNode.getAttribute("GoogleResult") == "No") {
                System.out.println("Found:" + robotHtmlNode.getSimpleUri().toString());
                continue;
            }
            System.out.println("Skipped:" + robotHtmlNode.getSimpleUri().toString());
        }
        System.out.println("");
    }

    private class RueckspiegelPageClassifier
    implements PageClassifier {
        private RueckspiegelPageClassifier() {
        }

        public void classify(RobotHtmlNode robotHtmlNode, QueueEntry qe) {
            String urlText = robotHtmlNode.getNetNode().getUri();
            if (urlText.indexOf("google") != -1) {
                robotHtmlNode.setAttribute("GoogleResult", "Yes");
            } else {
                robotHtmlNode.setAttribute("GoogleResult", "No");
            }
        }
    }

    private class RueckspiegelLinkFilter
    implements LinkFilter {
        private String host;

        public RueckspiegelLinkFilter(String host) {
            this.host = host;
        }

        public boolean filter(RobotLink robotLink, RobotHtmlNode robotHtmlNode, QueueEntry qe) {
            if (robotLink.getAttribute("GoogleLink") == "Yes") {
                return false;
            }
            return !robotLink.getLink().getToNode().getHost().equals(this.host);
        }
    }

    private class RueckspiegelLinkClassifier
    implements LinkClassifier {
        private RueckspiegelLinkClassifier() {
        }

        public void classify(RobotLink robotLink, RobotHtmlNode robotHtmlNode, QueueEntry qe) {
            String urlText = robotLink.getLink().getToNode().getUri();
            if (urlText.indexOf("google") != -1 || urlText.indexOf("http://72") != -1 || urlText.indexOf("http://66") != -1 || urlText.indexOf("http://64") != -1 || urlText.indexOf("http://209") != -1) {
                robotLink.setAttribute("GoogleLink", "Yes");
            }
        }
    }
}

