/*
 * Decompiled with CFR 0.152.
 */
package scone.examples.servlink;

import com.ibm.wbi.Meg;
import java.util.Hashtable;
import scone.Plugin;
import scone.proxy.AddPreambleEditor;
import scone.proxy.GeneralResourceGenerator;
import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.HtmlTextToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;

public class BuildPopupClientside
extends Plugin {
    public static final String COPYRIGHT = "(C) Volkert Buchmann";

    public int getRequirements() {
        return 0x130001;
    }

    public void init() {
        try {
            GeneralResourceGenerator.addPath("http://_servlink.scone.de/res", "resources/servlink");
            AddPreambleEditor.addPreambleString("<LINK rel=stylesheet type='text/css' href='http://_servlink.scone.de/res/style.css'>\n");
            AddPreambleEditor.addPreambleString("<SCRIPT Language='JavaScript1.2' SRC='http://_servlink.scone.de/res/script.js'></SCRIPT>\n");
            Builder b = new Builder();
            b.setup("Builder", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 50);
            this.addMeg((Meg)b);
        }
        catch (Exception e) {
            ErrorLog.log(this, "init()", "Could not init BuildPopupClientside plugin!", e);
        }
    }

    class Builder
    extends HtmlTokenEditor {
        Builder() {
        }

        public Hashtable readLinkElement(String name, TokenInputStream in) throws Exception {
            Hashtable<String, Object> element = new Hashtable<String, Object>();
            Token t = null;
            Object tag = null;
            boolean inElement = false;
            boolean inTitle = false;
            String title = "";
            while ((t = in.read()) != null) {
                if (t instanceof HtmlTagToken) {
                    if (((HtmlTagToken)t).getTagString().equals("multilink") && ((HtmlTagToken)t).isEndTag()) {
                        return null;
                    }
                    if (!inElement && ((HtmlTagToken)t).getTagString().equals(name)) {
                        element.put("tag", t);
                        inElement = true;
                        continue;
                    }
                    if (inElement) {
                        if (((HtmlTagToken)t).getTagString().equals("title")) {
                            inTitle = true;
                            continue;
                        }
                        if (((HtmlTagToken)t).getTagString().equals("title") && ((HtmlTagToken)t).isEndTag()) {
                            inTitle = false;
                            continue;
                        }
                        if (((HtmlTagToken)t).getTagString().equals(name) && ((HtmlTagToken)t).isEndTag()) {
                            element.put("title", this.safeString(title));
                            return element;
                        }
                    }
                }
                if (!inTitle) continue;
                title = title + t.toString();
            }
            element.put("title", this.safeString(title));
            return element;
        }

        public String safeString(String in) {
            return in.replace('\'', '\u00b4').replace('\n', ' ');
        }

        public void handleRequest(SconePipe pipe) {
            try {
                TokenInputStream in = pipe.getTokenInputStream();
                TokenOutputStream out = pipe.getTokenOutputStream();
                Object lt = null;
                HtmlTagToken tag = null;
                Token t = null;
                boolean inLink = false;
                String linkText = "";
                int linkCount = 0;
                while ((t = in.read()) != null) {
                    if (t instanceof HtmlTagToken && ((HtmlTagToken)t).getTagString().equals("multilink")) {
                        Hashtable element = this.readLinkElement("original", in);
                        if (element == null) continue;
                        ++linkCount;
                        int i = 0;
                        out.write(new HtmlTextToken(((HtmlTagToken)t).getWhiteSpaces()));
                        tag = new HtmlTagToken("script");
                        tag.setParam("language", "JScript");
                        tag.setParam("type", "text/jscript");
                        out.write(tag);
                        tag = (HtmlTagToken)element.get("tag");
                        out.write(new HtmlTextToken("beginpopup('popup" + linkCount + "', '" + ((String)element.get("title")).replace('\r', ' ') + "', '" + tag.getParam("xlink:href") + "');"));
                        while ((element = this.readLinkElement("alternative", in)) != null) {
                            ++i;
                            tag = (HtmlTagToken)element.get("tag");
                            if (tag == null) continue;
                            out.write(new HtmlTextToken("choice('test" + linkCount + "_" + i + "','related', '" + element.get("title") + "', '" + tag.getParam("xlink:href") + "');"));
                        }
                        out.write(new HtmlTextToken("endpopup();"));
                        out.write(new HtmlTagToken("/script"));
                        continue;
                    }
                    out.write(t);
                }
            }
            catch (Exception exc) {
                ErrorLog.log((Object)this, "BuildPopupClientside: handleRequest()", "", exc);
            }
        }
    }
}

