/*
 * Decompiled with CFR 0.152.
 */
package scone.examples.servlink;

import com.ibm.wbi.Meg;
import java.util.Enumeration;
import java.util.Vector;
import scone.Plugin;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;
import scone.netobjects.LinkToken;
import scone.netobjects.NetNode;
import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.Google;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.HtmlTextToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;

public class MultilinkExpander
extends Plugin {
    public static final String COPYRIGHT = "(C) Volkert Buchmann";
    String googleKey = null;
    public static final int MAXLINKS = 4;

    public int getRequirements() {
        return 0x100009;
    }

    public void init() {
        try {
            this.googleKey = this.getProperties().get("Google key");
            System.out.println("\n   Google key found:" + this.googleKey);
            Expander x = new Expander();
            x.setup("Expander", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 60);
            this.addMeg((Meg)x);
        }
        catch (Exception e) {
            ErrorLog.log(this, "init()", "Could not init MultilinkExpander plugin!", e);
            System.out.println("Could not init MultilinkExpander plugin! Please check if valid Google key exists in config-file");
        }
    }

    public void terminate() {
        ErrorLog.print(":-) it worked!");
    }

    class Expander
    extends HtmlTokenEditor {
        Expander() {
        }

        public void handleRequest(SconePipe pipe) {
            try {
                TokenInputStream in = pipe.getTokenInputStream();
                TokenOutputStream out = pipe.getTokenOutputStream();
                LinkToken lt = null;
                HtmlTagToken tag = null;
                Token t = null;
                boolean inLink = false;
                String linkText = "";
                while ((t = in.read()) != null) {
                    if (t instanceof LinkToken) {
                        lt = (LinkToken)t;
                        if (!(lt.getTagType() != 1 || lt.getParam("href") == null || lt.getParam("href").startsWith("mailto:") || lt.getParam("href").startsWith("ftp:") || lt.getParam("href").startsWith("#"))) {
                            inLink = true;
                            linkText = "";
                            continue;
                        }
                    }
                    if (inLink) {
                        if (t instanceof HtmlTagToken) {
                            tag = (HtmlTagToken)t;
                            if (tag.getTagType() == 1) {
                                out.write(new HtmlTextToken("&nbsp;"));
                                out.write(new HtmlTagToken("multilink"));
                                out.write(new HtmlTagToken("starting_resource"));
                                out.write(new HtmlTextToken(linkText));
                                out.write(new HtmlTagToken("/starting_resource"));
                                tag = new HtmlTagToken("original");
                                tag.setParam("xlink:href", lt.getParam("href"));
                                out.write(tag);
                                out.write(new HtmlTagToken("title"));
                                out.write(new HtmlTextToken(linkText));
                                out.write(new HtmlTagToken("/title"));
                                out.write(new HtmlTagToken("/original"));
                                this.addRelated(lt.getLink().getToNode(), out);
                                out.write(new HtmlTagToken("/multilink"));
                                out.write(new HtmlTextToken("&nbsp;"));
                                inLink = false;
                                continue;
                            }
                        }
                        linkText = linkText + t.toString();
                        continue;
                    }
                    out.write(t);
                }
            }
            catch (Exception exc) {
                ErrorLog.log((Object)this, "handleRequest()", "", exc);
            }
        }

        public void addRelated(NetNode node, TokenOutputStream out) {
            Link link = null;
            HtmlNode hNode = null;
            NetNode n = null;
            Enumeration en = null;
            Vector nodes = null;
            try {
                Vector links = LinkCache.getLinks("where fromNodeId='" + node.getNodeId() + "' and rel='related'");
                if (links.size() == 0) {
                    System.out.println("addRelated: request ->" + node.getUri());
                    Google google = new Google(MultilinkExpander.this.googleKey);
                    nodes = google.getRelated(node.getUri(), 4);
                    en = nodes.elements();
                    while (en.hasMoreElements()) {
                        hNode = (HtmlNode)en.nextElement();
                        link = LinkCache.get(node, hNode.getNode(), "");
                        link.setRel("related");
                    }
                } else {
                    nodes = new Vector();
                    en = links.elements();
                    while (en.hasMoreElements()) {
                        link = (Link)en.nextElement();
                        if (link == null || (n = link.getToNode()) == null || HtmlNodeCache.check(n) == null) continue;
                        nodes.addElement(HtmlNodeCache.check(n));
                    }
                }
                HtmlTagToken tag = null;
                en = nodes.elements();
                while (en.hasMoreElements()) {
                    hNode = (HtmlNode)en.nextElement();
                    if (node.getUri().equals(hNode.getUri())) continue;
                    tag = new HtmlTagToken("alternative");
                    tag.setParam("xlink:href", hNode.getUri());
                    out.write(tag);
                    out.write(new HtmlTagToken("title"));
                    out.write(new HtmlTextToken(hNode.getTitle()));
                    out.write(new HtmlTagToken("/title"));
                    out.write(new HtmlTagToken("/alternative"));
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }
}

