/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.sql.ResultSet;
import scone.netobjects.AccessCache;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.SimpleUri;
import scone.netobjects.TableRecord;
import scone.netobjects.User;
import scone.netobjects.UserCache;

public class Access
extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich, Volkert Buchmann & Torsten Hass";
    private int megStartTime;
    private NetNode nodekeeper;
    private HtmlNode htmlnodekeeper;
    private boolean shown = false;
    protected static DBTableAdapter dbTable = new DBTableAdapter("AccessTable");

    public Access(String userId, String nodeId, long time, String frameName) {
        dbTable.init(this);
        this.fieldValues.put("userId", userId);
        this.fieldValues.put("nodeId", nodeId);
        this.fieldValues.put("time", String.valueOf(time));
        this.fieldValues.put("frameName", frameName);
        this.fieldValues.put("accessId", SimpleUri.getHexHashCode(userId + "/" + nodeId + "/" + time + "+" + frameName));
        this.nodekeeper = NetNodeCache.getById(nodeId);
        this.htmlnodekeeper = HtmlNodeCache.get(this.nodekeeper);
        dbTable.dbInit(this);
    }

    public Access(String userId, String nodeId, long time, String frameName, String fragment, String query, int parentFrameNodeId, String parentFrameName, int referrerNodeId) {
        this(userId, nodeId, time, frameName);
        this.fieldValues.put("fragment", fragment);
        this.fieldValues.put("query", query);
        this.fieldValues.put("parentFrameNodeId", String.valueOf(parentFrameNodeId));
        this.fieldValues.put("parentFrameName", parentFrameName);
        this.fieldValues.put("referrerNodeId", String.valueOf(referrerNodeId));
        this.fieldValues.put("accessId", SimpleUri.getHexHashCode(userId + "/" + nodeId + "/" + time + "+" + frameName));
    }

    public Access(String userId, String nodeId, long time, String fragment, String query, int referrerNodeId, long stay) {
        this(userId, nodeId, time, "ServerLog");
        this.fieldValues.put("fragment", fragment);
        this.fieldValues.put("query", query);
        this.fieldValues.put("referrerNodeId", String.valueOf(referrerNodeId));
        this.fieldValues.put("stay", String.valueOf(stay));
        this.store();
    }

    public Access(ResultSet results) {
        dbTable.init(this);
        dbTable.fill(this, results);
    }

    public void setUserId(String userId) {
        this.fieldValues.put("userId", userId);
    }

    public void setNodeId(String nodeId) {
        this.fieldValues.put("nodeId", nodeId);
    }

    public void setTime(long time) {
        this.fieldValues.put("time", String.valueOf(time));
    }

    public void setFrameName(String frameName) {
        this.fieldValues.put("frameName", frameName);
    }

    public void setParentAccessId(String parentAccessId) {
        this.fieldValues.put("parentAccessId", parentAccessId);
    }

    public void setAction(int action) {
        this.fieldValues.put("action", String.valueOf(action));
    }

    public void setEvent(String event) {
        this.fieldValues.put("event", event);
    }

    public void setLinkPos(String pos) {
        this.fieldValues.put("linkPos", pos);
    }

    public void setLinkAnchor(String l) {
        this.fieldValues.put("linkAnchor", l);
    }

    public void setLinkTitle(String t) {
        this.fieldValues.put("linkTitle", t);
    }

    public void setLastWindowSize(String w) {
        this.fieldValues.put("windowSize", w);
    }

    public void setStepsInHistory(int stepsInHistory) {
        this.fieldValues.put("stepsInHistory", String.valueOf(stepsInHistory));
    }

    public void setFragment(String fragment) {
        this.fieldValues.put("fragment", fragment);
    }

    public void setQuery(String query) {
        this.fieldValues.put("query", query);
    }

    public void setPost(String post) {
        this.fieldValues.put("post", post);
    }

    public void setParentFrameNodeId(String parentFrameNodeId) {
        this.fieldValues.put("parentFrameNodeId", parentFrameNodeId);
    }

    public void setParentFrameName(String parentFrameName) {
        this.fieldValues.put("parentFrameName", parentFrameName);
    }

    public void setReferrerNodeId(String referrerNodeId) {
        this.fieldValues.put("referrerNodeId", referrerNodeId);
    }

    public void setLinkId(String linkId) {
        this.fieldValues.put("linkId", linkId);
    }

    public void setLinkType(int linkType) {
        this.fieldValues.put("linkType", String.valueOf(linkType));
    }

    public void setLoadTime(long loadTime) {
        this.fieldValues.put("loadTime", String.valueOf(loadTime));
    }

    public void setStayTime(long stayTime) {
        this.fieldValues.put("stayTime", String.valueOf(stayTime));
    }

    public String getUserId() {
        return this.fieldValues.get("userId");
    }

    public String getNodeId() {
        return this.fieldValues.get("nodeId");
    }

    public long getTime() {
        return Long.parseLong(this.fieldValues.get("time"));
    }

    public String getFrameName() {
        return this.fieldValues.get("frameName");
    }

    public String getAccessId() {
        return this.fieldValues.get("accessId");
    }

    public String getParentAccessId() {
        return this.fieldValues.get("parentAccessId");
    }

    public int getAction() {
        return Integer.parseInt(this.fieldValues.get("action"));
    }

    public String getEvent() {
        return this.fieldValues.get("event");
    }

    public String getLinkPos() {
        return this.fieldValues.get("linkPos");
    }

    public String getLinkAnchor() {
        return this.fieldValues.get("linkAnchor");
    }

    public String getLinkTitle() {
        return this.fieldValues.get("linkTitle");
    }

    public String getLastWindowSize() {
        return this.fieldValues.get("windowSize");
    }

    public int getStepsInHistory() {
        return Integer.parseInt(this.fieldValues.get("stepsInHistory"));
    }

    public String getFragment() {
        return this.fieldValues.get("fragment");
    }

    public String getQuery() {
        return this.fieldValues.get("query");
    }

    public String getPost() {
        return this.fieldValues.get("post");
    }

    public String getParentFrameNodeId() {
        return this.fieldValues.get("parentFrameNodeId");
    }

    public String getParentFrameName() {
        return this.fieldValues.get("parentFrameName");
    }

    public String getReferrerNodeId() {
        return this.fieldValues.get("referrerNodeId");
    }

    public String getLinkId() {
        return this.fieldValues.get("linkId");
    }

    public int getLinkType() {
        return Integer.parseInt(this.fieldValues.get("linkType"));
    }

    public long getLoadTime() {
        return Long.parseLong(this.fieldValues.get("loadTime"));
    }

    public long getStayTime() {
        return Long.parseLong(this.fieldValues.get("stayTime"));
    }

    public NetNode getNode() {
        return NetNodeCache.getById(this.fieldValues.get("nodeId"));
    }

    public NetNode getParentFrameNode() {
        return NetNodeCache.getById(this.fieldValues.get("parentFrameNodeId"));
    }

    public NetNode getReferrerNode() {
        return NetNodeCache.getById(this.fieldValues.get("referrerNodeId"));
    }

    public User getUser() {
        return UserCache.getById(this.fieldValues.get("userId"));
    }

    public void store() {
        dbTable.updateDB(this);
    }

    public Object getKey(int keyNo) {
        String userId = this.fieldValues.get("userId");
        String nodeId = this.fieldValues.get("nodeId");
        String time = this.fieldValues.get("time");
        String frameName = this.fieldValues.get("frameName");
        return AccessCache.createKey(userId, nodeId, time, frameName);
    }

    public boolean getShown() {
        return this.shown;
    }

    public void setShown(boolean _shown) {
        this.shown = _shown;
    }
}

