/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import scone.netobjects.Access;
import scone.netobjects.AccessEvent;
import scone.netobjects.CacheTable;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.TableRecordCacheInterface;
import scone.util.ErrorLog;

public class AccessCache
extends Observable
implements TableRecordCacheInterface {
    protected static CacheTable cache;
    public static Object lock;
    protected static AccessCache observable;

    public static void init(int timeTillCleanUp, int gcType) {
        cache = new CacheTable("Access Objects", 1, timeTillCleanUp, gcType);
        lock = new Object();
        observable = new AccessCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Access get(String userId, String nodeId, long time, String frameName) {
        String userIdString = userId;
        String nodeIdString = nodeId;
        String timeString = String.valueOf(time);
        Access a = null;
        String key = AccessCache.createKey(userIdString, nodeIdString, timeString, frameName);
        Object object = lock;
        synchronized (object) {
            a = (Access)cache.get(0, key);
            if (a == null) {
                a = new Access(userId, nodeId, time, frameName);
                cache.put(a);
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAccesses(String sqlClause) {
        Connection con = Access.dbTable.getConnection();
        Vector<Access> accesses = new Vector<Access>();
        boolean i = false;
        Object object = lock;
        synchronized (object) {
            ResultSet results = DBTableAdapter.queryDb(con, Access.dbTable.getTableName(), sqlClause);
            while (results != null) {
                Access a = new Access(results);
                String id = a.getAccessId();
                if (id.length() > 0 && !id.equals("-1")) {
                    if (cache.get(0, id) == null) {
                        cache.put(a);
                    }
                    accesses.add(a);
                    continue;
                }
                return accesses;
            }
        }
        return accesses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAccessCount(String tables, String sqlClause) {
        int count;
        Connection con = Access.dbTable.getConnection();
        Object object = lock;
        synchronized (object) {
            count = DBTableAdapter.rowCountDb(con, tables, sqlClause);
        }
        return count;
    }

    public static int getAccessCount(String sqlClause) {
        return AccessCache.getAccessCount(Access.dbTable.getTableName(), sqlClause);
    }

    public static String createKey(String userId, String nodeId, String timeString, String frameName) {
        return userId + "/" + nodeId + "/" + timeString + "+" + frameName;
    }

    public static void clean() {
        cache.clean();
    }

    public static void putObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void removeObserver(Observer o) {
        observable.deleteObserver(o);
    }

    public static void broadcastEvent(AccessEvent event) {
        try {
            observable.setChanged();
            observable.notifyObservers(event);
        }
        catch (Exception e) {
            ErrorLog.log("AccessCache", "broadcastEvent", "An error occured when triggering the access-event", e);
            System.err.println(e.toString());
        }
    }

    static {
        lock = new Object();
    }
}

