/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import scone.netobjects.CacheTableEntryInterface;
import scone.netobjects.Cacheable;
import scone.util.ServiceThread;

public class CacheTable {
    public static final int LAZYGC = 0;
    public static final int EAGERGC = 1;
    public static final boolean DEBUG = false;
    protected String cacheName;
    protected Object lock;
    protected Hashtable[] entities;
    protected int noOfKeys;
    protected int gcType;
    protected int timeTillCleanUp;
    protected Cleaner cleaner;

    public CacheTable(String cacheName, int noOfKeys, int timeTillCleanUp, int gcType) {
        this(cacheName, noOfKeys, timeTillCleanUp, gcType, 1000);
    }

    public CacheTable(String cacheName, int noOfKeys, int timeTillCleanUp, int gcType, int capacity) {
        this.cacheName = cacheName;
        this.gcType = gcType;
        this.noOfKeys = noOfKeys;
        this.lock = new Object();
        this.entities = new Hashtable[noOfKeys];
        for (int i = 0; i < noOfKeys; ++i) {
            this.entities[i] = new Hashtable(capacity);
        }
        this.timeTillCleanUp = timeTillCleanUp + (int)(20000.0 * (Math.random() - 0.5));
        this.cleaner = new Cleaner(timeTillCleanUp);
        this.cleaner.start();
    }

    public void shutdown() {
        this.cleaner.retire();
        this.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Cacheable entity) {
        Object object = this.lock;
        synchronized (object) {
            Entry entry = new Entry(entity);
            for (int i = 0; i < this.noOfKeys; ++i) {
                this.entities[i].put(entity.getKey(i), entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable get(int keyNo, Object key) {
        Object object = this.lock;
        synchronized (object) {
            Object entry = this.entities[keyNo].get(key);
            if (entry == null) {
                return null;
            }
            return ((Entry)entry).getEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Object object = this.lock;
        synchronized (object) {
            Enumeration e = this.entities[0].elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                entry.storeEntry();
            }
        }
    }

    private class Cleaner
    extends ServiceThread {
        public Cleaner(int sleepTime) {
            super(sleepTime);
        }

        public void doService() {
            CacheTable.this.clean();
        }

        public void cleanUp() {
            CacheTable.this.clean();
        }
    }

    class Entry
    implements CacheTableEntryInterface {
        Object[] key;
        Reference ref;
        Object entry;

        public Entry(Cacheable entry) {
            this.key = new Object[CacheTable.this.noOfKeys];
            for (int i = 0; i < CacheTable.this.noOfKeys; ++i) {
                this.key[i] = entry.getKey(i);
            }
            this.ref = CacheTable.this.gcType == 1 ? new WeakReference<Cacheable>(entry) : new SoftReference<Cacheable>(entry);
            this.entry = entry;
            entry.setCacheTableEntryInterface(this);
        }

        public void hold() {
            if (this.entry instanceof Reference) {
                this.entry = this.ref.get();
            }
        }

        public Cacheable getEntry() {
            Cacheable result = null;
            if (this.entry == null) {
                return null;
            }
            if (this.entry instanceof Reference) {
                result = (Cacheable)((Reference)this.entry).get();
                return result;
            }
            return (Cacheable)this.entry;
        }

        public void removeMe() {
            for (int i = 0; i < CacheTable.this.noOfKeys; ++i) {
                CacheTable.this.entities[i].remove(this.key[i]);
            }
        }

        public void storeEntry() {
            if (this.entry == null) {
                this.removeMe();
                return;
            }
            if (this.entry instanceof Reference) {
                if (((Reference)this.entry).get() == null) {
                    this.removeMe();
                }
                return;
            }
            if (this.entry instanceof Cacheable) {
                ((Cacheable)this.entry).store();
                this.entry = this.ref;
            }
        }
    }
}

