/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import scone.netobjects.FieldValueHashTable;
import scone.netobjects.Schema;
import scone.netobjects.TableRecord;
import scone.util.ErrorLog;
import scone.util.PersistentProperties;

public class DBTableAdapter {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    public static final int STRING = 0;
    public static final int NUMBER = 1;
    public static final int BLOB = 2;
    public static final int GENERATED = 0;
    public static final int KEY = 1;
    public static final int FIELD = 2;
    protected String[] fieldNames;
    protected int[] fieldTypes;
    protected String[] fieldDefaults;
    protected int fieldCount = 0;
    protected int[] keyTypes;
    protected int keyNumber = 0;
    protected int autoincrementLine = -1;
    protected String tableName;
    protected Connection con;
    protected int generatedKey = 1;
    protected static String driverName = "org.gjt.mm.mysql.Driver";
    protected static String dbURI = "jdbc:mysql://localhost:3306/Scone";
    protected static String userName = "scone";
    protected static String password = "sc0ne";
    protected static boolean useDb = true;
    protected static boolean requireDb = false;

    public DBTableAdapter(String tableName) {
        this.tableName = tableName;
        if (DBTableAdapter.useDb()) {
            this.con = DBTableAdapter.getConnection();
        }
        Schema.initialize(this);
    }

    void init(int i) {
        this.fieldNames = new String[i];
        this.fieldTypes = new int[i];
        this.fieldDefaults = new String[i];
        this.keyTypes = new int[i];
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addField(String fieldName, int fieldType, String fieldDefault, int keyType) {
        if (keyType == 0) {
            this.autoincrementLine = this.fieldCount;
        }
        this.fieldNames[this.fieldCount] = fieldName;
        this.fieldTypes[this.fieldCount] = fieldType;
        this.fieldDefaults[this.fieldCount] = fieldDefault;
        this.keyTypes[this.fieldCount] = keyType;
        ++this.fieldCount;
        if (keyType != 2) {
            ++this.keyNumber;
        }
    }

    protected FieldValueHashTable initFields(TableRecord set) {
        FieldValueHashTable fieldValues = new FieldValueHashTable(set);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            fieldValues.put(this.fieldNames[i], this.fieldDefaults[i]);
        }
        return fieldValues;
    }

    public void init(TableRecord set) {
        set.fieldValues = this.initFields(set);
        set.setChanged(true);
    }

    public void dbInit(TableRecord set) {
        if (!this.getValuesFromDb(set)) {
            this.createInDB(set);
        }
    }

    public void dbCheck(TableRecord set) {
        set.hasRecordInDB = this.getValuesFromDb(set);
    }

    public void dbCreate(TableRecord set) {
        this.createInDB(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDB(TableRecord set) {
        TableRecord tableRecord = set;
        synchronized (tableRecord) {
            if (set.hasChanged && set.hasRecordInDB && set.persistent) {
                String query = "update " + this.tableName + " set";
                String delimiter = "";
                for (int i = 0; i < this.fieldNames.length; ++i) {
                    if (this.keyTypes[i] != 2) continue;
                    query = this.fieldTypes[i] == 0 || this.fieldTypes[i] == 2 ? query + " " + this.fieldNames[i] + "= " + "'" + DBTableAdapter.escape(set.fieldValues.get(this.fieldNames[i])) + "'," : query + " " + this.fieldNames[i] + "= " + set.fieldValues.get(this.fieldNames[i]) + ",";
                }
                if (query.length() == new String("update " + this.tableName + " set").length()) {
                    return;
                }
                query = query.substring(0, query.length() - 1);
                query = query + this.getWhereClause(set);
                if (set.persistent && DBTableAdapter.useDb() && this.con != null) {
                    try {
                        Connection i = this.con;
                        synchronized (i) {
                            Statement stmt = this.con.createStatement();
                            int results = stmt.executeUpdate(query);
                            set.setChanged(false);
                        }
                    }
                    catch (SQLException e) {
                        ErrorLog.log(this, "updateDB(TableRecord set)", "Could not store in database! " + query, e);
                        System.out.println("-> Scone: Could not store in database.");
                        System.out.println("   Possible error: data packet too big.");
                        System.out.println("   Hints: Please set in [mysqld]-Section of my.ini:");
                        System.out.println("     'set-variable = max_allowed_packet=16M' (for mysql<=4.0)");
                        System.out.println("     'max_allowed_packet=16M' (for mysql=>4.1)");
                        System.out.println("     and add '?jdbcCompliantTruncation=false' to connection string (4.1).");
                        DBTableAdapter.dbError();
                    }
                    catch (Exception e) {
                        ErrorLog.log(this, "updateDB(TableRecord set)", "Could not store in database! " + query, e);
                        System.out.println("-> Scone: ERROR! Could not store in database:\n " + query);
                        DBTableAdapter.dbError();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getValuesFromDb(TableRecord set) {
        if (!DBTableAdapter.useDb() || this.con == null) {
            return false;
        }
        String query = "select * from " + this.tableName + this.getWhereClause(set);
        TableRecord tableRecord = set;
        synchronized (tableRecord) {
            try {
                Connection connection = this.con;
                synchronized (connection) {
                    Statement stmt = this.con.createStatement();
                    ResultSet results = stmt.executeQuery(query);
                    return this.fill(set, results);
                }
            }
            catch (Exception e) {
                ErrorLog.log(this, "getValuesFromDb(TableRecord set)", "Could not read from database! " + query, e);
                System.out.println("-> Scone: ERROR! Could not read from database:\n " + query);
                DBTableAdapter.dbError();
                return false;
            }
        }
    }

    public static ResultSet queryDb(Connection con, String tableName, String sqlClause) {
        if (!DBTableAdapter.useDb() || con == null) {
            return null;
        }
        String query = "select * from " + tableName + " " + sqlClause;
        try {
            Statement stmt = con.createStatement();
            ResultSet results = stmt.executeQuery(query);
            return results;
        }
        catch (Exception e) {
            ErrorLog.log(tableName, "DBTableAdapter.queryDb()", "Could not read from database! " + query, e);
            System.out.println("-> Scone: ERROR! Could not read from database:\n " + query);
            DBTableAdapter.dbError();
            return null;
        }
    }

    public static int rowCountDb(Connection con, String tableName, String sqlClause) {
        if (!DBTableAdapter.useDb() || con == null) {
            return -1;
        }
        String query = "select count(*) from " + tableName + " " + sqlClause;
        try {
            Statement stmt = con.createStatement();
            ResultSet results = stmt.executeQuery(query);
            if (results.next()) {
                int result = results.getInt(1);
                con.close();
                return result;
            }
            con.close();
            return -1;
        }
        catch (Exception e) {
            ErrorLog.log(tableName, "DBTableAdapter.rowCountDb()", "Could not read from database! " + query, e);
            System.out.println("-> Scone: ERROR! Could not read from database:\n " + query);
            DBTableAdapter.dbError();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fill(TableRecord set, ResultSet results) {
        TableRecord tableRecord = set;
        synchronized (tableRecord) {
            try {
                if (results.next()) {
                    for (int i = 0; i < this.fieldNames.length; ++i) {
                        if (this.fieldTypes[i] == 0 || this.fieldTypes[i] == 2) {
                            set.fieldValues.put(this.fieldNames[i], DBTableAdapter.unEscape(DBTableAdapter.safeString(results.getString(this.fieldNames[i]))));
                            continue;
                        }
                        set.fieldValues.put(this.fieldNames[i], DBTableAdapter.safeString(results.getString(this.fieldNames[i])));
                    }
                    set.hasRecordInDB = true;
                    return true;
                }
            }
            catch (Exception e) {
                ErrorLog.log(this, "fill(TableRecord set,ResultSet results)", "Could not read from database! ", e);
                DBTableAdapter.dbError();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInDB(TableRecord set) {
        TableRecord tableRecord = set;
        synchronized (tableRecord) {
            String columns = "";
            String values = "";
            String delimiter = "";
            for (int i = 0; i < this.fieldNames.length; ++i) {
                if (this.keyTypes[i] == 0) continue;
                columns = columns + this.fieldNames[i] + ",";
                values = this.fieldTypes[i] == 0 || this.fieldTypes[i] == 2 ? values + "'" + DBTableAdapter.escape(set.fieldValues.get(this.fieldNames[i])) + "'," : values + set.fieldValues.get(this.fieldNames[i]) + ",";
            }
            columns = columns.substring(0, columns.length() - 1);
            values = values.substring(0, values.length() - 1);
            String query = "INSERT ";
            if (this.autoincrementLine < 0) {
                query = query + "DELAYED ";
            }
            query = query + "INTO " + this.tableName + " (" + columns + ") VALUES(" + values + ")";
            if (set.persistent && DBTableAdapter.useDb() && this.con != null) {
                try {
                    Connection connection = this.con;
                    synchronized (connection) {
                        Statement stmt = this.con.createStatement();
                        int i = stmt.executeUpdate(query);
                        set.hasRecordInDB = true;
                        if (this.autoincrementLine >= 0) {
                            Statement stmt2 = this.con.createStatement();
                            query = "select " + this.fieldNames[this.autoincrementLine] + " from " + this.tableName + this.getWhereClause(set);
                            ResultSet r = stmt2.executeQuery(query);
                            r.next();
                            set.fieldValues.put(this.fieldNames[this.autoincrementLine], DBTableAdapter.safeString(r.getString(this.fieldNames[this.autoincrementLine])));
                        }
                        set.setChanged(false);
                    }
                }
                catch (SQLException e) {
                    ErrorLog.log(this, "createInDB(TableRecord set)", "Could not store in database! " + query, e);
                    System.out.println("-> Scone: Could not store in database.");
                    System.out.println("          Possible error: data packet too big.");
                    System.out.println("          Please set 'set-variable = max_allowed_packet=16M' in");
                    System.out.println("          [mysqld]-Section of mysql.ini");
                    DBTableAdapter.dbError();
                }
                catch (Exception e) {
                    ErrorLog.log(this, "createInDB(TableRecord set)", "Could not insert into db: query = " + query, e);
                    System.out.println("-> Scone: ERROR! Could not insert into database:\n " + query);
                    DBTableAdapter.dbError();
                }
            } else {
                if (this.autoincrementLine >= 0) {
                    set.fieldValues.put(this.fieldNames[this.autoincrementLine], String.valueOf(this.generatedKey));
                    ++this.generatedKey;
                }
                set.hasRecordInDB = true;
            }
        }
    }

    public String getWhereClause(TableRecord set) {
        if (this.autoincrementLine >= 0 && set.fieldValues.get(this.fieldNames[this.autoincrementLine]) != this.fieldDefaults[this.autoincrementLine]) {
            String ret = " where " + this.fieldNames[this.autoincrementLine] + "=" + set.fieldValues.get(this.fieldNames[this.autoincrementLine]);
            return ret;
        }
        String keyString = "";
        String delimiter = "";
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (this.keyTypes[i] != 1) continue;
            if (keyString.length() > 0) {
                keyString = keyString + " and";
            }
            keyString = this.fieldTypes[i] == 0 || this.fieldTypes[i] == 2 ? keyString + " " + this.fieldNames[i] + "=" + "'" + DBTableAdapter.escape(set.fieldValues.get(this.fieldNames[i])) + "'" : keyString + " " + this.fieldNames[i] + " = " + set.fieldValues.get(this.fieldNames[i]);
        }
        if (keyString.length() == 0) {
            return "";
        }
        return " where" + keyString;
    }

    public static String safeString(String unsafe) {
        if (unsafe != null) {
            return unsafe;
        }
        return "";
    }

    public static String escape(String s) {
        return DBTableAdapter.escape(new StringBuffer(s));
    }

    public static String escape(StringBuffer s) {
        StringBuffer t = new StringBuffer(s.length() + 100);
        block15: for (int i = 0; i < s.length(); ++i) {
            char test = s.charAt(i);
            switch (test) {
                case '\u0000': {
                    t.append('\\');
                    t.append('0');
                    continue block15;
                }
                case '\n': {
                    t.append('\\');
                    t.append('n');
                    continue block15;
                }
                case '\r': {
                    t.append('\\');
                    t.append('r');
                    continue block15;
                }
                case '\b': {
                    t.append('\\');
                    t.append('b');
                    continue block15;
                }
                case '\t': {
                    t.append('\\');
                    t.append('h');
                    continue block15;
                }
                case '\'': {
                    t.append('\\');
                    t.append('\'');
                    continue block15;
                }
                case '\"': {
                    t.append('\\');
                    t.append('\"');
                    continue block15;
                }
                case '\\': {
                    t.append('\\');
                    t.append('\\');
                    continue block15;
                }
                case '%': {
                    t.append('\\');
                    t.append('%');
                    continue block15;
                }
                case '_': {
                    t.append('\\');
                    t.append('_');
                    continue block15;
                }
                case '{': {
                    t.append('\\');
                    t.append('(');
                    continue block15;
                }
                case '|': {
                    t.append('\\');
                    t.append('I');
                    continue block15;
                }
                case '}': {
                    t.append('\\');
                    t.append(')');
                    continue block15;
                }
                default: {
                    t.append(test);
                }
            }
        }
        return t.toString();
    }

    public static String unEscape(String s) {
        return DBTableAdapter.unEscape(new StringBuffer(s));
    }

    public static String unEscape(StringBuffer s) {
        StringBuffer t = new StringBuffer();
        boolean slash = false;
        block15: for (int i = 0; i < s.length(); ++i) {
            char test = s.charAt(i);
            if (!slash) {
                if (test == '\\') {
                    slash = true;
                    continue;
                }
                t.append(test);
                continue;
            }
            slash = false;
            switch (test) {
                case '0': {
                    t.append(0);
                    continue block15;
                }
                case 'n': {
                    t.append(10);
                    continue block15;
                }
                case 'r': {
                    t.append(13);
                    continue block15;
                }
                case 'b': {
                    t.append(8);
                    continue block15;
                }
                case 'h': {
                    t.append(9);
                    continue block15;
                }
                case '\'': {
                    t.append(39);
                    continue block15;
                }
                case '\"': {
                    t.append(34);
                    continue block15;
                }
                case '\\': {
                    t.append(92);
                    continue block15;
                }
                case '%': {
                    t.append(37);
                    continue block15;
                }
                case '_': {
                    t.append('_');
                    continue block15;
                }
                case '(': {
                    t.append('{');
                    continue block15;
                }
                case 'I': {
                    t.append('|');
                    continue block15;
                }
                case ')': {
                    t.append('}');
                }
            }
        }
        return t.toString();
    }

    public static void init() {
        PersistentProperties props = new PersistentProperties("config/scone/db.xml");
        driverName = props.get("JDBC Driver");
        dbURI = props.get("Database URI");
        userName = props.get("Username");
        password = props.get("Password");
        if (props.get("Use Database").equals("true")) {
            useDb = true;
            System.out.println("-> Scone: Using database " + dbURI);
        } else {
            useDb = false;
            System.out.println("-> Scone: database turned off.");
        }
        if (props.get("Deactivate database on errors").equals("true")) {
            requireDb = true;
            System.out.println("-> Scone: Database will be deactivated on database exceptions.");
        } else {
            requireDb = false;
        }
        if (useDb) {
            try {
                Class.forName(driverName).newInstance();
            }
            catch (Exception e) {
                ErrorLog.log("static DBTableAdapter", "init()", "Could not load mysql driver: " + driverName, e);
                System.out.println("-> Scone: ERROR! --------------------------------------------------");
                System.out.println("   Could not load mysql driver: " + driverName);
                DBTableAdapter.dontUseDb();
            }
        }
    }

    public static Connection getConnection() {
        Connection con = null;
        if (DBTableAdapter.useDb()) {
            try {
                con = DriverManager.getConnection(dbURI, userName, password);
            }
            catch (Exception e) {
                ErrorLog.log("static DBTableAdapter", "getConnection()", "Could not connect to database " + dbURI, e);
                System.out.println("-> Scone: ERROR! --------------------------------------------------");
                System.out.println("          Could not connect to database " + dbURI);
                DBTableAdapter.dontUseDb();
            }
        } else {
            System.out.println("-> Scone: ERROR! --------------------------------------------------");
            System.out.println("   The database was deactivated but was requested by a plugin!");
            System.out.println("");
            System.out.println("   ----------------------------------------------------------------");
        }
        return con;
    }

    protected static void dontUseDb() {
        useDb = false;
        System.out.println("-> Scone: Database access deactivated due to an fatal exception!");
        System.out.println("   ----------------------------------------------------------------\n");
    }

    protected static void dbError() {
        System.out.println("   Attention: Results may be corrupted.");
        if (requireDb) {
            useDb = false;
            System.out.println("   Database access has been DISABLED due to an exception!");
        }
        System.out.println("   ----------------------------------------------------------------\n");
    }

    public static boolean useDb() {
        return useDb;
    }
}

