/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.util.Vector;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.InclusionCache;
import scone.netobjects.LinkCache;
import scone.netobjects.LinkVector;
import scone.netobjects.NetNode;
import scone.netobjects.SimpleUri;
import scone.netobjects.TableRecord;

public class HtmlNode
extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    protected static DBTableAdapter dbTable = new DBTableAdapter("HtmlDocumentTable");
    protected NetNode node = null;
    protected LinkVector outgoingLinks = new LinkVector();
    protected LinkVector incomingLinks = new LinkVector();
    protected Vector inclusions = new Vector();

    public String getTitle() {
        return this.fieldValues.get("title");
    }

    public void setTitle(String title) {
        this.fieldValues.put("title", title);
    }

    public String getAuthor() {
        return this.fieldValues.get("author");
    }

    public void setAuthor(String author) {
        this.fieldValues.put("author", author);
    }

    public String getDescription() {
        return this.fieldValues.get("description");
    }

    public void setDescription(String des) {
        this.fieldValues.put("description", des);
    }

    public String getAbstract() {
        return this.fieldValues.get("abstract");
    }

    public void setAbstract(String abs) {
        this.fieldValues.put("abstract", abs);
    }

    public String getLanguage() {
        return this.fieldValues.get("language");
    }

    public void setLanguage(String lang) {
        this.fieldValues.put("language", lang);
    }

    public String getBodyText() {
        return this.fieldValues.get("bodytext");
    }

    public void setBodyText(String bodyText) {
        this.fieldValues.put("bodytext", bodyText);
    }

    public String getSourceCode() {
        return this.fieldValues.get("sourcecode");
    }

    public void setSourceCode(String sourceCode) {
        this.fieldValues.put("sourcecode", sourceCode);
    }

    public String getFingerprint() {
        return this.fieldValues.get("fingerprint");
    }

    public void setFingerprint(String fingerprint) {
        this.fieldValues.put("fingerprint", fingerprint);
    }

    public String getNumberOfLinks() {
        return this.fieldValues.get("numberOfLinks");
    }

    public void setNumberOfLinks(String links) {
        this.fieldValues.put("numberOfLinks", links);
    }

    public String getNumberOfExternalLinks() {
        return this.fieldValues.get("numberOfExternalLinks");
    }

    public void setNumberOfExternalLinks(String v) {
        this.fieldValues.put("numberOfExternalLinks", v);
    }

    public String getNumberOfImages() {
        return this.fieldValues.get("numberOfImages");
    }

    public void setNumberOfImages(String v) {
        this.fieldValues.put("numberOfImages", v);
    }

    public String getSpaceOfImages() {
        return this.fieldValues.get("spaceOfImages");
    }

    public void setSpaceOfImages(String v) {
        this.fieldValues.put("spaceOfImages", v);
    }

    public String getNumberOfWords() {
        return this.fieldValues.get("numberOfWords");
    }

    public void setNumberOfWords(String v) {
        this.fieldValues.put("numberOfWords", v);
    }

    public String getNumberOfParagraphs() {
        return this.fieldValues.get("numberOfParagraphs");
    }

    public void setNumberOfParagraphs(String p) {
        this.fieldValues.put("numberOfParagraphs", p);
    }

    public NetNode getNode() {
        return this.node;
    }

    public String getNodeId() {
        return this.node.getNodeId();
    }

    protected HtmlNode(NetNode node) {
        this.node = node;
        dbTable.init(this);
        this.fieldValues.put("nodeId", node.getNodeId());
        dbTable.dbCheck(this);
    }

    public void store() {
        if (this.hasRecordInDB) {
            dbTable.updateDB(this);
        } else {
            dbTable.createInDB(this);
        }
    }

    public Object getKey(int KeyNo) {
        return this.getNodeId();
    }

    public String toString() {
        return "HTMLObject\t " + this.node.toString();
    }

    public LinkVector getOutgoingLinks() {
        if (this.outgoingLinks.size() == 0) {
            this.outgoingLinks = LinkCache.getLinksFrom(this.node);
        }
        return this.outgoingLinks;
    }

    public LinkVector getIncomingLinks() {
        if (this.incomingLinks.size() == 0) {
            this.incomingLinks = LinkCache.getLinksTo(this.node);
        }
        return this.incomingLinks;
    }

    public Vector getIncludedObjects() {
        if (this.inclusions.size() == 0) {
            this.inclusions = InclusionCache.getIncludedObjects(this.node);
        }
        return this.inclusions;
    }

    public void access() {
        this.node.access();
    }

    public String getUri() {
        return this.node.getUri();
    }

    public String getSize() {
        return this.node.getSize();
    }

    public void setSize(String size) {
        this.node.setSize(size);
    }

    public long getLastModified() {
        return this.node.getLastModified();
    }

    public void setLastModified(long time) {
        this.node.setLastModified(time);
    }

    public String getMimeType() {
        return this.node.getMimeType();
    }

    public void setMimeType(String v) {
        this.node.setMimeType(v);
    }

    public String getAccessStatus() {
        return this.node.getAccessStatus();
    }

    public void setAccessStatus(String v) {
        this.node.setAccessStatus(v);
    }

    public long getFirstAccess() {
        return this.node.getFirstAccess();
    }

    public long getLastAccess() {
        return this.node.getLastAccess();
    }

    protected void setLastAccess(long v) {
        this.node.setLastAccess(v);
    }

    public int getAccessCounter() {
        return this.node.getAccessCounter();
    }

    protected void setAccessCounter(int v) {
        this.node.setAccessCounter(v);
    }

    protected void incAccessCounter() {
        this.node.incAccessCounter();
    }

    public SimpleUri getSUri() {
        return this.node.getSUri();
    }

    public boolean isFrames() {
        return this.isTypeBit(0);
    }

    public void setFrames(boolean b) {
        this.setTypeBit(0, b);
    }

    public boolean isForms() {
        return this.isTypeBit(1);
    }

    public void setForms(boolean b) {
        this.setTypeBit(1, b);
    }

    public boolean isCommercial() {
        return this.isTypeBit(2);
    }

    public void setCommercial(boolean b) {
        this.setTypeBit(2, b);
    }

    public boolean isJavaScript() {
        return this.isTypeBit(3);
    }

    public void setJavaScript(boolean b) {
        this.setTypeBit(3, b);
    }

    public boolean isPlugins() {
        return this.isTypeBit(4);
    }

    public void setPlugins(boolean b) {
        this.setTypeBit(4, b);
    }

    public boolean isAnimation() {
        return this.isTypeBit(5);
    }

    public void setAnimation(boolean b) {
        this.setTypeBit(5, b);
    }

    public boolean isSound() {
        return this.isTypeBit(6);
    }

    public void setSound(boolean b) {
        this.setTypeBit(6, b);
    }

    public boolean isCompletelyDownloaded() {
        return this.isTypeBit(10);
    }

    public void setCompletelyDownloaded(boolean b) {
        this.setTypeBit(10, b);
    }

    private synchronized void setTypeBit(int position, boolean b) {
        int typeValue = Integer.parseInt(this.fieldValues.get("type"));
        int mask = 1 << position;
        typeValue = b ? (typeValue |= mask) : (typeValue &= (mask ^= Integer.MAX_VALUE));
        this.fieldValues.put("type", String.valueOf(typeValue));
    }

    private synchronized boolean isTypeBit(int position) {
        int typeValue = Integer.parseInt(this.fieldValues.get("type"));
        int mask = 1 << position;
        return (typeValue &= mask) != 0;
    }

    public String toDocString() {
        return this.node.toDocString();
    }

    public String toHostString() {
        return this.node.toHostString();
    }

    public String getProtocol() {
        return this.node.getProtocol();
    }

    public String getHost() {
        return this.node.getHost();
    }

    public String getPort() {
        return this.node.getPort();
    }

    public String getPath() {
        return this.node.getPath();
    }

    public String getFile() {
        return this.node.getFile();
    }

    public String getExtension() {
        return this.node.getExtension();
    }

    public String getQuery() {
        return this.node.getQuery();
    }

    public String getRef() {
        return this.node.getRef();
    }
}

