/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.sql.Connection;
import java.util.Observer;
import scone.netobjects.Cache;
import scone.netobjects.CacheTable;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.HtmlNode;
import scone.netobjects.NetNode;
import scone.netobjects.TableRecordCacheInterface;

public class HtmlNodeCache
extends Cache
implements TableRecordCacheInterface {
    protected static HtmlNodeCache observable;
    protected static int observePeriod;
    protected static CacheTable cache;
    protected static Object lock;

    public static void init(int timeTillCleanUp, int gcType) {
        cache = new CacheTable("Html-Documents", 1, timeTillCleanUp, gcType);
        lock = new Object();
        observePeriod = 4000;
        observable = new HtmlNodeCache();
    }

    public static void setObservePeriod(int period) {
        observePeriod = period;
    }

    public static int getObservePeriod() {
        return observePeriod;
    }

    public static void putObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void removeObserver(Observer o) {
        observable.deleteObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HtmlNode check(NetNode node) {
        if (node == null) {
            return null;
        }
        HtmlNode doc = null;
        String key = node.getNodeId();
        Object object = lock;
        synchronized (object) {
            doc = (HtmlNode)cache.get(0, key);
            if (doc == null) {
                doc = new HtmlNode(node);
                if (!doc.hasRecordInDB) {
                    return null;
                }
                cache.put(doc);
                observable.addItem(doc);
            }
        }
        return doc;
    }

    public static HtmlNode check(NetNode node, boolean persistent) {
        HtmlNode doc = HtmlNodeCache.check(node);
        if (doc == null) {
            return null;
        }
        if (persistent) {
            doc.store();
        } else {
            doc.setPersistent(false);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HtmlNode get(NetNode node) {
        if (node == null) {
            return null;
        }
        HtmlNode doc = null;
        String key = node.getNodeId();
        Object object = lock;
        synchronized (object) {
            doc = (HtmlNode)cache.get(0, key);
            if (doc == null) {
                doc = new HtmlNode(node);
                cache.put(doc);
                observable.addItem(doc);
            }
        }
        return doc;
    }

    public static HtmlNode get(NetNode node, boolean persistent) {
        HtmlNode doc = HtmlNodeCache.get(node);
        if (doc == null) {
            return null;
        }
        if (persistent) {
            doc.store();
        } else {
            doc.setPersistent(false);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHtmlNodeCount(String sqlClause) {
        int count;
        Connection con = HtmlNode.dbTable.getConnection();
        Object object = lock;
        synchronized (object) {
            count = DBTableAdapter.rowCountDb(con, HtmlNode.dbTable.getTableName(), sqlClause);
        }
        return count;
    }

    public static void clean() {
        cache.shutdown();
    }

    static {
        observePeriod = 0;
        lock = new Object();
    }
}

