/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.sql.ResultSet;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.InclusionCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.SimpleUri;
import scone.netobjects.TableRecord;

public class Inclusion
extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    protected static DBTableAdapter dbTable = new DBTableAdapter("InclusionTable");
    protected NetNode parentNode = null;
    protected NetNode childNode = null;

    public Inclusion() {
        dbTable.init(this);
    }

    public Inclusion(String inclusionId) {
        dbTable.init(this);
        this.fieldValues.put("inclusionId", inclusionId);
        dbTable.dbCheck(this);
        if (this.hasRecordInDB) {
            this.parentNode = NetNodeCache.getById(this.fieldValues.get("parentNodeId"));
            this.childNode = NetNodeCache.getById(this.fieldValues.get("childNodeId"));
        }
    }

    protected Inclusion(NetNode parent, NetNode child) {
        dbTable.init(this);
        this.setInclusionId(SimpleUri.getHexHashCode("Inclsuion:" + parent.getNodeId() + child.getNodeId()));
        dbTable.dbCheck(this);
        if (this.hasRecordInDB) {
            this.parentNode = NetNodeCache.getById(this.fieldValues.get("parentNodeId"));
            this.childNode = NetNodeCache.getById(this.fieldValues.get("childNodeId"));
        } else {
            this.parentNode = parent;
            this.childNode = child;
            this.fieldValues.put("parentNodeId", parent.getNodeId());
            this.fieldValues.put("childNodeId", child.getNodeId());
        }
    }

    public Inclusion(ResultSet results) {
        dbTable.init(this);
        dbTable.fill(this, results);
    }

    public String getInclusionId() {
        return this.fieldValues.get("inclusionId");
    }

    private void setInclusionId(String id) {
        this.fieldValues.put("inclusionId", id);
    }

    public String getParentNodeId() {
        return this.fieldValues.get("parentNodeId");
    }

    public NetNode getParentNode() {
        return NetNodeCache.getById(this.getParentNodeId());
    }

    public String getChildNodeId() {
        return this.fieldValues.get("childNodeId");
    }

    public NetNode getChildNode() {
        return NetNodeCache.getById(this.getChildNodeId());
    }

    public String getTag() {
        return this.fieldValues.get("tag");
    }

    public void setTag(String tag) {
        this.fieldValues.put("tag", tag);
    }

    public String getInfo() {
        return this.fieldValues.get("info");
    }

    public void setInfo(String i) {
        this.fieldValues.put("info", i);
    }

    public void store() {
        if (this.hasRecordInDB) {
            dbTable.updateDB(this);
        } else {
            dbTable.createInDB(this);
        }
    }

    public Object getKey(int KeyNo) {
        switch (KeyNo) {
            case 0: {
                return this.getInclusionId();
            }
            case 1: {
                return InclusionCache.createKey(this.getParentNodeId(), this.getChildNodeId());
            }
        }
        return "";
    }
}

