/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Vector;
import scone.netobjects.CacheTable;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.Inclusion;
import scone.netobjects.NetNode;
import scone.netobjects.TableRecordCacheInterface;

public class InclusionCache
implements TableRecordCacheInterface {
    protected static CacheTable cache;
    protected static Object lock;

    public static void init(int timeTillCleanUp, int gcType) {
        cache = new CacheTable("Inclusions", 2, timeTillCleanUp, gcType);
        lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Inclusion get(NetNode parent, NetNode child) {
        Inclusion inclusion = null;
        String key = InclusionCache.createKey(parent.getNodeId(), child.getNodeId());
        Object object = lock;
        synchronized (object) {
            inclusion = (Inclusion)cache.get(1, key);
            if (inclusion == null) {
                inclusion = new Inclusion(parent, child);
                cache.put(inclusion);
            }
        }
        return inclusion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Inclusion getById(String id) {
        Inclusion inclusion = null;
        Object object = lock;
        synchronized (object) {
            inclusion = (Inclusion)cache.get(0, id);
            if (inclusion == null) {
                inclusion = new Inclusion(id);
                cache.put(inclusion);
            }
        }
        return inclusion;
    }

    public static Vector getIncludedObjects(NetNode from) {
        return InclusionCache.getInclusions("where parentNodeId='" + from.getNodeId() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getInclusions(String sqlClause) {
        InclusionCache.clean();
        Connection con = Inclusion.dbTable.getConnection();
        Vector<Inclusion> inclusions = new Vector<Inclusion>();
        boolean i = false;
        Object object = lock;
        synchronized (object) {
            ResultSet results = DBTableAdapter.queryDb(con, Inclusion.dbTable.getTableName(), sqlClause);
            while (results != null) {
                Inclusion inclusion = new Inclusion(results);
                String id = inclusion.getInclusionId();
                if (id.length() > 0 && !id.equals("-1")) {
                    if (cache.get(0, id) == null) {
                        cache.put(inclusion);
                    }
                    inclusions.add(inclusion);
                    continue;
                }
                return inclusions;
            }
        }
        return inclusions;
    }

    protected static String createKey(String a, String b) {
        return a + "/" + b;
    }

    public static void clean() {
        cache.clean();
    }

    static {
        lock = new Object();
    }
}

