/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import adc.parser.HtmlStreamTokenizer;
import adc.parser.HtmlTag;
import java.sql.ResultSet;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.LinkCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.TableRecord;

public class Link
extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    public static final int SAMEDOCUMENT = 1;
    public static final int FRAGMENT = 2;
    public static final int QUERY = 4;
    public static final int EXTERNAL = 64;
    public static final int INTERNAL = 128;
    public static final int FROMHOME = 1024;
    public static final int TOHOME = 2048;
    public static final int DOWN = 16384;
    public static final int UP = 32768;
    public static final int SAMECLUSTER = 0x100000;
    public static final int FROMCLUSTERINDEX = 0x200000;
    public static final int TOCLUSTERINDEX = 0x400000;
    public static final int NOHTTP = 0x1000000;
    public static final int NOHTML = 0x2000000;
    protected static DBTableAdapter dbTable = new DBTableAdapter("LinkTable");
    protected NetNode fromNode = null;
    protected NetNode toNode = null;

    public Link() {
        dbTable.init(this);
    }

    public Link(ResultSet results) {
        this();
        dbTable.fill(this, results);
        if (this.hasRecordInDB) {
            this.fromNode = NetNodeCache.getById(this.fieldValues.get("fromNodeId"));
            this.toNode = NetNodeCache.getById(this.fieldValues.get("toNodeId"));
        }
    }

    public Link(String linkId) {
        this();
        this.setLinkId(linkId);
        dbTable.dbCheck(this);
        if (this.hasRecordInDB) {
            this.fromNode = NetNodeCache.getById(this.fieldValues.get("fromNodeId"));
            this.toNode = NetNodeCache.getById(this.fieldValues.get("toNodeId"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Link(NetNode from, NetNode to, String fragment) {
        this();
        this.setLinkId(LinkCache.createKey(from.getNodeId(), to.getNodeId(), fragment));
        dbTable.dbCheck(this);
        if (this.hasRecordInDB) {
            if (DBTableAdapter.useDb) {
                this.fromNode = NetNodeCache.getById(this.fieldValues.get("fromNodeId"));
                this.toNode = NetNodeCache.getById(this.fieldValues.get("toNodeId"));
                return;
            }
        }
        this.fromNode = from;
        this.toNode = to;
        this.fieldValues.put("fromNodeId", from.getNodeId());
        this.fieldValues.put("toNodeId", to.getNodeId());
        this.fieldValues.put("fragment", fragment);
        this.computeType();
    }

    public String getLinkId() {
        return this.fieldValues.get("linkId");
    }

    private void setLinkId(String id) {
        this.fieldValues.put("linkId", id);
    }

    public String getLinkText() {
        return this.fieldValues.get("linkText");
    }

    public void setLinkText(String v) {
        this.fieldValues.put("linkText", v);
    }

    public String getTarget() {
        return this.fieldValues.get("target");
    }

    public void setTarget(String v) {
        this.fieldValues.put("target", v);
    }

    public String getTitle() {
        return this.fieldValues.get("title");
    }

    public void setTitle(String v) {
        this.fieldValues.put("title", v);
    }

    public String getAlt() {
        return this.fieldValues.get("alt");
    }

    public void setAlt(String v) {
        this.fieldValues.put("alt", v);
    }

    public String getRev() {
        return this.fieldValues.get("rev");
    }

    public void setRev(String v) {
        this.fieldValues.put("rev", v);
    }

    public String getRel() {
        return this.fieldValues.get("rel");
    }

    public void setRel(String v) {
        this.fieldValues.put("rel", v);
    }

    public int getType() {
        return Integer.parseInt(this.fieldValues.get("type"));
    }

    public void setType(int t) {
        this.fieldValues.put("type", String.valueOf(t));
    }

    public NetNode getFromNode() {
        return this.fromNode;
    }

    public NetNode getToNode() {
        return this.toNode;
    }

    public String getFragment() {
        return this.fieldValues.get("fragment");
    }

    public void fill(HtmlTag tag) {
        String dummy = tag.getParam("target");
        if (dummy != null) {
            this.fieldValues.put("target", dummy);
        }
        if ((dummy = tag.getParam("title")) != null) {
            this.fieldValues.put("title", HtmlStreamTokenizer.unescape((String)dummy));
        }
        if ((dummy = tag.getParam("alt")) != null) {
            this.fieldValues.put("alt", HtmlStreamTokenizer.unescape((String)dummy));
        }
        if ((dummy = tag.getParam("rev")) != null) {
            this.fieldValues.put("rev", dummy);
        }
        if ((dummy = tag.getParam("rel")) != null) {
            this.fieldValues.put("rel", dummy);
        }
    }

    public void store() {
        if (this.hasRecordInDB) {
            dbTable.updateDB(this);
        } else {
            dbTable.createInDB(this);
        }
    }

    public Object getKey(int KeyNo) {
        switch (KeyNo) {
            case 0: {
                return this.getLinkId();
            }
        }
        return "";
    }

    public void computeType() {
        int type = 0;
        if (this.fromNode.toDocString().equals(this.toNode.toDocString())) {
            type |= 1;
        }
        if (this.getFragment().length() > 0) {
            type |= 2;
        }
        if (this.toNode.getQuery().length() > 0) {
            type |= 4;
        }
        if ((this.toNode.getProtocol().equals("http") || this.toNode.getProtocol().equals("ftp")) && !this.fromNode.toHostString().equals(this.toNode.toHostString())) {
            type |= 0x40;
        }
        if ((this.toNode.getProtocol().equals("http") || this.toNode.getProtocol().equals("ftp")) && this.fromNode.toHostString().equals(this.toNode.toHostString())) {
            type |= 0x80;
        }
        if (this.fromNode.getPath().equals("/") && this.fromNode.getFile().equals("")) {
            type |= 0x400;
        }
        if (this.toNode.getPath().equals("/") && this.toNode.getFile().equals("")) {
            type |= 0x800;
        }
        if ((type & 0x40) == 0) {
            if (this.toNode.getPath().startsWith(this.fromNode.getPath()) && !this.fromNode.getPath().equals(this.toNode.getPath()) && this.fromNode.toHostString().equals(this.toNode.toHostString())) {
                type |= 0x4000;
            }
            if (this.fromNode.getPath().startsWith(this.toNode.getPath()) && !this.fromNode.getPath().equals(this.toNode.getPath()) && this.fromNode.toHostString().equals(this.toNode.toHostString())) {
                type |= 0x8000;
            }
            if (this.fromNode.getPath().equals(this.toNode.getPath())) {
                type |= 0x100000;
            }
            if (this.fromNode.getPath().equals(this.toNode.getPath()) && this.fromNode.getFile().equals("") && !this.fromNode.toDocString().equals(this.toNode.toDocString())) {
                type |= 0x200000;
            }
            if (this.fromNode.getPath().equals(this.toNode.getPath()) && this.toNode.getFile().equals("") && !this.fromNode.toDocString().equals(this.toNode.toDocString())) {
                type |= 0x400000;
            }
        }
        if (!this.toNode.getProtocol().equals("http")) {
            type |= 0x1000000;
        }
        if (!this.toNode.getMimeType().equals("text/html") && !this.toNode.getMimeType().equals("")) {
            type |= 0x2000000;
        }
        this.setType(type);
    }
}

