/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import adc.parser.HtmlTag;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Vector;
import scone.netobjects.CacheTable;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.Link;
import scone.netobjects.LinkVector;
import scone.netobjects.NetNode;
import scone.netobjects.SimpleUri;
import scone.netobjects.TableRecordCacheInterface;
import scone.util.ErrorLog;

public class LinkCache
implements TableRecordCacheInterface {
    protected static CacheTable cache;
    public static Object lock;

    public static void init(int timeTillCleanUp, int gcType) {
        cache = new CacheTable("Links", 1, timeTillCleanUp, gcType, 20000);
        lock = new Object();
    }

    public static LinkVector getLinksFrom(NetNode from) {
        return (LinkVector)LinkCache.getLinks("where fromNodeId='" + from.getNodeId() + "'");
    }

    public static LinkVector getLinksTo(NetNode to) {
        return (LinkVector)LinkCache.getLinks("where toNodeId='" + to.getNodeId() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getLinks(String sqlClause) {
        LinkCache.clean();
        LinkVector links = new LinkVector();
        if (Link.dbTable.useDb()) {
            Connection con = Link.dbTable.getConnection();
            boolean i = false;
            Object object = lock;
            synchronized (object) {
                ResultSet results = DBTableAdapter.queryDb(con, Link.dbTable.getTableName(), sqlClause);
                while (results != null) {
                    Link link = new Link(results);
                    String id = link.getLinkId();
                    if (link.hasRecordInDB) {
                        if (cache.get(0, id) == null) {
                            cache.put(link);
                        }
                        links.add(link);
                        continue;
                    }
                    return links;
                }
            }
            try {
                con.close();
            }
            catch (Exception e) {
                ErrorLog.log(Link.dbTable.getTableName(), "LinkCache.getLinks()", "Could not close database connection", e);
            }
            return null;
        }
        System.out.println("|-------------------------------------------------------------|");
        System.out.println("| A method that requires the database was used, but           |");
        System.out.println("| Database access has been disabled. Result may be corrupted. |");
        System.out.println("|-------------------------------------------------------------|");
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLinkCount(String sqlClause) {
        int count = 0;
        if (Link.dbTable.useDb()) {
            Connection con = Link.dbTable.getConnection();
            Object object = lock;
            synchronized (object) {
                count = DBTableAdapter.rowCountDb(con, Link.dbTable.getTableName(), sqlClause);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Link get(NetNode from, NetNode to, String fragment, HtmlTag tag) {
        String key = LinkCache.createKey(from.getNodeId(), to.getNodeId(), fragment);
        Link link = null;
        Object object = lock;
        synchronized (object) {
            link = (Link)cache.get(0, key);
            if (link == null) {
                link = new Link(from, to, fragment);
                link.fill(tag);
                cache.put(link);
            }
        }
        return link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Link get(NetNode from, NetNode to, String fragment) {
        String key = LinkCache.createKey(from.getNodeId(), to.getNodeId(), fragment);
        Link link = null;
        Object object = lock;
        synchronized (object) {
            link = (Link)cache.get(0, key);
            if (link == null) {
                link = new Link(from, to, fragment);
                cache.put(link);
            }
        }
        return link;
    }

    public static Link get(NetNode from, NetNode to, String fragment, HtmlTag tag, boolean persistent) {
        Link link = LinkCache.get(from, to, fragment, tag);
        if (link == null) {
            return null;
        }
        if (persistent) {
            link.store();
        } else {
            link.setPersistent(false);
        }
        return link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Link getById(String id) {
        Link link = null;
        Object object = lock;
        synchronized (object) {
            link = (Link)cache.get(0, id);
            if (link == null) {
                link = new Link(id);
                cache.put(link);
            }
        }
        return link;
    }

    public static String createKey(String fromId, String toId, String fragment) {
        return SimpleUri.getHexHashCode("Link:" + fromId + toId + fragment);
    }

    public static void clean() {
        cache.clean();
    }

    static {
        lock = new Object();
    }
}

