/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import com.ibm.wbi.protocol.http.DocumentInfo;
import java.sql.ResultSet;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.SimpleUri;
import scone.netobjects.TableRecord;

public class NetNode
extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    public static DBTableAdapter dbTable = new DBTableAdapter("NetNodeTable");
    protected SimpleUri sUri;

    protected NetNode() {
        dbTable.init(this);
    }

    protected NetNode(SimpleUri sUri) {
        this();
        this.setNodeId(sUri.getHexHashCode());
        dbTable.dbCheck(this);
        if (this.hasRecordInDB) {
            this.sUri = new SimpleUri(this.getUri());
        } else {
            this.sUri = sUri;
            this.setMimeType(sUri.getMimeType());
            this.setUri(sUri);
            this.computeType();
        }
    }

    protected NetNode(String id) {
        this();
        this.fieldValues.put("nodeId", id);
        dbTable.dbCheck(this);
        if (this.hasRecordInDB) {
            this.sUri = new SimpleUri(this.getUri());
        }
    }

    public NetNode(ResultSet results) {
        dbTable.init(this);
        dbTable.fill(this, results);
    }

    public void access() {
        if (this.getAccessCounter() == 0) {
            this.fieldValues.put("firstAccess", String.valueOf(new Date().getTime()));
        }
        this.setLastAccess(new Date().getTime());
        this.incAccessCounter();
    }

    public String getNodeId() {
        return this.fieldValues.get("nodeId");
    }

    private void setNodeId(String id) {
        this.fieldValues.put("nodeId", id);
    }

    public String getUri() {
        return this.fieldValues.get("uri");
    }

    private void setUri(SimpleUri sUri) {
        this.fieldValues.put("uri", sUri.toDocString());
        this.fieldValues.put("host", sUri.getHost());
    }

    public String getSize() {
        return this.fieldValues.get("size");
    }

    public void setSize(String size) {
        if (size.length() == 0) {
            size = "-1";
        }
        this.fieldValues.put("size", size);
    }

    public long getLastModified() {
        return Long.parseLong(this.fieldValues.get("lastModified"));
    }

    public void setLastModifiedString(String lastModifiedString) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        ParsePosition pos = new ParsePosition(0);
        formatter.setTimeZone(TimeZone.getDefault());
        Date lastModified = formatter.parse(lastModifiedString, pos);
        if (lastModified != null) {
            long time = lastModified.getTime();
            this.setLastModified(time);
        }
    }

    public void setLastModified(long time) {
        if (time != 0L) {
            this.fieldValues.put("lastModified", String.valueOf(time));
        }
    }

    public String getMimeType() {
        return this.fieldValues.get("mimeType");
    }

    public void setMimeType(String v) {
        if (this.getMimeType().equals("")) {
            this.fieldValues.put("mimeType", v);
        }
    }

    public String getAccessStatus() {
        return this.fieldValues.get("accessStatus");
    }

    public void setAccessStatus(String v) {
        if (!this.fieldValues.get("accessStatus").equals("-1") || !v.equals("-1")) {
            // empty if block
        }
        this.fieldValues.put("accessStatus", v);
    }

    public int getType() {
        return Integer.parseInt(this.fieldValues.get("type"));
    }

    public void setType(int t) {
        this.fieldValues.put("type", String.valueOf(t));
    }

    public long getFirstAccess() {
        return Long.parseLong(this.fieldValues.get("firstAccess"));
    }

    public long getLastAccess() {
        return Long.parseLong(this.fieldValues.get("lastAccess"));
    }

    protected void setLastAccess(long v) {
        this.fieldValues.put("lastAccess", String.valueOf(v));
    }

    public int getAccessCounter() {
        return Integer.parseInt(this.fieldValues.get("accessCounter"));
    }

    protected void setAccessCounter(int v) {
        this.fieldValues.put("accessCounter", String.valueOf(v));
    }

    protected void incAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    public long getLastRobotAccess() {
        return Long.parseLong(this.fieldValues.get("lastRobotAccess"));
    }

    public void setLastRobotAccess(long v) {
        this.fieldValues.put("lastRobotAccess", String.valueOf(v));
    }

    public SimpleUri getSUri() {
        return this.sUri;
    }

    public void fill(DocumentInfo documentInfo) {
        this.setMimeType(documentInfo.getResponseContentType());
        this.setSize(documentInfo.getResponseContentLength());
        this.setAccessStatus(String.valueOf(documentInfo.getResponseCode()));
        boolean REQUEST_HEADER = false;
        int RESPONSE_HEADER = 1;
        String lastModifiedString = documentInfo.getByKey("Last-Modified", RESPONSE_HEADER);
        if (lastModifiedString != null) {
            this.setLastModifiedString(lastModifiedString);
        }
    }

    public void computeType() {
        int type = 0;
        type = this.sUri.getPath().length() > 0 ? (type |= 1) : (type |= 2);
        type = this.sUri.getFile().length() > 0 ? (type |= 4) : (type |= 8);
        type = this.sUri.getFragment().length() > 0 ? (type |= 0x10) : (type |= 0x20);
        type = this.sUri.getQuery().length() > 0 ? (type |= 0x40) : (type |= 0x80);
        if (this.sUri.getPath().length() == 0 && this.sUri.getFile().length() == 0 && this.sUri.getQuery().length() == 0) {
            type |= 0x400;
        }
        type = this.sUri.getProtocol().equals("http") ? (type |= 0x4000) : (type |= 0x8000);
        type = this.getMimeType().equals("text/html") ? (type |= 0x100000) : (type |= 0x200000);
        if (this.getMimeType().indexOf("text") >= 0) {
            type |= 0x400000;
        }
        if (this.getMimeType().indexOf("image") >= 0) {
            type |= 0x800000;
        }
        this.setType(type);
    }

    public String toDocString() {
        return this.sUri.toDocString();
    }

    public String toHostString() {
        return this.sUri.toHostString();
    }

    public String toString() {
        return this.sUri.toString();
    }

    public String getProtocol() {
        return this.sUri.getProtocol();
    }

    public String getHost() {
        return this.sUri.getHost();
    }

    public String getMainHost() {
        return this.sUri.getMainHost();
    }

    public String getPort() {
        return this.sUri.getPort();
    }

    public String getPath() {
        return this.sUri.getPath();
    }

    public String getFile() {
        return this.sUri.getFile();
    }

    public String getExtension() {
        return this.sUri.getExtension();
    }

    public String getQuery() {
        return this.sUri.getQuery();
    }

    public String getFragment() {
        return this.sUri.getFragment();
    }

    public String getOpaquePart() {
        return this.sUri.getOpaquePart();
    }

    public String getRef() {
        return this.sUri.getRef();
    }

    public void store() {
        if (this.hasRecordInDB) {
            dbTable.updateDB(this);
        } else {
            dbTable.createInDB(this);
        }
    }

    public Object getKey(int keyNo) {
        switch (keyNo) {
            case 0: {
                return this.getNodeId();
            }
            case 1: {
                return this.getUri();
            }
        }
        System.out.println("Error!!!!");
        return "";
    }
}

