/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import com.ibm.wbi.protocol.http.DocumentInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Observer;
import java.util.Vector;
import scone.netobjects.Cache;
import scone.netobjects.CacheTable;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.NetNode;
import scone.netobjects.SimpleUri;
import scone.netobjects.TableRecordCacheInterface;

public class NetNodeCache
extends Cache
implements TableRecordCacheInterface {
    protected static NetNodeCache observable;
    protected static int observePeriod;
    protected static CacheTable cache;
    public static Object lock;

    private NetNodeCache() {
    }

    public static void init(int timeTillCleanUp, int gcType) {
        cache = new CacheTable("NetNodes", 2, timeTillCleanUp, gcType, 50000);
        lock = new Object();
        observePeriod = 4000;
        observable = new NetNodeCache();
    }

    public static void setObservePeriod(int period) {
        observePeriod = period;
    }

    public static int getObservePeriod() {
        return observePeriod;
    }

    public static void putObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void removeObserver(Observer o) {
        observable.deleteObserver(o);
    }

    public static NetNode get(String uriString) {
        SimpleUri suri = new SimpleUri(uriString);
        return NetNodeCache.get(suri);
    }

    public static NetNode get(NetNode base, String link) {
        return NetNodeCache.get(new SimpleUri(base.getSUri(), link));
    }

    public static NetNode get(DocumentInfo documentInfo) {
        SimpleUri suri = new SimpleUri(documentInfo.getUrl());
        NetNode netNode = NetNodeCache.get(suri);
        netNode.fill(documentInfo);
        return netNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetNode get(SimpleUri sUri) {
        NetNode netNode = null;
        try {
            Object object = lock;
            synchronized (object) {
                netNode = (NetNode)cache.get(1, sUri.toDocString());
                if (netNode == null) {
                    netNode = new NetNode(sUri);
                    cache.put(netNode);
                    observable.addItem(netNode);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in NetNode: \nCould not find NetNode in NetNodeCache: " + e.toString());
        }
        return netNode;
    }

    public static NetNode get(SimpleUri sUri, boolean persistent) {
        NetNode netNode = NetNodeCache.get(sUri);
        if (netNode == null) {
            return null;
        }
        if (persistent) {
            netNode.store();
        } else {
            netNode.setPersistent(false);
        }
        return netNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetNode getById(String id) {
        NetNode netNode = null;
        Object object = lock;
        synchronized (object) {
            netNode = (NetNode)cache.get(0, id);
            if (netNode == null) {
                netNode = new NetNode(id);
                if (!netNode.hasRecordInDB) {
                    return null;
                }
                cache.put(netNode);
                observable.addItem(netNode);
            }
        }
        return netNode;
    }

    public static NetNode get(String id, boolean persistent) {
        NetNode netNode = NetNodeCache.getById(id);
        if (netNode == null) {
            return null;
        }
        if (persistent) {
            netNode.store();
        } else {
            netNode.setPersistent(false);
        }
        return netNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getNetNodes(String sqlClause) {
        Connection con = NetNode.dbTable.getConnection();
        Vector<NetNode> netNodes = new Vector<NetNode>();
        boolean i = false;
        Object object = lock;
        synchronized (object) {
            ResultSet results = DBTableAdapter.queryDb(con, NetNode.dbTable.getTableName(), sqlClause);
            while (results != null) {
                NetNode node = new NetNode(results);
                String id = node.getNodeId();
                if (id.length() > 0 && !id.equals("-1")) {
                    if (cache.get(0, id) == null) {
                        cache.put(node);
                    }
                    netNodes.add(node);
                    continue;
                }
                return netNodes;
            }
        }
        return netNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNetNodeCount(String tables, String sqlClause) {
        int count;
        Connection con = NetNode.dbTable.getConnection();
        Object object = lock;
        synchronized (object) {
            count = DBTableAdapter.rowCountDb(con, tables, sqlClause);
        }
        return count;
    }

    public static int getNetNodeCount(String sqlClause) {
        return NetNodeCache.getNetNodeCount(NetNode.dbTable.getTableName(), sqlClause);
    }

    public static void clean() {
        cache.clean();
    }

    static {
        observePeriod = 0;
        lock = new Object();
    }
}

