/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;
import scone.netobjects.Column;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.Table;
import scone.util.ErrorLog;

public class Schema {
    public static final String fileName = "setup/sconedb.sql";
    public static final int STRING = 0;
    public static final int NUMBER = 1;
    public static final int BLOB = 2;
    public static final int GENERATED = 0;
    public static final int KEY = 1;
    public static final int FIELD = 2;
    Hashtable tables = new Hashtable();
    static Schema definitions;

    public static void initialize(DBTableAdapter adapter) {
        Table table = null;
        Object dbTable = null;
        if (definitions == null) {
            definitions = new Schema();
        }
        table = (Table)Schema.definitions.tables.get(adapter.tableName.toLowerCase());
        if (DBTableAdapter.useDb) {
            try {
                if (!Schema.getDefinitionFromDb(adapter.tableName, adapter.con).compareTo(table)) {
                    System.out.println("\n-> Scone: ERROR! --------------------------------------------------");
                    System.out.println(" The schema in setup/sconedb.sql does not correspond with");
                    System.out.println(" the schema found in the database! Database updated required!");
                    adapter.dontUseDb();
                }
            }
            catch (Exception x) {
                ErrorLog.log("this", "Database.initialize()", "Could not read schema from database", x);
                System.out.println("\n-> Scone: ERROR! --------------------------------------------------");
                System.out.println(" Could not read schema from database!");
                adapter.dontUseDb();
            }
        }
        Column col = null;
        adapter.init(table.getSize());
        for (int i = 0; i < table.getSize(); ++i) {
            col = table.get(i);
            adapter.addField(col.name, col.type, col.defValue, col.key);
        }
    }

    public static void main(String[] args) {
        Schema db = new Schema();
    }

    public Schema() {
        this.parseSqlSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Table getDefinitionFromDb(String tableName, Connection con) {
        Table table = new Table(tableName);
        try {
            Connection connection = con;
            synchronized (connection) {
                Statement stmt = con.createStatement();
                ResultSet results = stmt.executeQuery("show columns from " + tableName);
                Column col = null;
                while (results.next()) {
                    col = new Column();
                    col.name = results.getString("Field");
                    col.type = Schema.convertType(results.getString("Type"));
                    col.defValue = results.getString("Default");
                    if (col.defValue == null) {
                        col.defValue = col.type == 1 ? "0" : "";
                    }
                    if (results.getString("Key").toLowerCase().startsWith("mul")) {
                        col.key = 1;
                    }
                    if (results.getString("Key").toLowerCase().startsWith("pri")) {
                        col.key = 1;
                        if (results.getString("Extra").toLowerCase().indexOf("auto_increment") >= 0) {
                            col.key = 0;
                        }
                    }
                    table.add(col);
                }
            }
        }
        catch (Exception x) {
            System.out.println("fatal exception while creating DBTAbleAdapter for " + tableName);
            x.printStackTrace();
            System.exit(0);
        }
        return table;
    }

    public static int convertType(String type) {
        if ((type = type.toLowerCase()).startsWith("tinyint") || type.startsWith("smallint") || type.startsWith("mediumint") || type.startsWith("int") || type.startsWith("bigint")) {
            return 1;
        }
        if (type.startsWith("text") || type.startsWith("char") || type.startsWith("varchar")) {
            return 0;
        }
        if (type.startsWith("blob") || type.startsWith("mediumblob")) {
            return 2;
        }
        System.out.println("-----unknown column type: " + type + " -----------------------");
        System.exit(0);
        return -1;
    }

    public int count(String line, String subject) {
        int c = 0;
        int pos = 0;
        while ((pos = line.indexOf(subject, pos)) >= 0) {
            ++c;
            if (++pos < line.length()) continue;
            break;
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    public void parseSqlSource() {
        try {
            line = null;
            dummy = "";
            st = null;
            tableName = null;
            col = null;
            table = null;
            file = new BufferedReader(new InputStreamReader(new FileInputStream("setup/sconedb.sql")));
            block2: while (true) {
                if ((line = file.readLine()) != null && !line.trim().toLowerCase().startsWith("create table ")) {
                    continue;
                }
                if (line == null) {
                    return;
                }
                if (line.indexOf("#") >= 0) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (line.indexOf(";") >= 0) {
                    line = line.substring(0, line.indexOf(";"));
                }
                line = line.trim();
                st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    line = st.nextToken();
                    if (line.equals("") || line.toLowerCase().equals("create") || line.toLowerCase().equals("table")) continue;
                    tableName = line.toLowerCase();
                    break;
                }
                if (tableName.charAt(tableName.length() - 1) == '(') {
                    tableName = tableName.substring(0, tableName.length() - 1);
                }
                pCount = this.count(line, "(") - this.count(line, ")");
                table = new Table(tableName);
                this.tables.put(tableName, table);
                block4: while (true) {
                    if ((line = file.readLine()) != null && pCount > 0) ** break;
                    continue block2;
                    if (line.length() == 0) continue;
                    if (line.indexOf("#") >= 0) {
                        line = line.substring(0, line.indexOf("#"));
                    }
                    if (line.indexOf(";") >= 0) {
                        line = line.substring(0, line.indexOf(";"));
                    }
                    if ((line = line.trim()).endsWith(",")) {
                        line = line.substring(0, line.length() - 1).trim();
                    }
                    pCount = pCount + this.count(line, "(") - this.count(line, ")");
                    if (line.length() == 0 || line.toLowerCase().startsWith("index ") || line.toLowerCase().startsWith("fulltext ") || line.startsWith(")")) continue;
                    if (pCount == 0) {
                        line = line.substring(0, line.lastIndexOf(")")).trim();
                    }
                    if (line.toLowerCase().startsWith("primary key ") || line.toLowerCase().startsWith("key ") || line.toLowerCase().startsWith("primary key(") || line.toLowerCase().startsWith("key(")) {
                        line = line.substring(line.indexOf("(") + 1, line.indexOf(")")).trim();
                        st = new StringTokenizer(line, ",");
                        block5: while (true) {
                            if (!st.hasMoreTokens()) continue block4;
                            dummy = st.nextToken().trim();
                            if (dummy.length() == 0) continue;
                            i = 0;
                            while (true) {
                                if (i >= table.getSize()) continue block5;
                                if (table.get((int)i).name.equalsIgnoreCase(dummy)) {
                                    if (table.get((int)i).key == 0) continue block5;
                                    table.get((int)i).key = 1;
                                    continue block5;
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    col = new Column();
                    st = new StringTokenizer(line);
                    if (st.hasMoreTokens()) {
                        col.name = st.nextToken();
                    }
                    while (st.hasMoreTokens() && (dummy = st.nextToken()).length() == 0) {
                    }
                    col.type = Schema.convertType(dummy);
                    if (line.toLowerCase().indexOf(" primary ") >= 0) {
                        col.key = 1;
                    }
                    if (line.toLowerCase().indexOf("auto_increment") >= 0) {
                        col.key = 0;
                    }
                    if ((pos = line.toLowerCase().indexOf(" default ")) >= 0 && (line = line.substring(pos + 9, line.length()).trim()).length() > 0) {
                        col.defValue = line.charAt(0) == '\'' || line.charAt(0) == '\"' ? line.substring(1, line.length() - 1) : line;
                    }
                    table.add(col);
                }
                break;
            }
        }
        catch (Exception e) {
            ErrorLog.log(this, "parseSqlSource()", "Could not parse file setup/sconedb.sql.sql", e);
            e.printStackTrace();
            return;
        }
    }
}

