/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.util.Date;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.TableRecord;

public class Server
extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    protected static DBTableAdapter dbTable = new DBTableAdapter("ServerTable");

    public String getTitle() {
        return this.fieldValues.get("title");
    }

    public void setTitle(String v) {
        this.fieldValues.put("title", v);
    }

    public String getDescription() {
        return this.fieldValues.get("description");
    }

    public void setDescription(String v) {
        this.fieldValues.put("description", v);
    }

    public String getDelay() {
        return this.fieldValues.get("delay");
    }

    public void setDelay(String v) {
        this.fieldValues.put("delay", v);
    }

    public void access() {
        if (this.getAccessCounter() == 0) {
            this.fieldValues.put("firstAccess", String.valueOf(new Date().getTime()));
        }
        this.setLastAccess(new Date().getTime());
        this.incAccessCounter();
    }

    public String getHost() {
        return this.fieldValues.get("host");
    }

    public Server(String host) {
        dbTable.init(this);
        this.fieldValues.put("host", host);
        dbTable.dbInit(this);
    }

    public String getAccessStatus() {
        return this.fieldValues.get("accessStatus");
    }

    public void setAccessStatus(String v) {
        if (!this.fieldValues.get("accessStatus").equals("-1") || !v.equals("-1")) {
            // empty if block
        }
        this.fieldValues.put("accessStatus", v);
    }

    public long getFirstAccess() {
        return Long.parseLong(this.fieldValues.get("firstAccess"));
    }

    public long getLastAccess() {
        return Long.parseLong(this.fieldValues.get("lastAccess"));
    }

    protected void setLastAccess(long v) {
        this.fieldValues.put("lastAccess", String.valueOf(v));
    }

    public int getAccessCounter() {
        return Integer.parseInt(this.fieldValues.get("accessCounter"));
    }

    protected void setAccessCounter(int v) {
        this.fieldValues.put("accessCounter", String.valueOf(v));
    }

    protected void incAccessCounter() {
        try {
            this.setAccessCounter(this.getAccessCounter() + 1);
        }
        catch (Exception e) {
            this.setAccessCounter(1);
        }
    }

    public void store() {
        dbTable.updateDB(this);
    }

    public Object getKey(int KeyNo) {
        return this.getHost();
    }
}

