/*
 * Decompiled with CFR 0.152.
 */
package scone.netobjects;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;

public class SimpleUri {
    protected String scheme;
    protected String authority;
    protected String path;
    protected String query;
    protected String fragment;
    protected String opaquePart;
    protected String port;
    protected String file;
    protected String extension;
    protected String originalUriString;
    protected SimpleUri base;
    public static boolean parseNavigatorLike = true;
    protected static Hashtable mimeTypeTable = new Hashtable();

    public static void main(String[] args) {
        System.out.println("base URI");
        SimpleUri uri1 = new SimpleUri(null, "http://a/b/c/d;p?q");
        uri1.print();
        System.out.println("C.1.  Normal Examples");
        new SimpleUri(uri1, "g:h").print();
        new SimpleUri(uri1, "g").print();
        new SimpleUri(uri1, "./g").print();
        new SimpleUri(uri1, "g/").print();
        new SimpleUri(uri1, "/g").print();
        new SimpleUri(uri1, "//g").print();
        new SimpleUri(uri1, "?y").print();
        new SimpleUri(uri1, "g?y").print();
        new SimpleUri(uri1, "#s").print();
        new SimpleUri(uri1, "g#s").print();
        new SimpleUri(uri1, "g?y#s").print();
        new SimpleUri(uri1, ";x").print();
        new SimpleUri(uri1, "g;x").print();
        new SimpleUri(uri1, "g;x?y#s").print();
        new SimpleUri(uri1, ".").print();
        new SimpleUri(uri1, "./").print();
        new SimpleUri(uri1, "..").print();
        new SimpleUri(uri1, "../").print();
        new SimpleUri(uri1, "../g").print();
        new SimpleUri(uri1, "../..").print();
        new SimpleUri(uri1, "../../").print();
        new SimpleUri(uri1, "../../g").print();
        new SimpleUri(uri1, "/../g/").print();
        new SimpleUri(uri1, "/g/../").print();
        System.out.println("\nC.2.   Abnormal Examples");
        new SimpleUri(uri1, "").print();
        new SimpleUri(uri1, "../../../g").print();
        new SimpleUri(uri1, "../../../../g").print();
        new SimpleUri(uri1, "/./g").print();
        new SimpleUri(uri1, "/../g").print();
        new SimpleUri(uri1, "g.").print();
        new SimpleUri(uri1, ".g").print();
        new SimpleUri(uri1, "g..").print();
        new SimpleUri(uri1, "..g").print();
        new SimpleUri(uri1, "./../g").print();
        new SimpleUri(uri1, "./g/.").print();
        new SimpleUri(uri1, "g/./h").print();
        new SimpleUri(uri1, "g/../h").print();
        new SimpleUri(uri1, "g;x=1/./y").print();
        new SimpleUri(uri1, "g;x=1/../y").print();
        new SimpleUri(uri1, "g?y/./x").print();
        new SimpleUri(uri1, "g?y/../x").print();
        new SimpleUri(uri1, "g#s/./x").print();
        new SimpleUri(uri1, "g#s/../x").print();
        new SimpleUri(uri1, "http:g").print();
        new SimpleUri(null, "http://www.scone.de:80/test/index.html?was").print();
        new SimpleUri(null, "http://www.scone.de:81/test/index.html?was").print();
        System.out.println(new SimpleUri(null, "http://www.scone.de:81/test/index.html?was").getMainHost());
        System.out.println(new SimpleUri(null, "http://www.ebay.de/").getMainHost());
        System.out.println(new SimpleUri(null, "http://ebay.de/").getMainHost());
        System.out.println(new SimpleUri(null, "http://search.ebay.de/").getMainHost());
        System.out.println(new SimpleUri(null, "http://xxx.search.ebay.de/").getMainHost());
        System.out.println(new SimpleUri(null, "http://www.ebay.co.uk/").getMainHost());
        System.out.println(new SimpleUri(null, "http://search.ebay.co.uk/").getMainHost());
        System.out.println(new SimpleUri(null, "http://ebay.com.hk/").getMainHost());
        System.out.println(new SimpleUri(null, "http://134.100.11.181/").getMainHost());
        System.out.println(new SimpleUri(null, "com").getMainHost());
    }

    protected void print() {
        System.out.println(this.originalUriString + "      \t = " + this.toString());
    }

    public SimpleUri(SimpleUri base, String uriString) {
        this.reset();
        this.base = base;
        this.originalUriString = uriString;
        this.parseUri();
        this.normalizeHttpUri();
    }

    public SimpleUri(String uriString) {
        this(null, uriString);
    }

    public boolean equals(String uriString) {
        return this.toString().equals(new SimpleUri(uriString).toString());
    }

    public boolean equals(SimpleUri uri) {
        return this.toString().equals(uri.toString());
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOpaquePart() {
        return this.opaquePart;
    }

    public String getOriginalUri() {
        return this.originalUriString;
    }

    public String getUri() {
        return this.toString();
    }

    public String getProtocol() {
        return this.scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.authority;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getMainHost() {
        boolean b = Pattern.matches("[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}", this.authority);
        if (b) {
            return this.authority;
        }
        String mainHost = this.authority;
        String[] temp = null;
        temp = this.authority.split("\\.");
        if (temp.length > 2) {
            int n = temp.length - 2;
            String c = temp[n];
            if (temp.length > 2 && (c.equals("com") || c.equals("co") || c.equals("edu") || c.equals("ac") || c.equals("gov") || c.equals("gv") || c.equals("org") || c.equals("or") || c.equals("mil") || c.equals("net") || c.equals("com"))) {
                --n;
            }
            mainHost = "";
            for (int i = temp.length - 1; i >= n; --i) {
                mainHost = temp[i] + mainHost;
                if (n == i) continue;
                mainHost = "." + mainHost;
            }
        }
        return mainHost;
    }

    public String getPort() {
        return this.port;
    }

    public String getFile() {
        return this.file;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getRef() {
        return this.fragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        String stringRepr = this.toDocString();
        if (this.fragment != null && this.fragment.length() > 0) {
            stringRepr = stringRepr + "#" + this.fragment;
        }
        return stringRepr;
    }

    public String toDocString() {
        String stringRepr = this.toHostString();
        stringRepr = stringRepr + this.path;
        if (this.file != null && this.file.length() > 0) {
            stringRepr = stringRepr + this.file;
        }
        if (this.query != null && this.query.length() > 0) {
            stringRepr = stringRepr + "?" + this.query;
        }
        return stringRepr;
    }

    public URL toURL() {
        try {
            return new URL(this.toString());
        }
        catch (MalformedURLException e) {
            System.out.println("Illegal URL: " + this.toString() + "\n" + e.toString());
            return null;
        }
    }

    public URL toDocURL() {
        try {
            return new URL(this.toDocString());
        }
        catch (MalformedURLException e) {
            System.out.println("Illegal URL: " + this.toString() + "\n" + e.toString());
            return null;
        }
    }

    public String toHostString() {
        String stringRepr = this.scheme + ":";
        if (this.opaquePart != null && this.opaquePart.length() > 0) {
            stringRepr = stringRepr + this.opaquePart;
            return stringRepr;
        }
        if (this.authority != null && this.authority.length() > 0) {
            stringRepr = stringRepr + "//" + this.authority;
        }
        if (this.port != null && this.port.length() > 0) {
            stringRepr = stringRepr + ":" + this.port;
        }
        return stringRepr;
    }

    public String getHexHashCode() {
        return SimpleUri.getHexHashCode(this.toDocString());
    }

    public String getHexHashCodeofHost() {
        return SimpleUri.getHexHashCode(this.toHostString());
    }

    public static String getHexHashCode(String uriString) {
        long h = 0L;
        int len = uriString.length();
        char[] value = new char[len];
        uriString.getChars(0, len, value, 0);
        for (int i = 0; i < len; ++i) {
            h = 137L * h + (long)value[i];
        }
        String hexString = Long.toHexString(h).toUpperCase();
        while (hexString.length() < 16) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public String getMimeType() {
        String mimeType = "";
        mimeType = (String)mimeTypeTable.get(this.extension.toLowerCase());
        if (mimeType == null) {
            mimeType = "";
        }
        return mimeType;
    }

    public static String getMimeTypeFromExtension(String extension) {
        String mimeType = "";
        mimeType = (String)mimeTypeTable.get(extension.toLowerCase());
        if (mimeType == null) {
            mimeType = "";
        }
        return mimeType;
    }

    protected void reset() {
        this.scheme = "";
        this.authority = "";
        this.opaquePart = "";
        this.path = "";
        this.query = "";
        this.fragment = "";
        this.port = "";
        this.file = "";
        this.extension = "";
        this.base = null;
        this.originalUriString = "";
    }

    protected void parseUri() {
        char c;
        int i;
        StringBuffer schemeBuf = new StringBuffer();
        StringBuffer work = new StringBuffer();
        StringBuffer fragBuf = new StringBuffer();
        String s = "";
        int l = this.originalUriString.length();
        for (i = 0; i < l; ++i) {
            c = this.originalUriString.charAt(i);
            if (c == '#') {
                ++i;
                break;
            }
            if (c <= ' ') continue;
            work.append(c);
        }
        s = work.toString();
        while (i < l) {
            c = this.originalUriString.charAt(i);
            if (c > ' ') {
                fragBuf.append(c);
            }
            ++i;
        }
        this.fragment = fragBuf.toString();
        i = 0;
        if (s.toLowerCase().startsWith("uri:")) {
            i += 4;
        }
        l = s.length();
        while (i < l && (c = s.charAt(i)) != '/') {
            if (c == ':') {
                this.scheme = s.substring(0, i).toLowerCase();
                ++i;
                break;
            }
            ++i;
        }
        if (this.scheme.length() == 0) {
            this.parseRelativeUri(s);
        } else {
            this.parseNetPath(s, i);
        }
    }

    protected void parseNetPath(String s, int i) {
        if (s.length() <= i + 2 || !s.substring(i, i + 2).equals("//")) {
            this.opaquePart = s.substring(i);
            return;
        }
        int j = s.indexOf("/", i += 2);
        if (j == -1) {
            this.authority = s.substring(i);
            this.path = "/";
            this.query = "";
        } else {
            this.authority = s.substring(i, j);
            this.findPathAndQuery(s, j);
        }
    }

    protected void parseRelativeUri(String s) {
        if (this.base == null) {
            return;
        }
        int i = 0;
        this.findPathAndQuery(s, i);
        this.scheme = this.base.getScheme();
        this.authority = this.base.getAuthority();
        if (this.path.length() == 0) {
            this.path = this.base.getPath();
            if (this.query.length() == 0 && (!parseNavigatorLike || parseNavigatorLike && this.fragment.length() > 0)) {
                this.path = this.path + this.base.getFile();
            }
            if (this.base.getQuery().length() > 0 && this.query.length() == 0 && !parseNavigatorLike) {
                this.query = this.base.getQuery();
            }
        } else {
            Vector basePath = null;
            basePath = this.path.charAt(0) == '/' ? this.parseBase("/") : this.parseBase(this.base.getPath());
            StringBuffer segBuf = new StringBuffer();
            String segment = "";
            int length = this.path.length();
            for (i = 0; i < length; ++i) {
                char c = this.path.charAt(i);
                segBuf.append(c);
                if (c != '/' && i != length - 1) continue;
                segment = segBuf.toString();
                segBuf.setLength(0);
                if (segment.equals("/")) continue;
                if (segment.equals("..") || segment.equals("../")) {
                    if (basePath.size() <= 0) continue;
                    basePath.setSize(basePath.size() - 1);
                    continue;
                }
                if (segment.equals(".") || segment.equals("./")) continue;
                basePath.addElement(segment);
            }
            this.path = "/";
            Enumeration e = basePath.elements();
            while (e.hasMoreElements()) {
                this.path = this.path + (String)e.nextElement();
            }
        }
    }

    protected Vector parseBase(String path) {
        Vector<String> vec = new Vector<String>();
        StringBuffer store = new StringBuffer();
        int length = path.length();
        for (int i = 1; i < length; ++i) {
            char c = path.charAt(i);
            store.append(c);
            if (c != '/') continue;
            vec.addElement(new String(store));
            store.setLength(0);
        }
        return vec;
    }

    protected void findPathAndQuery(String s, int j) {
        if (j < s.length()) {
            int i = s.indexOf("?", j);
            if (i == -1) {
                this.path = s.substring(j);
                this.query = "";
            } else {
                this.path = s.substring(j, i);
                this.query = i + 1 < s.length() ? s.substring(i + 1) : "";
            }
        }
    }

    protected void normalizeHttpUri() {
        String fs;
        if (!this.scheme.equals("http") || this.opaquePart != null && this.opaquePart.length() > 0) {
            return;
        }
        int i = this.authority.lastIndexOf(58);
        if (i >= 0 && i <= this.authority.length()) {
            this.port = this.authority.substring(i + 1);
        }
        if (i >= 0) {
            this.authority = this.authority.substring(0, i);
        }
        if ((i = this.path.lastIndexOf(47) + 1) >= 1 && i < this.path.length()) {
            this.file = this.path.substring(i);
            this.path = this.path.substring(0, i);
            i = this.file.lastIndexOf(46) + 1;
            if (i >= 1 && i < this.file.length()) {
                this.extension = this.file.substring(i);
            }
        }
        if ((fs = this.file.toLowerCase()).startsWith("index.") || fs.startsWith("welcome.") || fs.startsWith("default.")) {
            this.file = "";
        }
        if (this.scheme.equals("http") && this.port.equals("80")) {
            this.port = "";
        }
    }

    static {
        mimeTypeTable.put(new String("html"), new String("text/html"));
        mimeTypeTable.put(new String("htm"), new String("text/html"));
        mimeTypeTable.put(new String("shtml"), new String("text/html"));
        mimeTypeTable.put(new String("phtml"), new String("text/html"));
        mimeTypeTable.put(new String("pht"), new String("text/html"));
        mimeTypeTable.put(new String("php"), new String("text/html"));
        mimeTypeTable.put(new String("php3"), new String("text/html"));
        mimeTypeTable.put(new String("php4"), new String("text/html"));
        mimeTypeTable.put(new String("asp"), new String("text/html"));
        mimeTypeTable.put(new String("asc"), new String("text/plain"));
        mimeTypeTable.put(new String("txt"), new String("text/plain"));
        mimeTypeTable.put(new String("c"), new String("text/plain"));
        mimeTypeTable.put(new String("cc"), new String("text/plain"));
        mimeTypeTable.put(new String("h"), new String("text/plain"));
        mimeTypeTable.put(new String("hh"), new String("text/plain"));
        mimeTypeTable.put(new String("cpp"), new String("text/plain"));
        mimeTypeTable.put(new String("hpp"), new String("text/plain"));
        mimeTypeTable.put(new String("rtx"), new String("text/richtext"));
        mimeTypeTable.put(new String("css"), new String("text/css"));
        mimeTypeTable.put(new String("tsv"), new String("text/tab-separated-values"));
        mimeTypeTable.put(new String("etx"), new String("text/x-setext"));
        mimeTypeTable.put(new String("sgml"), new String("text/x-sgml"));
        mimeTypeTable.put(new String("sgm"), new String("text/x-sgml"));
        mimeTypeTable.put(new String("vcs"), new String("text/x-vCalendar"));
        mimeTypeTable.put(new String("vcf"), new String("text/x-vCard"));
        mimeTypeTable.put(new String("xml"), new String("text/xml"));
        mimeTypeTable.put(new String("dtd"), new String("text/xml"));
        mimeTypeTable.put(new String("gif"), new String("image/gif"));
        mimeTypeTable.put(new String("jpeg"), new String("image/jpeg"));
        mimeTypeTable.put(new String("jpg"), new String("image/jpeg"));
        mimeTypeTable.put(new String("jpe"), new String("image/jpeg"));
        mimeTypeTable.put(new String("png"), new String("image/png"));
        mimeTypeTable.put(new String("ief"), new String("image/ief"));
        mimeTypeTable.put(new String("tiff"), new String("image/tiff"));
        mimeTypeTable.put(new String("tif"), new String("image/tiff"));
        mimeTypeTable.put(new String("ras"), new String("image/x-cmu-raster"));
        mimeTypeTable.put(new String("pnm"), new String("image/x-portable-anymap"));
        mimeTypeTable.put(new String("pbm"), new String("image/x-portable-bitmap"));
        mimeTypeTable.put(new String("pgm"), new String("image/x-portable-graymap"));
        mimeTypeTable.put(new String("ppm"), new String("image/x-portable-pixmap"));
        mimeTypeTable.put(new String("rgb"), new String("image/x-rgb"));
        mimeTypeTable.put(new String("xbm"), new String("image/x-xbitmap"));
        mimeTypeTable.put(new String("xpm"), new String("image/x-xpixmap"));
        mimeTypeTable.put(new String("xwd"), new String("image/x-xwindowdump"));
        mimeTypeTable.put(new String("bin"), new String("application/octet-stream"));
        mimeTypeTable.put(new String("dms"), new String("application/octet-stream"));
        mimeTypeTable.put(new String("lha"), new String("application/octet-stream"));
        mimeTypeTable.put(new String("lzh"), new String("application/octet-stream"));
        mimeTypeTable.put(new String("class"), new String("application/java-vm"));
        mimeTypeTable.put(new String("jar"), new String("application/java-vm"));
        mimeTypeTable.put(new String("pgp"), new String("application/pgp"));
        mimeTypeTable.put(new String("ai"), new String("application/postscript"));
        mimeTypeTable.put(new String("eps"), new String("application/postscript"));
        mimeTypeTable.put(new String("ps"), new String("application/postscript"));
        mimeTypeTable.put(new String("ppt"), new String("application/powerpoint"));
        mimeTypeTable.put(new String("rtf"), new String("application/rtf"));
        mimeTypeTable.put(new String("xls"), new String("application/excel"));
        mimeTypeTable.put(new String("hqx"), new String("application/mac-binhex40"));
        mimeTypeTable.put(new String("pdf"), new String("application/pdf"));
        mimeTypeTable.put(new String("zip"), new String("application/zip"));
        mimeTypeTable.put(new String("doc"), new String("application/msword"));
        mimeTypeTable.put(new String("dot"), new String("application/msword"));
        mimeTypeTable.put(new String("wrd"), new String("application/msword"));
        mimeTypeTable.put(new String("wp5"), new String("application/wordperfect5.1"));
        mimeTypeTable.put(new String("vcd"), new String("application/x-cdlink"));
        mimeTypeTable.put(new String("z"), new String("application/x-compress"));
        mimeTypeTable.put(new String("cpio"), new String("application/x-cpio"));
        mimeTypeTable.put(new String("csh"), new String("application/x-csh"));
        mimeTypeTable.put(new String("deb"), new String("application/x-debian-package"));
        mimeTypeTable.put(new String("dcr"), new String("application/x-director"));
        mimeTypeTable.put(new String("dir"), new String("application/x-director"));
        mimeTypeTable.put(new String("dxr"), new String("application/x-director"));
        mimeTypeTable.put(new String("swf"), new String("application/x-shockwave-flash"));
        mimeTypeTable.put(new String("spl"), new String("application/futuresplash"));
        mimeTypeTable.put(new String("dvi"), new String("application/x-dvi"));
        mimeTypeTable.put(new String("gtar"), new String("application/x-gtar"));
        mimeTypeTable.put(new String("tgz"), new String("application/x-gtar"));
        mimeTypeTable.put(new String("gz"), new String("application/x-gzip"));
        mimeTypeTable.put(new String("hdf"), new String("application/x-hdf"));
        mimeTypeTable.put(new String("js"), new String("application/x-javascript"));
        mimeTypeTable.put(new String("latex"), new String("application/x-latex"));
        mimeTypeTable.put(new String("mif"), new String("application/x-mif"));
        mimeTypeTable.put(new String("com"), new String("application/x-msdos-program"));
        mimeTypeTable.put(new String("exe"), new String("application/x-msdos-program"));
        mimeTypeTable.put(new String("bat"), new String("application/x-msdos-program"));
        mimeTypeTable.put(new String("nc"), new String("application/x-netcdf"));
        mimeTypeTable.put(new String("cdf"), new String("application/x-netcdf"));
        mimeTypeTable.put(new String("pl"), new String("application/x-perl"));
        mimeTypeTable.put(new String("pm"), new String("application/x-perl"));
        mimeTypeTable.put(new String("sh"), new String("application/x-sh"));
        mimeTypeTable.put(new String("sit"), new String("application/x-stuffit"));
        mimeTypeTable.put(new String("tar"), new String("application/x-tar"));
        mimeTypeTable.put(new String("tcl"), new String("application/x-tcl"));
        mimeTypeTable.put(new String("tex"), new String("application/x-tex"));
        mimeTypeTable.put(new String("texinfo"), new String("application/x-texinfo"));
        mimeTypeTable.put(new String("texi"), new String("application/x-texinfo"));
        mimeTypeTable.put(new String("man"), new String("application/x-troff-man"));
        mimeTypeTable.put(new String("me"), new String("application/x-troff-me"));
        mimeTypeTable.put(new String("ms"), new String("application/x-troff-ms"));
        mimeTypeTable.put(new String("ustar"), new String("application/x-ustar"));
        mimeTypeTable.put(new String("src"), new String("application/x-wais-source"));
        mimeTypeTable.put(new String("au"), new String("audio/basic"));
        mimeTypeTable.put(new String("snd"), new String("audio/basic"));
        mimeTypeTable.put(new String("mid"), new String("audio/midi"));
        mimeTypeTable.put(new String("midi"), new String("audio/midi"));
        mimeTypeTable.put(new String("kar"), new String("audio/midi"));
        mimeTypeTable.put(new String("mpga"), new String("audio/mpeg"));
        mimeTypeTable.put(new String("mp3"), new String("audio/mpeg"));
        mimeTypeTable.put(new String("aif"), new String("audio/x-aiff"));
        mimeTypeTable.put(new String("aifc"), new String("audio/x-aiff"));
        mimeTypeTable.put(new String("aiff"), new String("audio/x-aiff"));
        mimeTypeTable.put(new String("ra"), new String("audio/x-pn-realaudio"));
        mimeTypeTable.put(new String("ram"), new String("audio/x-pn-realaudio"));
        mimeTypeTable.put(new String("wav"), new String("audio/x-wav"));
        mimeTypeTable.put(new String("igs"), new String("model/iges"));
        mimeTypeTable.put(new String("iges"), new String("model/iges"));
        mimeTypeTable.put(new String("msh"), new String("model/mesh"));
        mimeTypeTable.put(new String("mesh"), new String("model/mesh"));
        mimeTypeTable.put(new String("silo"), new String("model/mesh"));
        mimeTypeTable.put(new String("wrl"), new String("model/vrml"));
        mimeTypeTable.put(new String("vrml"), new String("model/vrml"));
        mimeTypeTable.put(new String("dl"), new String("video/dl"));
        mimeTypeTable.put(new String("fli"), new String("video/fli"));
        mimeTypeTable.put(new String("gl"), new String("video/gl"));
        mimeTypeTable.put(new String("mp2"), new String("video/mpeg"));
        mimeTypeTable.put(new String("mpe"), new String("video/mpeg"));
        mimeTypeTable.put(new String("mpeg"), new String("video/mpeg"));
        mimeTypeTable.put(new String("mpg"), new String("video/mpeg"));
        mimeTypeTable.put(new String("qt"), new String("video/quicktime"));
        mimeTypeTable.put(new String("mov"), new String("video/quicktime"));
        mimeTypeTable.put(new String("avi"), new String("video/x-msvideo"));
        mimeTypeTable.put(new String("movie"), new String("video/x-sgi-movie"));
        mimeTypeTable.put(new String("ice"), new String("x-conference/x-cooltalk"));
    }
}

