/*
 * Decompiled with CFR 0.152.
 */
package scone.proxy;

import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.markuplanguage.html.HtmlEditor;
import com.ibm.wbi.markuplanguage.html.HtmlItem;
import com.ibm.wbi.markuplanguage.html.HtmlTag;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpEditor;
import com.ibm.wbi.protocol.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class NewServerResponseEditor
extends HttpEditor {
    private String newServer = null;
    private String newPort = null;
    private String oldServer = null;
    private String oldPort = null;

    public NewServerResponseEditor(String oldServer, String newServer) {
        this.oldServer = oldServer;
        this.newServer = newServer;
    }

    public NewServerResponseEditor(String oldServer, int oldPort, String newServer, int newPort) {
        this(oldServer, newServer);
        this.oldPort = Integer.toString(oldPort);
        this.newPort = Integer.toString(newPort);
    }

    public void handleRequest(RequestEvent requestevent) throws RequestRejectedException, IOException {
        HtmlItem htmlitem;
        DocumentInfo documentinfo = (DocumentInfo)requestevent.getRequestInfo();
        if (!documentinfo.getResponseContentType().equals("text/html")) {
            throw new RequestRejectedException();
        }
        HttpResponse httpresponse = new HttpResponse(documentinfo.getResponseHeader());
        httpresponse.removeContentLength();
        documentinfo.setResponseHeader(httpresponse.produceResponseWithoutContent());
        boolean header = false;
        boolean base = false;
        HtmlEditor htmleditor = new HtmlEditor((InputStream)requestevent.getMegInputStream(), (OutputStream)requestevent.getMegOutputStream());
        while ((htmlitem = htmleditor.nextToken()) != null) {
            if (htmlitem instanceof HtmlTag) {
                HtmlTag htmltag = (HtmlTag)htmlitem;
                String tag = htmltag.getId();
                if (tag.equals("head")) {
                    header = true;
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (tag.equals("/head")) {
                    header = false;
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (header && !base && tag.equals("base")) {
                    String s1 = htmltag.getAttribute("href");
                    if (s1 == null) continue;
                    base = true;
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (tag.equals("img") || tag.equals("frame")) {
                    String s2 = this.rewriteSource(htmltag.getAttribute("src"));
                    if (s2 != null) {
                        htmltag.setAttribute("src", s2);
                    }
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (tag.equals("body") || tag.equals("td") || tag.equals("tr") || tag.equals("th") || tag.equals("table")) {
                    String s3 = this.rewriteSource(htmltag.getAttribute("background"));
                    if (s3 != null) {
                        htmltag.setAttribute("background", s3);
                    }
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (tag.equals("a") || tag.equals("area") || tag.equals("link")) {
                    String s4 = this.rewriteSource(htmltag.getAttribute("href"));
                    if (s4 != null) {
                        htmltag.setAttribute("href", s4);
                    }
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (tag.equals("form")) {
                    String s6 = this.rewriteLink(htmltag.getAttribute("action"));
                    if (s6 != null) {
                        htmltag.setAttribute("action", s6);
                    }
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (tag.equals("meta")) {
                    String s7 = htmltag.getAttribute("content");
                    if (s7 == null) {
                        htmleditor.write((HtmlItem)htmltag);
                        continue;
                    }
                    StringTokenizer stringtokenizer = new StringTokenizer(s7, ";");
                    StringBuffer stringbuffer = new StringBuffer();
                    while (stringtokenizer.hasMoreElements()) {
                        String s11 = stringtokenizer.nextToken().trim();
                        if (s11.length() > 3 && s11.substring(0, 3).equals("url")) {
                            stringbuffer.append("URL=" + this.rewriteLink(s11.substring(4)) + "; ");
                            continue;
                        }
                        stringbuffer.append(s11 + "; ");
                    }
                    htmltag.setAttribute("content", stringbuffer.toString());
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
                if (tag.equals("option")) {
                    String s9 = htmltag.getAttribute("value");
                    if (s9 != null && s9.startsWith("http://")) {
                        htmltag.setAttribute("value", this.rewriteLink(s9));
                    }
                    htmleditor.write((HtmlItem)htmltag);
                    continue;
                }
            }
            htmleditor.writeLastToken();
        }
    }

    public String rewriteLink(String link) {
        if (link == null) {
            return null;
        }
        if (link.startsWith("http://")) {
            String protocol = "http://";
            String rest = link.substring(7);
            System.out.println(rest);
            int serverlen = rest.indexOf("/");
            String server = rest.substring(0, serverlen);
            rest = link.substring(serverlen);
            if (this.oldPort == null) {
                if (server.equals(this.oldServer)) {
                    link = protocol + this.newServer + rest;
                } else if (server.equals(this.oldServer) || server.equals(this.oldServer + ":" + this.oldPort)) {
                    link = protocol + this.newServer + this.newPort + rest;
                }
            }
        }
        return link;
    }

    public String rewriteSource(String source) {
        return this.rewriteLink(source);
    }
}

