/*
 * Decompiled with CFR 0.152.
 */
package scone.proxy;

import com.ibm.wbi.Meg;
import com.ibm.wbi.PluginException;
import com.ibm.wbi.SystemContext;
import com.ibm.wbi.protocol.http.HttpPlugin;
import com.ibm.wbi.protocol.http.beans.FixContentTypeEditor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import scone.Scone;
import scone.proxy.AddPreambleEditor;
import scone.proxy.FixContentTypeEditor2;
import scone.proxy.GeneralResourceGenerator;
import scone.proxy.NoCacheMeg;
import scone.proxy.PageTimeoutMeg;
import scone.proxy.ParsingMeg;
import scone.proxy.PostDataExtractor;
import scone.ras.RasServer;
import scone.util.BrowserControl;
import scone.util.ErrorLog;
import scone.util.PersistentProperties;
import scone.util.PluginRepository;
import scone.util.PluginRepositoryEntry;

public class Proxy
extends HttpPlugin {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    private static GeneralResourceGenerator generalResourceGenerator = null;
    protected static SystemContext systemContext;
    protected static Hashtable rasServers;
    private int requirements;
    private PluginRepository plugins = null;

    public void initialize() {
        try {
            this.plugins = Scone.plugins;
            this.requirements = this.plugins.getRequirements();
            systemContext = this.getSystemContext();
            FixContentTypeEditor fixContentTypeEditor = new FixContentTypeEditor();
            fixContentTypeEditor.setup("Fix Content Type Editor for GIFs", "!host=null & content-type=text/html", 100);
            this.addMeg((Meg)fixContentTypeEditor);
            FixContentTypeEditor2 fixContentTypeEditor2 = new FixContentTypeEditor2();
            fixContentTypeEditor2.setup("Fix Content Type Editor2 for CSS and JS", "!host=null & content-type=text/html", 100);
            this.addMeg((Meg)fixContentTypeEditor2);
            this.meetRequirements();
            this.initPlugins();
            this.startRas();
            System.out.println("-> Scone initialization completed.");
        }
        catch (Exception exc) {
            ErrorLog.log((Object)this, "initialize()", "Fatal Error!", exc);
        }
        System.out.print("WBI: ");
    }

    public static void addVirtualPath(String web, String fileSystem) {
        GeneralResourceGenerator.addPath(web, fileSystem);
    }

    protected boolean isRequired(int requirement) {
        return (this.requirements & requirement) == requirement;
    }

    private void meetRequirements() {
        PersistentProperties props = new PersistentProperties("config/scone/accesstracking.xml");
        System.out.println("-> Scone requirements : " + Integer.toBinaryString(this.requirements));
        if (this.isRequired(0x2000000) && !this.isRequired(0x1120000)) {
            this.plugins.register("scone.accesstracking2.AccessTracking");
            this.requirements |= this.plugins.getRequirements();
            System.out.println("-> AccessTacking2     : enabled");
        }
        if (this.isRequired(0x1120000)) {
            this.plugins.register("scone.accesstracking.AccessTracking");
            this.requirements |= this.plugins.getRequirements();
            System.out.println("-> AccessTracking     : enabled");
        }
        if (this.isRequired(0x2000000) || this.isRequired(0x1120000)) {
            if (props.get("Disable user handling").equals("true")) {
                System.out.println("-> UserHandling       : disabled");
            } else {
                if (this.isRequired(0x2000000) && !this.isRequired(0x1120000)) {
                    this.plugins.register("scone.accesstracking2.UserHandling");
                } else if (this.isRequired(0x1120000)) {
                    this.plugins.register("scone.accesstracking.UserHandling");
                }
                System.out.println("-> UserHandling       : enabled");
            }
            try {
                System.out.print("   Trying to clear IE cache... ");
                BrowserControl.ClearIECache();
                System.out.println("OK");
            }
            catch (IOException e) {
                System.out.println("Failed");
                e.printStackTrace();
            }
        }
        if (this.isRequired(262144)) {
            NoCacheMeg ncm = new NoCacheMeg();
            ncm.setup("NoCacheMeg", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 95);
            this.addMeg((Meg)ncm);
            System.out.println("-> Scone: NoCacheMeg installed.");
        }
        if (this.isRequired(524288)) {
            PageTimeoutMeg ptm = new PageTimeoutMeg();
            ptm.setup("PageTimeoutMeg", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 1);
            this.addMeg((Meg)ptm);
            System.out.println("-> Scone: PageTimeoutMeg installed.");
        }
        if (this.isRequired(0x100000)) {
            PostDataExtractor pde = new PostDataExtractor();
            pde.setup("Scone PostDataExtractor", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de", 90);
            this.addMeg((Meg)pde);
            ParsingMeg pm = new ParsingMeg(this.requirements);
            pm.setup("Scone ParsingMeg", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 85);
            this.addMeg((Meg)pm);
            System.out.println("-> Scone: PostDataExtractor and ParsingMeg installed.");
        }
        if (this.isRequired(65536)) {
            AddPreambleEditor ape = new AddPreambleEditor();
            ape.setup("AddPreambleEditor", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 50);
            this.addMeg((Meg)ape);
            System.out.println("-> Scone: AddPreambleEditor installed.");
        }
        if (this.isRequired(131072)) {
            generalResourceGenerator = new GeneralResourceGenerator();
            generalResourceGenerator.setup("GeneralResourceGenerator", "%true%", 5);
            this.addMeg((Meg)generalResourceGenerator);
            System.out.println("-> Scone: GeneralResourceGenerator installed.");
        }
    }

    private void initPlugins() {
        Enumeration e = this.plugins.getEntries();
        while (e.hasMoreElements()) {
            PluginRepositoryEntry entry = (PluginRepositoryEntry)e.nextElement();
            if (!entry.isEnabled() || entry.getPlugin() == null) continue;
            System.out.print("-> Scone: plugin " + entry.getName() + "...");
            entry.getPlugin().init(this);
            entry.getPlugin().init();
            System.out.println("installed.");
        }
    }

    private void startRas() {
        Enumeration e = this.plugins.getEntries();
        while (e.hasMoreElements()) {
            PluginRepositoryEntry entry = (PluginRepositoryEntry)e.nextElement();
            if (!entry.isEnabled() || entry.getPlugin() == null || (entry.getPlugin().getRequirements() | 0x100000) <= 0) continue;
            try {
                int rasPort = entry.getPlugin().getRasPort();
                if (rasPort <= 0 || rasServers.get(String.valueOf(rasPort)) != null) continue;
                RasServer ras = new RasServer(rasPort);
                ras.start();
                System.out.println("-> Scone: RAS at port " + entry.getPlugin().getRasPort() + " started.");
                rasServers.put(String.valueOf(rasPort), ras);
            }
            catch (Exception ex) {
                System.out.println("-> Scone: RAS-Server NOT Started! See error log!");
                ErrorLog.log((Object)this, "meetRequirements()", "Could not start RAS.", ex);
            }
        }
    }

    public void terminate() throws PluginException {
        System.out.println("\n-> Scone: Terminating RAS-Servers...");
        Enumeration e = rasServers.elements();
        while (e.hasMoreElements()) {
            RasServer ras = (RasServer)e.nextElement();
            ras.shutdown();
            Object var2_2 = null;
        }
        Scone.terminate();
        super.terminate();
        System.out.println("\n-> Scone: shutdown complete. CU!");
    }

    static {
        rasServers = new Hashtable();
    }
}

