/*
 * Decompiled with CFR 0.152.
 */
package scone.proxy;

import com.ibm.wbi.Meg;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpRequestEditor;
import com.ibm.wbi.protocol.http.HttpRequestHeader;
import com.ibm.wbi.protocol.http.HttpResponseHeader;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import scone.Plugin;
import scone.proxy.HtmlTokenEditor;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;

public class ServerSide
extends Plugin {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    String myName = null;
    String myPortString = "0";
    int myPort = 0;
    String remoteName = null;
    String remotePortString = "0";
    int remotePort = 0;
    int requestPriority = 0;
    int responsePriority = 0;
    Hashtable ignoreExtensions = new Hashtable();
    Hashtable ignoreTags = new Hashtable();

    public int getRequirements() {
        return 0;
    }

    public void init() {
        try {
            String dummy = this.getProperties().get("Ignore these types").toLowerCase();
            StringTokenizer st = new StringTokenizer(dummy);
            while (st.hasMoreTokens()) {
                this.ignoreExtensions.put(st.nextToken(), "i");
            }
            dummy = this.getProperties().get("Ignore these tags").toLowerCase();
            st = new StringTokenizer(dummy);
            while (st.hasMoreTokens()) {
                this.ignoreTags.put(st.nextToken(), "i");
            }
            this.myName = this.getProperties().get("local host");
            this.myPortString = this.getProperties().get("local port");
            this.myPort = Integer.parseInt(this.myPortString);
            this.remoteName = this.getProperties().get("remote host");
            this.remotePortString = this.getProperties().get("remote port");
            this.remotePort = Integer.parseInt(this.remotePortString);
            this.requestPriority = Integer.parseInt(this.getProperties().get("Request Editor Priority"));
            this.responsePriority = Integer.parseInt(this.getProperties().get("Response Editor Priority"));
            RewriteRequestEditor rewriteRequestEditor = new RewriteRequestEditor();
            rewriteRequestEditor.setup("ServerSideRewriteRequestEditor", "%true%", this.requestPriority);
            this.addMeg((Meg)rewriteRequestEditor);
            RewriteResponseEditor rewriteResponseEditor = new RewriteResponseEditor();
            rewriteResponseEditor.setup("ServerSideRewriteResponseEditor ", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", this.responsePriority);
            this.addMeg((Meg)rewriteResponseEditor);
        }
        catch (Exception exc) {
            System.err.println(exc);
        }
    }

    class RewriteResponseEditor
    extends HtmlTokenEditor {
        Vector atts = new Vector();

        public RewriteResponseEditor() {
            this.atts.addElement("href");
            this.atts.addElement("src");
            this.atts.addElement("background");
            this.atts.addElement("action");
            this.atts.addElement("lowsrc");
            this.atts.addElement("data");
        }

        public void handleRequest(SconePipe pipe) {
            HttpRequestHeader httpRequest;
            DocumentInfo documentInfo = (DocumentInfo)pipe.getRequestEvent().getRequestInfo();
            HttpResponseHeader httpResponse = documentInfo.getHttpResponseHeader();
            String reloc = this.rewriteUrl(httpResponse.get("location"));
            if (reloc != null) {
                httpResponse.set("location", reloc);
            }
            if ((reloc = this.rewriteUrl((httpRequest = documentInfo.getHttpRequestHeader()).getUrl())) != null) {
                httpRequest.setUrl(reloc);
            }
            Token token = null;
            HtmlTagToken htmlTag = null;
            String url = null;
            String tag = null;
            try {
                TokenInputStream in = pipe.getTokenInputStream();
                TokenOutputStream out = pipe.getTokenOutputStream();
                while ((token = in.read()) != null) {
                    if (token instanceof HtmlTagToken && ServerSide.this.ignoreTags.get(tag = (htmlTag = (HtmlTagToken)token).getTagString().toLowerCase()) == null) {
                        String value;
                        String content;
                        url = this.rewriteUrl(htmlTag.getParam("href"));
                        if (url != null) {
                            htmlTag.setParam("href", url);
                        }
                        if ((url = this.rewriteUrl(htmlTag.getParam("src"))) != null) {
                            htmlTag.setParam("src", url);
                        }
                        if ((url = this.rewriteUrl(htmlTag.getParam("background"))) != null) {
                            htmlTag.setParam("background", url);
                        }
                        if ((url = this.rewriteUrl(htmlTag.getParam("action"))) != null) {
                            htmlTag.setParam("action", url);
                        }
                        if (tag.equals("meta") && (content = htmlTag.getParam("content")) != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(content, ";");
                            StringBuffer stringBuffer = new StringBuffer();
                            while (stringTokenizer.hasMoreElements()) {
                                url = stringTokenizer.nextToken().trim();
                                if (url.length() > 3 && url.substring(0, 3).toLowerCase().equals("url")) {
                                    stringBuffer.append("URL=" + this.rewriteUrl(url.substring(4)) + "; ");
                                    continue;
                                }
                                stringBuffer.append(url + "; ");
                            }
                            htmlTag.setParam("content", stringBuffer.toString());
                        }
                        if (tag.equals("option") && (value = htmlTag.getParam("value")) != null && value.startsWith("http://")) {
                            htmlTag.setParam("value", this.rewriteUrl(value));
                        }
                    }
                    out.write(token);
                }
                in.close();
                out.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        public String rewriteUrl(String url) {
            if (url == null) {
                return null;
            }
            if (url.startsWith("http://")) {
                String protocol = "http://";
                String server = null;
                String rest = url.substring(7);
                int serverlen = rest.indexOf("/");
                if (serverlen == -1) {
                    server = rest;
                    rest = "/";
                } else {
                    server = rest.substring(0, serverlen);
                    rest = rest.substring(serverlen);
                }
                if (ServerSide.this.remotePort == 0) {
                    if (server.equals(ServerSide.this.remoteName) || server.equals(ServerSide.this.remoteName + ":80")) {
                        url = protocol + ServerSide.this.myName + rest;
                    }
                } else if (server.equals(ServerSide.this.remoteName) || server.equals(ServerSide.this.remoteName + ":" + ServerSide.this.remotePort)) {
                    url = protocol + ServerSide.this.myName + ":" + ServerSide.this.myPort + rest;
                }
            } else {
                return null;
            }
            return url;
        }
    }

    class RewriteRequestEditor
    extends HttpRequestEditor {
        RewriteRequestEditor() {
        }

        public void handleRequest(RequestEvent requestEvent) throws RequestRejectedException, IOException {
            if (ServerSide.this.remoteName == null || ServerSide.this.remoteName.length() == 0) {
                throw new RequestRejectedException();
            }
            DocumentInfo documentInfo = (DocumentInfo)requestEvent.getRequestInfo();
            HttpRequestHeader httpRequest = documentInfo.getHttpRequestHeader();
            String requestUrl = httpRequest.getUrl();
            if (!requestUrl.startsWith("http://") && httpRequest.get("Host") != null) {
                requestUrl = "http://" + httpRequest.get("Host") + requestUrl;
            }
            try {
                URL reqUrl = new URL(requestUrl);
                if (!reqUrl.getHost().equals(ServerSide.this.myName) || ServerSide.this.myPort != 0 && ServerSide.this.myPort != reqUrl.getPort()) {
                    throw new RequestRejectedException();
                }
                if (reqUrl.getFile().startsWith("/_wbi")) {
                    throw new RequestRejectedException();
                }
                URL newUrl = null;
                newUrl = ServerSide.this.remotePort == 0 ? new URL(reqUrl.getProtocol(), ServerSide.this.remoteName, reqUrl.getPort(), reqUrl.getFile() + (reqUrl.getRef() != null ? "#" + reqUrl.getRef() : "")) : new URL(reqUrl.getProtocol(), ServerSide.this.remoteName, ServerSide.this.remotePort, reqUrl.getFile() + (reqUrl.getRef() != null ? "#" + reqUrl.getRef() : ""));
                httpRequest.setUrl(newUrl.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

