/*
 * Decompiled with CFR 0.152.
 */
package scone.ras;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class Connection {
    public static String CON_DEDICATED = "con_dedicated ";
    public static String CON_SINGLETON = "con_singleton ";
    public static String OPEN_DEDICATED = "open_dedicated ";
    public static String CLOSE_DEDICATED = "close_dedicated";
    public static String SLEEP = "sleep";
    Socket socket;
    DataInputStream in;
    DataOutputStream out;
    String server;
    int port;
    String className;
    int handlerId = -1;
    boolean dedicated = false;

    public boolean isClosed() {
        return this.socket == null;
    }

    public Connection(Socket socket, boolean dedicated) throws IOException {
        this.socket = socket;
        this.in = new DataInputStream(socket.getInputStream());
        this.out = new DataOutputStream(socket.getOutputStream());
        this.dedicated = dedicated;
    }

    public Connection(String server, int port, String className) throws IOException {
        this.server = server;
        this.port = port;
        this.className = className;
    }

    public Connection(String server, int port, String className, boolean dedicated) throws IOException {
        this.server = server;
        this.port = port;
        this.className = className;
        this.dedicated = dedicated;
    }

    public synchronized void wake(Socket socket) throws IOException {
        if (this.isClosed()) {
            this.socket = socket;
            this.in = new DataInputStream(socket.getInputStream());
            this.out = new DataOutputStream(socket.getOutputStream());
        }
        this.notifyAll();
    }

    public void wake() throws IOException {
        if (this.isClosed()) {
            this.socket = new Socket(this.server, this.port);
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            if (!this.dedicated) {
                this.write(CON_SINGLETON + this.className);
            } else if (this.handlerId != -1) {
                this.write(CON_DEDICATED + this.handlerId + " " + this.className);
            } else {
                this.write(OPEN_DEDICATED + this.className);
                this.handlerId = Integer.parseInt(this.read().trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep() throws IOException {
        this.write(SLEEP);
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (NullPointerException e) {
            System.err.println("NullPointerException in Connection: sleep");
            e.printStackTrace();
        }
        finally {
            this.socket = null;
            this.in = null;
            this.out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.dedicated && !this.isClosed()) {
                this.write(CLOSE_DEDICATED);
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (NullPointerException e) {
            System.err.println("NullPointerException in Connection: close");
            e.printStackTrace();
        }
        finally {
            this.socket = null;
            this.in = null;
            this.out = null;
        }
    }

    public synchronized String read() throws IOException {
        String line;
        if (this.dedicated && this.isClosed()) {
            try {
                while (this.isClosed()) {
                    this.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((line = this.in.readUTF()).trim().equals(SLEEP)) {
            this.close();
            try {
                while (this.isClosed()) {
                    this.wait();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.read();
        }
        if (line.trim().equals(CLOSE_DEDICATED)) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return line;
    }

    public void write(String line) throws IOException {
        this.out.writeUTF(line);
    }
}

