/*
 * Decompiled with CFR 0.152.
 */
package scone.ras;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import scone.ras.Connection;
import scone.ras.ConnectionHandler;
import scone.ras.RasHandler;
import scone.util.ThreadPool;

public class RasServer
extends Thread {
    public static String CON_DEDICATED = Connection.CON_DEDICATED;
    public static String CON_SINGLETON = Connection.CON_SINGLETON;
    public static String OPEN_DEDICATED = Connection.OPEN_DEDICATED;
    public static String CLOSE_DEDICATED = Connection.CLOSE_DEDICATED;
    Hashtable handlers = new Hashtable();
    Hashtable dedicated = new Hashtable();
    ServerSocket server;
    ThreadPool pool;
    boolean shutdown = false;
    int port = 0;
    int lastId = 0;

    public RasServer(int port) throws IOException {
        this.port = port;
        this.server = new ServerSocket(port);
        this.pool = new ThreadPool();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.pool.close();
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            String request = null;
            while (!this.shutdown) {
                try {
                    Socket client = this.server.accept();
                    request = new DataInputStream(client.getInputStream()).readUTF();
                    if (request.startsWith(CON_SINGLETON)) {
                        RasHandler h = new RasHandler(client, this.getHandler(request.substring(CON_SINGLETON.length()).trim()), false);
                        this.pool.execute(h);
                        continue;
                    }
                    if (request.startsWith(OPEN_DEDICATED)) {
                        RasHandler h = this.getRasHandler(client, request.substring(OPEN_DEDICATED.length()).trim(), this.lastId++);
                        this.pool.execute(h);
                        continue;
                    }
                    if (request.startsWith(CON_DEDICATED)) {
                        int pos = request.indexOf(" ");
                        int pos2 = request.indexOf(" ", pos + 1);
                        int id = Integer.parseInt(request.substring(pos, pos2).trim());
                        RasHandler h = this.getRasHandler(client, request.substring(pos2).trim(), id);
                        continue;
                    }
                    System.err.println("-> Scone: RAS: Illegal request, connection will be closed!");
                    System.err.println("illegal request was: " + request);
                    client.close();
                }
                catch (SocketException se) {
                    if (this.shutdown) {
                        return;
                    }
                    se.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.shutdown) continue;
                    return;
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    void addHandler(String className) {
        try {
            this.handlers.put(className, Class.forName(className).newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    RasHandler addRasHandler(Socket client, String className, int id) {
        RasHandler handler = null;
        try {
            handler = new RasHandler(client, (ConnectionHandler)Class.forName(className).newInstance(), true);
            handler.connection.write("" + id);
            this.dedicated.put(className + "/" + id, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handler;
    }

    ConnectionHandler getHandler(String className) {
        ConnectionHandler handler = (ConnectionHandler)this.handlers.get(className);
        if (handler == null) {
            this.addHandler(className);
            handler = (ConnectionHandler)this.handlers.get(className);
        }
        return handler;
    }

    RasHandler getRasHandler(Socket client, String className, int id) {
        RasHandler handler = (RasHandler)this.dedicated.get(className + "/" + id);
        if (handler == null) {
            handler = this.addRasHandler(client, className, id);
        } else {
            handler.changeClient(client);
        }
        return handler;
    }
}

