/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import scone.netobjects.SimpleUri;
import scone.robot.Robot;

class DefaultFilter {
    private int restriction;
    private boolean headOnly;
    private SimpleUri startUri;
    private Robot robot;

    DefaultFilter(int restriction, SimpleUri startUri) {
        this.restriction = restriction;
        this.startUri = startUri;
        this.headOnly = false;
    }

    void setHeadOnly(boolean b) {
        this.headOnly = b;
    }

    boolean filter(SimpleUri uri) {
        String urlText = uri.getUri();
        urlText = urlText.toLowerCase();
        String datei = uri.getFile();
        datei = datei.toLowerCase();
        if (urlText.indexOf("mailto") != -1) {
            return false;
        }
        if (urlText.indexOf("javascript") != -1) {
            return false;
        }
        this.robot = Robot.instance();
        if (!this.headOnly && !this.robot.isValidFileExtension(datei)) {
            return false;
        }
        if (!uri.getProtocol().equalsIgnoreCase("http")) {
            return false;
        }
        if (this.restriction == 1 && !uri.getHost().equals(this.startUri.getHost())) {
            return false;
        }
        if (!(this.restriction != 2 || uri.getHost().equals(this.startUri.getHost()) && uri.getPath().startsWith(this.startUri.getPath()))) {
            return false;
        }
        if (this.restriction == 3) {
            if (uri.equals(this.startUri)) {
                return true;
            }
            if (uri.getHost().equals(this.startUri.getHost())) {
                return false;
            }
        }
        return true;
    }
}

