/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import scone.robot.GenericURLQueue;
import scone.robot.QueueEntry;
import scone.robot.RobotTask;

public class FairBreadthSearchURLQueue
extends GenericURLQueue {
    protected Ring ring = new Ring();

    public synchronized QueueEntry dequeue() {
        RobotTask r = (RobotTask)this.ring.getNext();
        QueueEntry qe = null;
        for (int i = 0; i < this.queue.size(); ++i) {
            qe = (QueueEntry)this.queue.elementAt(i);
            if (qe.getRobotTask() != r) continue;
            this.queue.removeElementAt(i);
            if (this.getNumberOfPendingQueueEntries(qe.getRobotTask()) == 0) {
                this.ring.remove(qe.getRobotTask());
            }
            --this.numberOfElements;
            return qe;
        }
        return null;
    }

    public synchronized void removeAllQueueEntries(RobotTask robotTask) {
        super.removeAllQueueEntries(robotTask);
        this.ring.remove(robotTask);
    }

    public synchronized void removeQueueEntry(QueueEntry qe) {
        super.removeQueueEntry(qe);
        if (this.getNumberOfPendingQueueEntries(qe.getRobotTask()) == 0) {
            this.ring.remove(qe.getRobotTask());
        }
    }

    private class Ring {
        private RingElement nextElement;
        private RingElement lastElement;

        private Ring() {
        }

        synchronized void add(Object object) {
            boolean found = false;
            if (this.lastElement != null) {
                RingElement rStart;
                RingElement re = rStart = this.lastElement.getNext();
                do {
                    if (re.getObject() == object) {
                        found = true;
                        continue;
                    }
                    re = re.getNext();
                } while (!found && re != rStart);
                if (!found) {
                    RingElement r = new RingElement(object);
                    r.setNext(this.lastElement.getNext());
                    this.lastElement.setNext(r);
                    this.lastElement = r;
                }
            } else {
                RingElement r;
                this.lastElement = r = new RingElement(object);
                this.lastElement.setNext(r);
                this.nextElement = r;
            }
        }

        synchronized void remove(Object object) {
            if (this.lastElement != null) {
                RingElement rStart;
                RingElement r = rStart = this.lastElement.getNext();
                RingElement rp = this.lastElement;
                do {
                    if (r.getObject() == object) {
                        if (rp != r) {
                            if (r == this.nextElement) {
                                this.nextElement = r.getNext();
                            }
                            if (r == this.lastElement) {
                                this.lastElement = r.getNext();
                            }
                            rp.setNext(r.getNext());
                            r = r.getNext();
                            continue;
                        }
                        this.lastElement = null;
                        this.nextElement = null;
                        continue;
                    }
                    rp = r;
                    r = r.getNext();
                } while (this.lastElement != null && r != rStart);
            }
        }

        synchronized Object getNext() {
            if (this.nextElement != null) {
                Object o = this.nextElement.getObject();
                this.nextElement = this.nextElement.getNext();
                return o;
            }
            return null;
        }
    }

    private class RingElement {
        private Object object;
        private RingElement nextElement;

        RingElement(Object object) {
            this.object = object;
        }

        Object getObject() {
            return this.object;
        }

        RingElement getNext() {
            return this.nextElement;
        }

        void setNext(RingElement r) {
            this.nextElement = r;
        }
    }
}

