/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import java.util.Enumeration;
import java.util.Vector;
import scone.netobjects.SimpleUri;
import scone.robot.QueueEntry;
import scone.robot.RobotTask;
import scone.robot.URLQueue;

public abstract class GenericURLQueue
implements URLQueue {
    protected Vector queue = new Vector();
    protected int numberOfElements = 0;

    public synchronized void queue(QueueEntry qe) {
        this.queue.add(qe);
        ++this.numberOfElements;
    }

    public synchronized int size() {
        return this.queue.size();
    }

    public synchronized int getNumberOfPendingQueueEntries(RobotTask robotTask) {
        int numberOfPendingQueueEntries = 0;
        Enumeration queueEntries = this.queue.elements();
        while (queueEntries.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)queueEntries.nextElement();
            RobotTask rt = qe.getRobotTask();
            if (!rt.equals(robotTask)) continue;
            ++numberOfPendingQueueEntries;
        }
        return numberOfPendingQueueEntries;
    }

    public synchronized Vector getPendingQueueEntries(RobotTask robotTask) {
        Vector<QueueEntry> pendingQueueEntries = new Vector<QueueEntry>();
        Enumeration queueEntries = this.queue.elements();
        while (queueEntries.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)queueEntries.nextElement();
            RobotTask rt = qe.getRobotTask();
            if (!rt.equals(robotTask)) continue;
            pendingQueueEntries.add(qe);
        }
        return pendingQueueEntries;
    }

    public synchronized void removeAllQueueEntries(RobotTask robotTask) {
        Vector pendingQueueEntries = this.getPendingQueueEntries(robotTask);
        Enumeration queueEntries = pendingQueueEntries.elements();
        while (queueEntries.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)queueEntries.nextElement();
            this.queue.remove(qe);
        }
    }

    public synchronized int getNumberOfPendingQueueEntries(SimpleUri uri) {
        int numberOfPendingQueueEntries = 0;
        Enumeration queueEntries = this.queue.elements();
        while (queueEntries.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)queueEntries.nextElement();
            SimpleUri link = qe.getURI();
            if (!link.equals(uri)) continue;
            ++numberOfPendingQueueEntries;
        }
        return numberOfPendingQueueEntries;
    }

    public synchronized Vector getPendingQueueEntries(SimpleUri uri) {
        Vector<QueueEntry> pendingQueueEntries = new Vector<QueueEntry>();
        Enumeration queueEntries = this.queue.elements();
        while (queueEntries.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)queueEntries.nextElement();
            SimpleUri link = qe.getURI();
            if (!link.equals(uri)) continue;
            pendingQueueEntries.add(qe);
        }
        return pendingQueueEntries;
    }

    public synchronized boolean isPendingURL(SimpleUri uri, RobotTask robotTask) {
        Enumeration queueEntries = this.queue.elements();
        while (queueEntries.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)queueEntries.nextElement();
            SimpleUri link = qe.getURI();
            if (!link.equals(uri) || !qe.getRobotTask().equals(robotTask)) continue;
            return true;
        }
        return false;
    }

    public synchronized QueueEntry getPendingURL(SimpleUri uri, RobotTask robotTask) {
        Enumeration queueEntries = this.queue.elements();
        while (queueEntries.hasMoreElements()) {
            QueueEntry qe = (QueueEntry)queueEntries.nextElement();
            SimpleUri link = qe.getURI();
            if (!link.equals(uri) || !qe.getRobotTask().equals(robotTask)) continue;
            return qe;
        }
        return null;
    }

    public synchronized void removeQueueEntry(QueueEntry qe) {
        this.queue.remove(qe);
    }
}

