/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import HTTPClient.HTTPConnection;
import HTTPClient.ParseException;
import HTTPClient.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import scone.robot.RobotHttpConnection;

class HttpConnectionPool {
    private Vector connections = new Vector();
    private int maxConnections;

    HttpConnectionPool(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    synchronized RobotHttpConnection getHttpConnection(URL url) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (ParseException ex) {
            System.out.println("HttpConnectionPool: invalid url");
        }
        Enumeration connection = this.connections.elements();
        PoolHttpConnection con = null;
        while (connection.hasMoreElements()) {
            con = (PoolHttpConnection)((Object)connection.nextElement());
            if (con.isUsed() || !con.isCompatibleWith(uri)) continue;
            con.setUsed();
            return con;
        }
        if (this.connections.size() > this.maxConnections) {
            this.removeUnusedConnections();
        }
        String host = url.getHost();
        int port = url.getPort();
        con = new PoolHttpConnection(host, port);
        this.connections.add(con);
        con.setUsed();
        return con;
    }

    private synchronized void removeUnusedConnections() {
        Enumeration connection = this.connections.elements();
        while (connection.hasMoreElements()) {
            PoolHttpConnection con = (PoolHttpConnection)((Object)connection.nextElement());
            if (con.isUsed()) continue;
            con.stop();
            this.connections.removeElement((Object)con);
        }
    }

    synchronized void returnHttpConnection(HTTPConnection con) {
        ((PoolHttpConnection)con).setUnused();
    }

    private class PoolHttpConnection
    extends RobotHttpConnection {
        private boolean used = false;

        PoolHttpConnection(String host, int port) {
            super(host, port);
            this.uses = 0;
        }

        synchronized void setUsed() {
            this.used = true;
            if (this.uses < 2) {
                ++this.uses;
            }
        }

        synchronized void setUnused() {
            this.used = false;
        }

        synchronized boolean isUsed() {
            return this.used;
        }
    }
}

