/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import scone.util.ErrorLog;

class LimitedInputStream
extends FilterInputStream {
    private int counter = 0;
    private int limit = -1;
    private boolean limitReached = false;

    public LimitedInputStream(InputStream in) {
        super(in);
    }

    public LimitedInputStream(InputStream in, int limit) {
        super(in);
        this.limit = limit;
    }

    public int read() throws IOException {
        if (this.counter >= this.limit) {
            this.limitReached = true;
            return -1;
        }
        int b = this.in.read();
        if (b != -1) {
            ++this.counter;
        }
        return b;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.counter >= this.limit) {
            this.limitReached = true;
            return -1;
        }
        if (this.counter + length > this.limit) {
            length = this.limit - this.counter;
        }
        try {
            int bytesRead = this.in.read(buffer, offset, length);
            if (bytesRead != -1) {
                this.counter += bytesRead;
            }
            return bytesRead;
        }
        catch (Exception e) {
            System.out.println("LimitedInputStream: Read timed out!");
            ErrorLog.log(this, "LimitedInputStream", "Read timed out!", e);
            return -1;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int numberOfBytesRead() {
        return this.counter;
    }

    public boolean getLimitReached() {
        return this.limitReached;
    }
}

