/*
 * Decompiled with CFR 0.152.
 */
package scone.robot;

import java.util.Properties;
import java.util.Vector;
import scone.robot.PageLoaderPoolStats;
import scone.robot.PageLoaderThread;
import scone.robot.QueueEntry;
import scone.robot.Robot;
import scone.robot.URLQueue;

class PageLoaderPool {
    private Robot _robot;
    private int _maxThreads = -1;
    private int _minThreads = -1;
    private int _maxIdleTime = -1;
    private int _priority = 5;
    private URLQueue _urlQueue;
    private Vector _availableThreads;
    private boolean _debug = false;

    PageLoaderPool(Properties props, Robot robot, URLQueue urlqueue) throws NumberFormatException, IllegalArgumentException {
        int n;
        this._robot = robot;
        this._urlQueue = urlqueue;
        this._availableThreads = new Vector();
        if (props == null) {
            return;
        }
        String o = props.getProperty("maxThreads");
        if (o != null) {
            n = Integer.parseInt(o);
            if (n < 1) {
                throw new IllegalArgumentException("maxThreads must be an integral value greater than 0");
            }
            this._maxThreads = n;
        }
        if ((o = props.getProperty("minThreads")) != null) {
            n = Integer.parseInt(o);
            if (n < 0) {
                throw new IllegalArgumentException("minThreads must be an integral value greater than or equal to 0");
            }
            if (n > this._maxThreads) {
                throw new IllegalArgumentException("minThreads cannot be greater than maxThreads");
            }
            this._minThreads = n;
        }
        if ((o = props.getProperty("maxIdleTime")) != null) {
            n = Integer.parseInt(o);
            if (n < 1) {
                throw new IllegalArgumentException("maxIdleTime must be an integral value greater than 0");
            }
            this._maxIdleTime = n;
        }
        if ((o = props.getProperty("priority")) != null) {
            n = Integer.parseInt(o);
            if (n < 1 || n > 10) {
                throw new IllegalArgumentException("priority must be an integral value between 1 and 10");
            }
            this._priority = n;
        }
        if ((o = props.getProperty("debug")) != null) {
            this._debug = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queue(QueueEntry qe) {
        Vector vector = this._availableThreads;
        synchronized (vector) {
            this._urlQueue.queue(qe);
            int index = this.findFirstIdleThread();
            if (index == -1) {
                if (this._maxThreads == -1 || this._availableThreads.size() < this._maxThreads) {
                    if (this._debug) {
                        System.out.println("Creating a new Thread...");
                    }
                    ThreadElement e = new ThreadElement(new PoolThread(this._availableThreads));
                    e._idle = false;
                    e._thread.start();
                    this._availableThreads.add(e);
                    return;
                }
                if (this._debug) {
                    System.out.println("Max Threads created and all threads in the pool are busy.");
                }
            } else {
                if (this._debug) {
                    System.out.println("Using an existing thread...");
                }
                ((ThreadElement)this._availableThreads.get(index))._idle = false;
                Thread thread = ((ThreadElement)this._availableThreads.get(index))._thread;
                synchronized (thread) {
                    ((ThreadElement)this._availableThreads.get(index))._thread.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PageLoaderPoolStats getStats() {
        Vector vector = this._availableThreads;
        synchronized (vector) {
            PageLoaderPoolStats stats = new PageLoaderPoolStats();
            stats.maxThreads = this._maxThreads;
            stats.minThreads = this._minThreads;
            stats.maxIdleTime = this._maxIdleTime;
            stats.pendingJobs = this._urlQueue.size();
            stats.numThreads = this._availableThreads.size();
            stats.jobsInProgress = this._availableThreads.size() - this.findNumIdleThreads();
            return stats;
        }
    }

    private int findNumIdleThreads() {
        int idleThreads = 0;
        int size = this._availableThreads.size();
        for (int i = 0; i < size; ++i) {
            if (!((ThreadElement)this._availableThreads.get(i))._idle) continue;
            ++idleThreads;
        }
        return idleThreads;
    }

    private int findFirstIdleThread() {
        int size = this._availableThreads.size();
        for (int i = 0; i < size; ++i) {
            if (!((ThreadElement)this._availableThreads.get(i))._idle) continue;
            return i;
        }
        return -1;
    }

    private int findMe() {
        int size = this._availableThreads.size();
        for (int i = 0; i < size; ++i) {
            if (((ThreadElement)this._availableThreads.get(i))._thread != Thread.currentThread()) continue;
            return i;
        }
        return -1;
    }

    private void removeMe() {
        int size = this._availableThreads.size();
        for (int i = 0; i < size; ++i) {
            if (((ThreadElement)this._availableThreads.get(i))._thread != Thread.currentThread()) continue;
            this._availableThreads.remove(i);
            return;
        }
    }

    private class PoolThread
    extends Thread {
        private Object _lock;

        public PoolThread(Object lock) {
            this._lock = lock;
            this.setPriority(PageLoaderPool.this._priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PageLoaderThread job = null;
            while (true) {
                Object object;
                block27: {
                    object = this._lock;
                    synchronized (object) {
                        if (PageLoaderPool.this._urlQueue.size() == 0) {
                            int index;
                            if (PageLoaderPool.this._debug) {
                                System.out.println("Idle Thread...");
                            }
                            if ((index = PageLoaderPool.this.findMe()) == -1) {
                                return;
                            }
                            ((ThreadElement)PageLoaderPool.this._availableThreads.get(index))._idle = true;
                            break block27;
                        }
                        QueueEntry qe = null;
                        URLQueue uRLQueue = PageLoaderPool.this._urlQueue;
                        synchronized (uRLQueue) {
                            qe = PageLoaderPool.this._urlQueue.dequeue();
                            qe.getRobotTask().addOpenUri(qe);
                            qe.getRobotTask().incOpenThreads();
                        }
                        if (qe.getRobotTask().getStartTime() == -1L) {
                            qe.getRobotTask().setStartTime();
                        }
                        job = new PageLoaderThread(PageLoaderPool.this._robot, qe);
                    }
                    job.run();
                    job = null;
                    continue;
                }
                try {
                    object = this;
                    synchronized (object) {
                        if (PageLoaderPool.this._maxIdleTime == -1) {
                            super.wait();
                        } else {
                            super.wait(PageLoaderPool.this._maxIdleTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Object object2 = this._lock;
                    synchronized (object2) {
                        if (PageLoaderPool.this._debug) {
                            System.out.println("Interrupted...");
                        }
                        PageLoaderPool.this.removeMe();
                    }
                    return;
                }
                object = this._lock;
                synchronized (object) {
                    if (PageLoaderPool.this._urlQueue.size() == 0 && PageLoaderPool.this._minThreads != -1 && PageLoaderPool.this._availableThreads.size() > PageLoaderPool.this._minThreads) {
                        if (PageLoaderPool.this._debug) {
                            System.out.println("Thread timed out...");
                        }
                        PageLoaderPool.this.removeMe();
                        return;
                    }
                }
            }
        }
    }

    private class ThreadElement {
        private boolean _idle;
        private Thread _thread;

        public ThreadElement(Thread thread) {
            this._thread = thread;
            this._idle = true;
        }
    }
}

